/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.transform.DiscreteSine;
import com.github.psambit9791.jdsp.transform._SineCosine;

public class InverseDiscreteSine
implements _SineCosine {
    private double[] signal;
    private double[] output = null;
    private int type;
    private _SineCosine.Normalization norm;

    private int inferType(int t) {
        int inf = 0;
        if (t == 1 || t == 4) {
            inf = t;
        } else if (t == 2) {
            inf = 3;
        } else if (t == 3) {
            inf = 2;
        }
        return inf;
    }

    public InverseDiscreteSine(double[] s, int type, _SineCosine.Normalization norm) throws IllegalArgumentException {
        if (type <= 0 || type > 4) {
            throw new IllegalArgumentException("Type must be between 1 and 4");
        }
        this.signal = s;
        this.type = this.inferType(type);
        this.norm = norm;
    }

    public InverseDiscreteSine(double[] s, _SineCosine.Normalization norm) {
        this.signal = s;
        this.type = this.inferType(2);
        this.norm = norm;
    }

    public InverseDiscreteSine(double[] s, int type) throws IllegalArgumentException {
        if (type <= 0 || type > 4) {
            throw new IllegalArgumentException("Type must be between 1 and 4");
        }
        this.signal = s;
        this.type = this.inferType(type);
        this.norm = _SineCosine.Normalization.STANDARD;
    }

    public InverseDiscreteSine(double[] s) {
        this.signal = s;
        this.type = this.inferType(2);
        this.norm = _SineCosine.Normalization.STANDARD;
    }

    @Override
    public void transform() {
        DiscreteSine dst = this.norm == _SineCosine.Normalization.STANDARD ? new DiscreteSine(this.signal, this.type, _SineCosine.Normalization.STANDARD) : new DiscreteSine(this.signal, this.type, _SineCosine.Normalization.ORTHOGONAL);
        dst.transform();
        this.output = dst.getMagnitude();
    }

    @Override
    public double[] getMagnitude() throws ExceptionInInitializerError {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute transform() function before returning result");
        }
        return this.output;
    }

    @Override
    public int getSignalLength() {
        return this.signal.length;
    }
}

