/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.transform;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.transform.DiscreteFourier;
import com.github.psambit9791.jdsp.transform.FastFourier;
import com.github.psambit9791.jdsp.transform._Fourier;
import com.github.psambit9791.jdsp.windows.Rectangular;
import com.github.psambit9791.jdsp.windows._Window;
import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;

public class ShortTimeFourier {
    private double[] signal;
    private _Fourier[] output = null;
    private final double Fs;
    private final int frameLength;
    private final int fourierLength;
    private final int overlap;
    private final _Window window;

    public ShortTimeFourier(double[] signal, int frameLength, int overlap, int fourierLength, _Window window, double Fs) {
        if (signal == null) {
            throw new IllegalArgumentException("Signal can not be null");
        }
        if (frameLength < 1) {
            throw new IllegalArgumentException("Frame length must be greater than 0");
        }
        if (overlap >= frameLength) {
            throw new IllegalArgumentException("Overlap size should be smaller than the frame length");
        }
        if (fourierLength < frameLength) {
            throw new IllegalArgumentException("Fourier length should be equal to or greater than the frame length");
        }
        if (window == null) {
            throw new IllegalArgumentException("Window can not be null");
        }
        this.signal = signal;
        this.frameLength = frameLength;
        this.overlap = overlap;
        this.fourierLength = fourierLength;
        this.window = window;
        this.Fs = Fs;
    }

    public ShortTimeFourier(double[] signal, int frameLength, int overlap, int fourierLength, _Window window) {
        this(signal, frameLength, overlap, fourierLength, window, 1.0);
    }

    public ShortTimeFourier(double[] signal, int frameLength, int overlap, int fourierLength) {
        this(signal, frameLength, overlap, fourierLength, new Rectangular(frameLength), 1.0);
    }

    public ShortTimeFourier(double[] signal, int frameLength, int overlap, _Window window) {
        this(signal, frameLength, overlap, frameLength, window, 1.0);
    }

    public ShortTimeFourier(double[] signal, int frameLength, int overlap) {
        this(signal, frameLength, overlap, frameLength, new Rectangular(frameLength), 1.0);
    }

    public ShortTimeFourier(double[] signal, int frameLength) {
        this(signal, frameLength, frameLength / 2, frameLength, new Rectangular(frameLength), 1.0);
    }

    public void transform() {
        int cols = (this.signal.length - this.frameLength) / (this.frameLength - this.overlap) + 1;
        this.output = new _Fourier[cols];
        int R = 0;
        int m = 0;
        while (R < cols) {
            double[] frame = Arrays.copyOfRange(this.signal, m, m + this.frameLength);
            frame = this.window.applyWindow(frame);
            if (this.fourierLength > this.frameLength) {
                frame = UtilMethods.zeroPadSignal(frame, this.fourierLength - this.frameLength);
            }
            _Fourier dft = frame.length > 200 ? new FastFourier(frame) : new DiscreteFourier(frame);
            dft.transform();
            this.output[R] = dft;
            ++R;
            m += this.frameLength - this.overlap;
        }
    }

    public double[][] spectrogram(boolean onlyPositive) {
        double[][] resultMag = this.getMagnitude(onlyPositive);
        double[][] result = new double[resultMag.length][resultMag[0].length];
        for (int c = 0; c < resultMag[0].length; ++c) {
            for (int r = 0; r < resultMag.length; ++r) {
                result[r][c] = Math.pow(resultMag[r][c], 2.0);
            }
        }
        return result;
    }

    public double[][] getMagnitude(boolean onlyPositive) {
        Complex[][] resultComplex = this.getComplex(onlyPositive);
        double[][] result = new double[resultComplex.length][resultComplex[0].length];
        for (int c = 0; c < resultComplex[0].length; ++c) {
            for (int r = 0; r < resultComplex.length; ++r) {
                result[r][c] = resultComplex[r][c].abs();
            }
        }
        return result;
    }

    public double[][] getPhaseRad(boolean onlyPositive) {
        Complex[][] resultComplex = this.getComplex(onlyPositive);
        double[][] result = new double[resultComplex.length][resultComplex[0].length];
        for (int c = 0; c < resultComplex[0].length; ++c) {
            for (int r = 0; r < resultComplex.length; ++r) {
                result[r][c] = resultComplex[r][c].getArgument();
            }
        }
        return result;
    }

    public double[][] getPhaseDeg(boolean onlyPositive) {
        Complex[][] resultComplex = this.getComplex(onlyPositive);
        double[][] result = new double[resultComplex.length][resultComplex[0].length];
        for (int c = 0; c < resultComplex[0].length; ++c) {
            for (int r = 0; r < resultComplex.length; ++r) {
                result[r][c] = Math.toDegrees(resultComplex[r][c].getArgument());
            }
        }
        return result;
    }

    public _Fourier[] getOutput() {
        this.checkOutput();
        return this.output;
    }

    public Complex[][] getComplex(boolean onlyPositive) {
        this.checkOutput();
        Complex[][] result = new Complex[this.output[0].getComplex(onlyPositive).length][this.output.length];
        for (int c = 0; c < this.output.length; ++c) {
            _Fourier dft = this.output[c];
            for (int r = 0; r < result.length; ++r) {
                result[r][c] = dft.getComplex(onlyPositive)[r];
            }
        }
        return result;
    }

    public double[] getFrequencyAxis(boolean onlyPositive) {
        this.checkOutput();
        double[] axis = new double[this.output[0].getComplex(onlyPositive).length];
        for (int i = 0; i < axis.length; ++i) {
            axis[i] = (double)i * this.Fs / (double)this.frameLength;
        }
        return axis;
    }

    public double[] getTimeAxis() {
        this.checkOutput();
        double[] axis = new double[this.output.length];
        for (int i = 0; i < axis.length; ++i) {
            axis[i] = (double)(i * (this.frameLength - this.overlap)) / this.Fs;
        }
        return axis;
    }

    private void checkOutput() {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute stft() function before returning result");
        }
    }
}

