/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.windows;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.windows._Window;

public class Kaiser
extends _Window {
    private double[] window;
    private final boolean sym;
    private final int len;
    private double beta;

    public Kaiser(int len, double beta, boolean sym) throws IllegalArgumentException {
        super(len);
        this.len = len;
        this.beta = beta;
        this.sym = sym;
        this.generateWindow();
    }

    public Kaiser(int len, double beta) throws IllegalArgumentException {
        this(len, beta, true);
    }

    public void setBeta(double beta) {
        this.beta = beta;
        this.generateWindow();
    }

    private void generateWindow() {
        int tempLen = super.extend(this.len, this.sym);
        double alpha = (double)(tempLen - 1) / 2.0;
        this.window = new double[tempLen];
        int[] temp = UtilMethods.arange(0, tempLen, 1);
        for (int i = 0; i < temp.length; ++i) {
            this.window[i] = this.beta * Math.sqrt(1.0 - Math.pow(((double)temp[i] - alpha) / alpha, 2.0));
        }
        this.window = UtilMethods.i0(this.window);
        this.window = UtilMethods.scalarArithmetic(this.window, UtilMethods.i0(this.beta), "div");
        this.window = super.truncate(this.window);
    }

    @Override
    public double[] getWindow() {
        return this.window;
    }
}

