/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.windows;

import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.windows._Window;

public class Poisson
extends _Window {
    private double[] window;
    private final boolean sym;
    private final int len;

    public Poisson(int len, boolean sym) throws IllegalArgumentException {
        super(len);
        this.len = len;
        this.sym = sym;
        this.generateWindow();
    }

    public Poisson(int len) throws IllegalArgumentException {
        this(len, true);
    }

    private void generateWindow() {
        int tempLen = super.extend(this.len, this.sym);
        double centre = ((double)tempLen - 1.0) / 2.0;
        this.window = UtilMethods.arange(0.0, (double)tempLen, 1.0);
        for (int i = 0; i < this.window.length; ++i) {
            this.window[i] = Math.exp(-Math.abs(this.window[i] - centre));
        }
        this.window = super.truncate(this.window);
    }

    @Override
    public double[] getWindow() {
        return this.window;
    }
}

