/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import no.uib.jsparklines.data.JSparklines3dDataSeries;
import no.uib.jsparklines.data.JSparklines3dDataset;
import no.uib.jsparklines.data.JSparklinesDataSeries;
import no.uib.jsparklines.data.JSparklinesDataset;
import no.uib.jsparklines.data.XYZDataPoint;
import no.uib.jsparklines.renderers.JSparklines3dTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesTableCellRenderer;
import no.uib.jsparklines.renderers.util.GradientColorCoding;
import org.jfree.chart.plot.PlotOrientation;

public class JSparklinesDemo
extends JFrame {
    private Color colorA = new Color(251, 51, 51);
    private Color colorB = new Color(51, 51, 251);
    private Color colorC = new Color(110, 196, 97);
    private JPanel backgroundPanel;
    private JComboBox multipleDataSeriesJComboBox;
    private JPanel multipleDataSeriesJPanel;
    private JScrollPane multipleDataSeriesJScrollPane;
    private JTable multipleDataSeriesJTable;
    private JComboBox multipleValuesJComboBox;
    private JPanel multipleValuesJPanel;
    private JScrollPane multipleValuesJScrollPane;
    private JTable multipleValuesJTable;
    private JCheckBox reference3dValuesJCheckBox;
    private JCheckBox referenceMultipleValuesJCheckBox;
    private JCheckBox showBothJCheckBox;
    private JCheckBox showGradientJCheckBox;
    private JCheckBox showJSparklinesJCheckBox;
    private JPanel singleValuesJPanel;
    private JScrollPane singleValuesJScrollPane;
    private JTable singleValuesJTable;
    private JComboBox treeDimensionalDataSeriesJComboBox;
    private JPanel treeDimensionalDataSeriesJPanel;
    private JScrollPane treeDimensionalDataSeriesJScrollPane;
    private JTable treeDimensionalDataSeriesJTable;

    public JSparklinesDemo() {
        this.initComponents();
        this.setAdditionalGuiProperties();
        this.addDataSingleValues();
        this.singleValuesJTable.getColumn("Fold Change").setCellRenderer(new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, (Double)-5.0, 5.0, this.colorB, this.colorA));
        this.singleValuesJTable.getColumn("Peptides").setCellRenderer(new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, (Double)80.0, this.colorC));
        this.singleValuesJTable.getColumn("Coverage").setCellRenderer(new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, (Double)100.0, this.colorC));
        ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Fold Change").getCellRenderer()).showNumberAndChart(this.showBothJCheckBox.isSelected(), 40);
        ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Peptides").getCellRenderer()).showNumberAndChart(this.showBothJCheckBox.isSelected(), 40);
        ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Coverage").getCellRenderer()).showNumberAndChart(this.showBothJCheckBox.isSelected(), 40);
        double maxValue = 10.0;
        this.addDataMultipleValues(maxValue);
        this.multipleValuesJTable.getColumn("Change").setCellRenderer(new JSparklinesTableCellRenderer(JSparklinesTableCellRenderer.PlotType.lineChart, PlotOrientation.VERTICAL, 0.0, maxValue));
        this.addDataMultipleDataSeries(maxValue);
        this.multipleDataSeriesJTable.getColumn("Change").setCellRenderer(new JSparklinesTableCellRenderer(JSparklinesTableCellRenderer.PlotType.areaChart, PlotOrientation.VERTICAL, 0.0, maxValue));
        int maxYValue = 100;
        this.add3dData(maxYValue);
        this.treeDimensionalDataSeriesJTable.getColumn("Spread").setCellRenderer(new JSparklines3dTableCellRenderer(JSparklines3dTableCellRenderer.PlotType.bubblePlot, -10.0, (double)maxYValue + 10.0, -10.0, (double)maxYValue + 10.0));
    }

    private void setAdditionalGuiProperties() {
        this.singleValuesJTable.getTableHeader().setReorderingAllowed(false);
        this.multipleValuesJTable.getTableHeader().setReorderingAllowed(false);
        this.multipleDataSeriesJTable.getTableHeader().setReorderingAllowed(false);
        this.treeDimensionalDataSeriesJTable.getTableHeader().setReorderingAllowed(false);
        this.singleValuesJTable.setAutoCreateRowSorter(true);
        this.multipleValuesJTable.setRowHeight(30);
        this.multipleDataSeriesJTable.setRowHeight(30);
        this.treeDimensionalDataSeriesJTable.setRowHeight(80);
        this.multipleValuesJTable.getColumn("Protein").setMaxWidth(70);
        this.multipleDataSeriesJTable.getColumn("Protein").setMaxWidth(70);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/line_plot.GIF")));
        this.setTitle("JSparklines " + this.getVersion() + " - Demo");
        this.singleValuesJScrollPane.getViewport().setOpaque(false);
        this.multipleValuesJScrollPane.getViewport().setOpaque(false);
        this.multipleDataSeriesJScrollPane.getViewport().setOpaque(false);
        this.treeDimensionalDataSeriesJScrollPane.getViewport().setOpaque(false);
        this.multipleValuesJComboBox.setRenderer(new ComboBoxListCellRenderer());
        this.multipleDataSeriesJComboBox.setRenderer(new ComboBoxListCellRenderer());
        this.treeDimensionalDataSeriesJComboBox.setRenderer(new ComboBoxListCellRenderer());
        this.setLocationRelativeTo(null);
    }

    private void addDataSingleValues() {
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein A", 4.44, 12, 30});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein B", -2.19, 11, 13});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein C", 1.86, 2, 5});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein D", -2.17, 17, 32});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein E", 3.01, 32, 57});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein F", 2.62, 12, 28});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein G", 5.33, 16, 37});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein H", 5.65, 47, 61});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein I", 1.81, 23, 45});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein J", -1.91, 78, 34});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein K", 2.6, 15, 31});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein L", 2.3, 31, 44});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein M", -2.45, 5, 14});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein N", 3.59, 18, 56});
        ((DefaultTableModel)this.singleValuesJTable.getModel()).addRow(new Object[]{"Protein O", 2.24, 25, 43});
    }

    private void addDataMultipleValues(double maxValue) {
        int NUMBER_OF_ROWS = 8;
        int NUMBER_OF_VALUES = 20;
        int MAX_VALUE = (int)maxValue;
        Random random = new Random();
        for (int j = 0; j < 8; ++j) {
            ArrayList<Double> dataA = new ArrayList<Double>();
            for (int i = 0; i < 20; ++i) {
                dataA.add(Double.valueOf(random.nextInt(MAX_VALUE)));
            }
            JSparklinesDataSeries sparklineDataseriesA = new JSparklinesDataSeries(dataA, this.colorA, "Dataset A");
            ArrayList<JSparklinesDataSeries> sparkLineDataSeriesAll = new ArrayList<JSparklinesDataSeries>();
            sparkLineDataSeriesAll.add(sparklineDataseriesA);
            JSparklinesDataset dataset = new JSparklinesDataset(sparkLineDataSeriesAll);
            ((DefaultTableModel)this.multipleValuesJTable.getModel()).addRow(new Object[]{"Protein " + (j + 1), dataset});
        }
    }

    private void addDataMultipleDataSeries(double maxValue) {
        int NUMBER_OF_ROWS = 8;
        int NUMBER_OF_VALUES = 20;
        int MAX_VALUE = (int)maxValue;
        Random random = new Random();
        for (int j = 0; j < 8; ++j) {
            ArrayList<Double> dataA = new ArrayList<Double>();
            ArrayList<Double> dataB = new ArrayList<Double>();
            ArrayList<Double> dataC = new ArrayList<Double>();
            for (int i = 0; i < 20; ++i) {
                dataA.add(Double.valueOf(random.nextInt(MAX_VALUE - 1)));
                dataB.add(Double.valueOf(random.nextInt(MAX_VALUE)));
                dataC.add(Double.valueOf(random.nextInt(MAX_VALUE + 1)));
            }
            JSparklinesDataSeries sparklineDataseriesA = new JSparklinesDataSeries(dataA, this.colorA, "Dataset A");
            JSparklinesDataSeries sparklineDataseriesB = new JSparklinesDataSeries(dataB, this.colorB, "Dataset B");
            JSparklinesDataSeries sparklineDataseriesC = new JSparklinesDataSeries(dataC, this.colorC, "Dataset C");
            ArrayList<JSparklinesDataSeries> sparkLineDataSeriesAll = new ArrayList<JSparklinesDataSeries>();
            sparkLineDataSeriesAll.add(sparklineDataseriesA);
            sparkLineDataSeriesAll.add(sparklineDataseriesB);
            sparkLineDataSeriesAll.add(sparklineDataseriesC);
            JSparklinesDataset dataset = new JSparklinesDataset(sparkLineDataSeriesAll);
            ((DefaultTableModel)this.multipleDataSeriesJTable.getModel()).addRow(new Object[]{"Protein " + (j + 1), dataset});
        }
    }

    private void add3dData(int maxYValue) {
        int NUMBER_OF_ROWS = 3;
        int NUMBER_OF_VALUES = 50;
        int MAX_Y_VALUE = maxYValue;
        int MAX_Z = 15;
        Random random = new Random();
        for (int j = 0; j < 3; ++j) {
            ArrayList<XYZDataPoint> dataA = new ArrayList<XYZDataPoint>();
            ArrayList<XYZDataPoint> dataB = new ArrayList<XYZDataPoint>();
            ArrayList<XYZDataPoint> dataC = new ArrayList<XYZDataPoint>();
            for (int i = 0; i < 50; ++i) {
                dataA.add(new XYZDataPoint(random.nextInt(40), random.nextInt(MAX_Y_VALUE), random.nextInt(15)));
                dataB.add(new XYZDataPoint(30 + random.nextInt(40), random.nextInt(MAX_Y_VALUE), random.nextInt(15)));
                dataC.add(new XYZDataPoint(60 + random.nextInt(40), random.nextInt(MAX_Y_VALUE), random.nextInt(15)));
            }
            JSparklines3dDataSeries sparkline3dDataseriesA = new JSparklines3dDataSeries(dataA, this.colorA, "Dataset A");
            JSparklines3dDataSeries sparkline3dDataseriesB = new JSparklines3dDataSeries(dataB, this.colorB, "Dataset B");
            JSparklines3dDataSeries sparkline3dDataseriesC = new JSparklines3dDataSeries(dataC, this.colorC, "Dataset C");
            ArrayList<JSparklines3dDataSeries> sparkLine3dDataSeriesAll = new ArrayList<JSparklines3dDataSeries>();
            sparkLine3dDataSeriesAll.add(sparkline3dDataseriesA);
            sparkLine3dDataSeriesAll.add(sparkline3dDataseriesB);
            sparkLine3dDataSeriesAll.add(sparkline3dDataseriesC);
            JSparklines3dDataset dataset = new JSparklines3dDataset(sparkLine3dDataSeriesAll);
            ((DefaultTableModel)this.treeDimensionalDataSeriesJTable.getModel()).addRow(new Object[]{"Protein " + (j + 1), dataset});
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.singleValuesJPanel = new JPanel();
        this.showJSparklinesJCheckBox = new JCheckBox();
        this.singleValuesJScrollPane = new JScrollPane();
        this.singleValuesJTable = new JTable(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return true;
            }
        };
        this.showBothJCheckBox = new JCheckBox();
        this.showGradientJCheckBox = new JCheckBox();
        this.multipleDataSeriesJPanel = new JPanel();
        this.multipleDataSeriesJScrollPane = new JScrollPane();
        this.multipleDataSeriesJTable = new JTable();
        this.multipleDataSeriesJComboBox = new JComboBox();
        this.treeDimensionalDataSeriesJPanel = new JPanel();
        this.treeDimensionalDataSeriesJScrollPane = new JScrollPane();
        this.treeDimensionalDataSeriesJTable = new JTable();
        this.treeDimensionalDataSeriesJComboBox = new JComboBox();
        this.reference3dValuesJCheckBox = new JCheckBox();
        this.multipleValuesJPanel = new JPanel();
        this.multipleValuesJScrollPane = new JScrollPane();
        this.multipleValuesJTable = new JTable();
        this.multipleValuesJComboBox = new JComboBox();
        this.referenceMultipleValuesJCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("JSparklines Demo");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.singleValuesJPanel.setBorder(BorderFactory.createTitledBorder("Single Values"));
        this.singleValuesJPanel.setOpaque(false);
        this.showJSparklinesJCheckBox.setSelected(true);
        this.showJSparklinesJCheckBox.setText("Sparklines");
        this.showJSparklinesJCheckBox.setToolTipText("Turn the sparklines on or off");
        this.showJSparklinesJCheckBox.setIconTextGap(8);
        this.showJSparklinesJCheckBox.setOpaque(false);
        this.showJSparklinesJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesDemo.this.showJSparklinesJCheckBoxActionPerformed(evt);
            }
        });
        this.singleValuesJScrollPane.setOpaque(false);
        this.singleValuesJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Protein", "Fold Change", "Peptides", "Coverage"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, Double.class, Integer.class, Double.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.singleValuesJTable.setFillsViewportHeight(true);
        this.singleValuesJTable.setOpaque(false);
        this.singleValuesJTable.setSelectionBackground(new Color(204, 204, 204));
        this.singleValuesJScrollPane.setViewportView(this.singleValuesJTable);
        this.showBothJCheckBox.setSelected(true);
        this.showBothJCheckBox.setText("Lines & Values");
        this.showBothJCheckBox.setToolTipText("<html>\nDisplay the chart <u>and</u> the number\n</html>");
        this.showBothJCheckBox.setIconTextGap(8);
        this.showBothJCheckBox.setOpaque(false);
        this.showBothJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesDemo.this.showBothJCheckBoxActionPerformed(evt);
            }
        });
        this.showGradientJCheckBox.setText("Gradient");
        this.showGradientJCheckBox.setToolTipText("Turn the gradient color coding on or off");
        this.showGradientJCheckBox.setIconTextGap(8);
        this.showGradientJCheckBox.setOpaque(false);
        this.showGradientJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesDemo.this.showGradientJCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout singleValuesJPanelLayout = new GroupLayout(this.singleValuesJPanel);
        this.singleValuesJPanel.setLayout(singleValuesJPanelLayout);
        singleValuesJPanelLayout.setHorizontalGroup(singleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, singleValuesJPanelLayout.createSequentialGroup().addContainerGap().addGroup(singleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.singleValuesJScrollPane, -1, 355, Short.MAX_VALUE).addGroup(singleValuesJPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.showJSparklinesJCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showBothJCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showGradientJCheckBox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        singleValuesJPanelLayout.setVerticalGroup(singleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, singleValuesJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.singleValuesJScrollPane, -1, 274, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(singleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showBothJCheckBox, -2, 26, -2).addComponent(this.showJSparklinesJCheckBox, -2, 26, -2).addComponent(this.showGradientJCheckBox, -2, 26, -2)).addContainerGap()));
        this.multipleDataSeriesJPanel.setBorder(BorderFactory.createTitledBorder("Multiple Data Series"));
        this.multipleDataSeriesJPanel.setOpaque(false);
        this.multipleDataSeriesJScrollPane.setOpaque(false);
        this.multipleDataSeriesJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Protein", "Change"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.multipleDataSeriesJTable.setFillsViewportHeight(true);
        this.multipleDataSeriesJTable.setOpaque(false);
        this.multipleDataSeriesJTable.setSelectionBackground(new Color(204, 204, 204));
        this.multipleDataSeriesJScrollPane.setViewportView(this.multipleDataSeriesJTable);
        this.multipleDataSeriesJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Line", "Area", "Bar", "Stack", "Stack %", "Box", "Pie", "Up/Down"}));
        this.multipleDataSeriesJComboBox.setSelectedIndex(1);
        this.multipleDataSeriesJComboBox.setToolTipText("Set the chart type");
        this.multipleDataSeriesJComboBox.setMaximumSize(new Dimension(48, 20));
        this.multipleDataSeriesJComboBox.setOpaque(false);
        this.multipleDataSeriesJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesDemo.this.multipleDataSeriesJComboBoxActionPerformed(evt);
            }
        });
        GroupLayout multipleDataSeriesJPanelLayout = new GroupLayout(this.multipleDataSeriesJPanel);
        this.multipleDataSeriesJPanel.setLayout(multipleDataSeriesJPanelLayout);
        multipleDataSeriesJPanelLayout.setHorizontalGroup(multipleDataSeriesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(multipleDataSeriesJPanelLayout.createSequentialGroup().addContainerGap().addGroup(multipleDataSeriesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multipleDataSeriesJScrollPane, -1, 355, Short.MAX_VALUE).addGroup(multipleDataSeriesJPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.multipleDataSeriesJComboBox, -2, 90, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        multipleDataSeriesJPanelLayout.setVerticalGroup(multipleDataSeriesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, multipleDataSeriesJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.multipleDataSeriesJScrollPane, -1, 268, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.multipleDataSeriesJComboBox, -2, -1, -2).addContainerGap()));
        this.treeDimensionalDataSeriesJPanel.setBorder(BorderFactory.createTitledBorder("2D/3D Data Series"));
        this.treeDimensionalDataSeriesJPanel.setOpaque(false);
        this.treeDimensionalDataSeriesJScrollPane.setOpaque(false);
        this.treeDimensionalDataSeriesJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Protein", "Spread"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.treeDimensionalDataSeriesJTable.setFillsViewportHeight(true);
        this.treeDimensionalDataSeriesJTable.setOpaque(false);
        this.treeDimensionalDataSeriesJTable.setSelectionBackground(new Color(204, 204, 204));
        this.treeDimensionalDataSeriesJScrollPane.setViewportView(this.treeDimensionalDataSeriesJTable);
        this.treeDimensionalDataSeriesJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Scatter", "Bubble"}));
        this.treeDimensionalDataSeriesJComboBox.setSelectedIndex(1);
        this.treeDimensionalDataSeriesJComboBox.setToolTipText("Set the chart type");
        this.treeDimensionalDataSeriesJComboBox.setMaximumSize(new Dimension(48, 20));
        this.treeDimensionalDataSeriesJComboBox.setOpaque(false);
        this.treeDimensionalDataSeriesJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesDemo.this.treeDimensionalDataSeriesJComboBoxActionPerformed(evt);
            }
        });
        this.reference3dValuesJCheckBox.setText("Reference");
        this.reference3dValuesJCheckBox.setToolTipText("Show reference area");
        this.reference3dValuesJCheckBox.setIconTextGap(8);
        this.reference3dValuesJCheckBox.setOpaque(false);
        this.reference3dValuesJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesDemo.this.reference3dValuesJCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout treeDimensionalDataSeriesJPanelLayout = new GroupLayout(this.treeDimensionalDataSeriesJPanel);
        this.treeDimensionalDataSeriesJPanel.setLayout(treeDimensionalDataSeriesJPanelLayout);
        treeDimensionalDataSeriesJPanelLayout.setHorizontalGroup(treeDimensionalDataSeriesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(treeDimensionalDataSeriesJPanelLayout.createSequentialGroup().addContainerGap().addGroup(treeDimensionalDataSeriesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(treeDimensionalDataSeriesJPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.treeDimensionalDataSeriesJComboBox, -2, 90, -2).addGap(18, 18, 18).addComponent(this.reference3dValuesJCheckBox).addContainerGap(-1, Short.MAX_VALUE)).addGroup(treeDimensionalDataSeriesJPanelLayout.createSequentialGroup().addComponent(this.treeDimensionalDataSeriesJScrollPane, -1, 354, Short.MAX_VALUE).addContainerGap()))));
        treeDimensionalDataSeriesJPanelLayout.setVerticalGroup(treeDimensionalDataSeriesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, treeDimensionalDataSeriesJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.treeDimensionalDataSeriesJScrollPane, -1, 272, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(treeDimensionalDataSeriesJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.treeDimensionalDataSeriesJComboBox, -2, -1, -2).addComponent(this.reference3dValuesJCheckBox)).addContainerGap()));
        this.multipleValuesJPanel.setBorder(BorderFactory.createTitledBorder("Multiple Values"));
        this.multipleValuesJPanel.setOpaque(false);
        this.multipleValuesJScrollPane.setOpaque(false);
        this.multipleValuesJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Protein", "Change"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.multipleValuesJTable.setOpaque(false);
        this.multipleValuesJTable.setSelectionBackground(new Color(204, 204, 204));
        this.multipleValuesJScrollPane.setViewportView(this.multipleValuesJTable);
        this.multipleValuesJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Line", "Area", "Bar", "Box", "Up/Down"}));
        this.multipleValuesJComboBox.setToolTipText("Set the chart type");
        this.multipleValuesJComboBox.setMaximumSize(new Dimension(48, 20));
        this.multipleValuesJComboBox.setOpaque(false);
        this.multipleValuesJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesDemo.this.multipleValuesJComboBoxActionPerformed(evt);
            }
        });
        this.referenceMultipleValuesJCheckBox.setText("Reference");
        this.referenceMultipleValuesJCheckBox.setToolTipText("Show reference area");
        this.referenceMultipleValuesJCheckBox.setIconTextGap(8);
        this.referenceMultipleValuesJCheckBox.setOpaque(false);
        this.referenceMultipleValuesJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesDemo.this.referenceMultipleValuesJCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout multipleValuesJPanelLayout = new GroupLayout(this.multipleValuesJPanel);
        this.multipleValuesJPanel.setLayout(multipleValuesJPanelLayout);
        multipleValuesJPanelLayout.setHorizontalGroup(multipleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(multipleValuesJPanelLayout.createSequentialGroup().addContainerGap().addGroup(multipleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(multipleValuesJPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.multipleValuesJComboBox, -2, 90, -2).addGap(18, 18, 18).addComponent(this.referenceMultipleValuesJCheckBox).addContainerGap(-1, Short.MAX_VALUE)).addGroup(multipleValuesJPanelLayout.createSequentialGroup().addComponent(this.multipleValuesJScrollPane, -1, 354, Short.MAX_VALUE).addContainerGap()))));
        multipleValuesJPanelLayout.setVerticalGroup(multipleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, multipleValuesJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.multipleValuesJScrollPane, -1, 268, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(multipleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.multipleValuesJComboBox, -2, -1, -2).addComponent(this.referenceMultipleValuesJCheckBox)).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.singleValuesJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.treeDimensionalDataSeriesJPanel, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addComponent(this.multipleValuesJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.multipleDataSeriesJPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.treeDimensionalDataSeriesJPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.singleValuesJPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.multipleDataSeriesJPanel, -1, -1, Short.MAX_VALUE).addComponent(this.multipleValuesJPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void showJSparklinesJCheckBoxActionPerformed(ActionEvent evt) {
        this.showBothJCheckBox.setEnabled(this.showJSparklinesJCheckBox.isSelected());
        this.showGradientJCheckBox.setEnabled(this.showJSparklinesJCheckBox.isSelected());
        ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Fold Change").getCellRenderer()).showNumbers(!this.showJSparklinesJCheckBox.isSelected());
        ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Peptides").getCellRenderer()).showNumbers(!this.showJSparklinesJCheckBox.isSelected());
        ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Coverage").getCellRenderer()).showNumbers(!this.showJSparklinesJCheckBox.isSelected());
        this.singleValuesJTable.revalidate();
        this.singleValuesJTable.repaint();
    }

    private void multipleValuesJComboBoxActionPerformed(ActionEvent evt) {
        String selectedPlotType = (String)this.multipleValuesJComboBox.getSelectedItem();
        if (selectedPlotType.equalsIgnoreCase("Line")) {
            ((JSparklinesTableCellRenderer)this.multipleValuesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.lineChart);
        } else if (selectedPlotType.equalsIgnoreCase("Bar")) {
            ((JSparklinesTableCellRenderer)this.multipleValuesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.barChart);
        } else if (selectedPlotType.equalsIgnoreCase("Area")) {
            ((JSparklinesTableCellRenderer)this.multipleValuesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.areaChart);
        } else if (selectedPlotType.equalsIgnoreCase("Box")) {
            ((JSparklinesTableCellRenderer)this.multipleValuesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.boxPlot);
        } else if (selectedPlotType.equalsIgnoreCase("Up/Down")) {
            ((JSparklinesTableCellRenderer)this.multipleValuesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.upDownChart);
        }
        if (selectedPlotType.equalsIgnoreCase("Box")) {
            ((JSparklinesTableCellRenderer)this.multipleValuesJTable.getColumn("Change").getCellRenderer()).setPlotOrientation(PlotOrientation.HORIZONTAL);
        } else {
            ((JSparklinesTableCellRenderer)this.multipleValuesJTable.getColumn("Change").getCellRenderer()).setPlotOrientation(PlotOrientation.VERTICAL);
        }
        this.multipleValuesJTable.revalidate();
        this.multipleValuesJTable.repaint();
    }

    private void multipleDataSeriesJComboBoxActionPerformed(ActionEvent evt) {
        String selectedPlotType = (String)this.multipleDataSeriesJComboBox.getSelectedItem();
        if (selectedPlotType.equalsIgnoreCase("Pie")) {
            this.multipleDataSeriesJTable.getColumn("Protein").setMaxWidth(Integer.MAX_VALUE);
            this.multipleDataSeriesJTable.getColumn("Change").setMaxWidth(this.multipleDataSeriesJTable.getRowHeight() + 30);
        } else {
            this.multipleDataSeriesJTable.getColumn("Protein").setMaxWidth(70);
            this.multipleDataSeriesJTable.getColumn("Change").setMaxWidth(Integer.MAX_VALUE);
        }
        if (selectedPlotType.equalsIgnoreCase("Line")) {
            ((JSparklinesTableCellRenderer)this.multipleDataSeriesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.lineChart);
        } else if (selectedPlotType.equalsIgnoreCase("Bar")) {
            ((JSparklinesTableCellRenderer)this.multipleDataSeriesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.barChart);
        } else if (selectedPlotType.equalsIgnoreCase("Pie")) {
            ((JSparklinesTableCellRenderer)this.multipleDataSeriesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.pieChart);
        } else if (selectedPlotType.equalsIgnoreCase("Stack")) {
            ((JSparklinesTableCellRenderer)this.multipleDataSeriesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.stackedBarChart);
        } else if (selectedPlotType.equalsIgnoreCase("Stack %")) {
            ((JSparklinesTableCellRenderer)this.multipleDataSeriesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.stackedPercentBarChart);
        } else if (selectedPlotType.equalsIgnoreCase("Area")) {
            ((JSparklinesTableCellRenderer)this.multipleDataSeriesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.areaChart);
        } else if (selectedPlotType.equalsIgnoreCase("Box")) {
            ((JSparklinesTableCellRenderer)this.multipleDataSeriesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.boxPlot);
        } else if (selectedPlotType.equalsIgnoreCase("Up/Down")) {
            ((JSparklinesTableCellRenderer)this.multipleDataSeriesJTable.getColumn("Change").getCellRenderer()).setPlotType(JSparklinesTableCellRenderer.PlotType.upDownChart);
        }
        if (selectedPlotType.equalsIgnoreCase("Box")) {
            ((JSparklinesTableCellRenderer)this.multipleDataSeriesJTable.getColumn("Change").getCellRenderer()).setPlotOrientation(PlotOrientation.HORIZONTAL);
        } else {
            ((JSparklinesTableCellRenderer)this.multipleDataSeriesJTable.getColumn("Change").getCellRenderer()).setPlotOrientation(PlotOrientation.VERTICAL);
        }
        this.multipleDataSeriesJTable.revalidate();
        this.multipleDataSeriesJTable.repaint();
    }

    private void referenceMultipleValuesJCheckBoxActionPerformed(ActionEvent evt) {
        if (this.referenceMultipleValuesJCheckBox.isSelected()) {
            ((JSparklinesTableCellRenderer)this.multipleValuesJTable.getColumn("Change").getCellRenderer()).addReferenceArea("Middle", 4.0, 6.0, Color.LIGHT_GRAY, 0.5f);
        } else {
            ((JSparklinesTableCellRenderer)this.multipleValuesJTable.getColumn("Change").getCellRenderer()).removeReferenceArea("Middle");
        }
        this.multipleValuesJTable.revalidate();
        this.multipleValuesJTable.repaint();
    }

    private void treeDimensionalDataSeriesJComboBoxActionPerformed(ActionEvent evt) {
        String selectedPlotType = (String)this.treeDimensionalDataSeriesJComboBox.getSelectedItem();
        if (selectedPlotType.equalsIgnoreCase("Scatter")) {
            ((JSparklines3dTableCellRenderer)this.treeDimensionalDataSeriesJTable.getColumn("Spread").getCellRenderer()).setPlotType(JSparklines3dTableCellRenderer.PlotType.scatterPlot);
        } else if (selectedPlotType.equalsIgnoreCase("Bubble")) {
            ((JSparklines3dTableCellRenderer)this.treeDimensionalDataSeriesJTable.getColumn("Spread").getCellRenderer()).setPlotType(JSparklines3dTableCellRenderer.PlotType.bubblePlot);
        }
        this.treeDimensionalDataSeriesJTable.revalidate();
        this.treeDimensionalDataSeriesJTable.repaint();
    }

    private void reference3dValuesJCheckBoxActionPerformed(ActionEvent evt) {
        if (this.reference3dValuesJCheckBox.isSelected()) {
            ((JSparklines3dTableCellRenderer)this.treeDimensionalDataSeriesJTable.getColumn("Spread").getCellRenderer()).addXAxisReferenceArea("DatasetB", 33.0, 66.0, Color.ORANGE, 0.3f);
        } else {
            ((JSparklines3dTableCellRenderer)this.treeDimensionalDataSeriesJTable.getColumn("Spread").getCellRenderer()).removeXAxisReferenceArea("DatasetB");
        }
        this.treeDimensionalDataSeriesJTable.revalidate();
        this.treeDimensionalDataSeriesJTable.repaint();
    }

    private void showBothJCheckBoxActionPerformed(ActionEvent evt) {
        ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Fold Change").getCellRenderer()).showNumberAndChart(this.showBothJCheckBox.isSelected(), 40);
        ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Peptides").getCellRenderer()).showNumberAndChart(this.showBothJCheckBox.isSelected(), 40);
        ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Coverage").getCellRenderer()).showNumberAndChart(this.showBothJCheckBox.isSelected(), 40);
        this.singleValuesJTable.revalidate();
        this.singleValuesJTable.repaint();
    }

    private void showGradientJCheckBoxActionPerformed(ActionEvent evt) {
        if (this.showGradientJCheckBox.isSelected()) {
            ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Peptides").getCellRenderer()).setGradientColoring(GradientColorCoding.ColorGradient.BlueWhiteGreen, false);
            ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Coverage").getCellRenderer()).setGradientColoring(GradientColorCoding.ColorGradient.BlueWhiteGreen, false);
            ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Fold Change").getCellRenderer()).setGradientColoring(GradientColorCoding.ColorGradient.BlueWhiteRed, false);
        } else {
            ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Peptides").getCellRenderer()).setGradientColoring(null, false);
            ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Coverage").getCellRenderer()).setGradientColoring(null, false);
            ((JSparklinesBarChartTableCellRenderer)this.singleValuesJTable.getColumn("Fold Change").getCellRenderer()).setGradientColoring(null, false);
        }
        this.singleValuesJTable.revalidate();
        this.singleValuesJTable.repaint();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JSparklinesDemo().setVisible(true);
            }
        });
    }

    public String getVersion() {
        Properties p = new Properties();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("jsparklines.properties");
            p.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p.getProperty("jsparklines.version");
    }

    public class ComboBoxListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            c.setOpaque(isSelected);
            if (isSelected || cellHasFocus) {
                c.setBackground(Color.LIGHT_GRAY);
            }
            c.setHorizontalAlignment(0);
            return c;
        }
    }

    public class NonOpaqueCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setOpaque(isSelected);
            return c;
        }
    }
}

