/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock.dragdrop;

import fr.proline.studio.dock.container.DockContainerTab;
import fr.proline.studio.dock.container.DockPosition;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class OverArea {
    private DockContainerTab m_container;
    private DockPosition m_position;
    private Rectangle m_zone;

    public OverArea(DockContainerTab container, DockPosition dockPosition) {
        this.m_container = container;
        this.m_position = dockPosition;
        JComponent c = container.getComponent();
        int position = dockPosition.getPosition();
        if (position >= 0) {
            Component tabComponent = ((JTabbedPane)c).getTabComponentAt(position);
            Point p = tabComponent.getLocationOnScreen();
            int MARGIN = 5;
            this.m_zone = new Rectangle(p.x - 5, p.y - 5, tabComponent.getWidth() + 10, tabComponent.getHeight() + 10);
        } else {
            Point p = c.getLocationOnScreen();
            this.m_zone = new Rectangle(p.x, p.y, c.getWidth(), c.getHeight());
            switch (position) {
                case -4: {
                    this.m_zone.height /= 2;
                    break;
                }
                case -5: {
                    this.m_zone.height /= 2;
                    this.m_zone.y += this.m_zone.height;
                    break;
                }
                case -2: {
                    this.m_zone.width /= 2;
                    break;
                }
                case -3: {
                    this.m_zone.width /= 2;
                    this.m_zone.x += this.m_zone.width;
                }
            }
        }
    }

    public DockContainerTab getDockContainerTab() {
        return this.m_container;
    }

    public DockPosition getPosition() {
        return this.m_position;
    }

    public Rectangle getZone(JComponent c) {
        Point p = new Point(this.m_zone.x, this.m_zone.y);
        SwingUtilities.convertPointFromScreen(p, c);
        Rectangle localZone = new Rectangle(p.x, p.y, this.m_zone.width, this.m_zone.height);
        return localZone;
    }
}

