/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterPanel;
import fr.proline.studio.filter.FilterStatus;
import fr.proline.studio.gui.DefaultDialog;
import java.awt.Dialog;
import java.awt.Window;

public class FilterDialog
extends DefaultDialog {
    private static FilterDialog m_singletonDialog = null;
    private Filter[] m_filters;
    private FilterPanel m_filterPanel;

    public static FilterDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new FilterDialog(parent);
        }
        m_singletonDialog.hideInfoPanel();
        return m_singletonDialog;
    }

    private FilterDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Filters");
        this.setDocumentationSuffix("id.2u6wntf");
        this.m_filterPanel = new FilterPanel(this);
        this.setInternalComponent(this.m_filterPanel);
    }

    public void setFilters(Filter[] filters) {
        for (Filter f : filters) {
            f.setDefined(f.isUsed());
        }
        this.m_filterPanel.setFilters(this.m_filters);
    }

    public Filter[] getFilters() {
        return this.m_filters;
    }

    @Override
    protected boolean okCalled() {
        Filter f;
        int i;
        for (i = 0; i < this.m_filters.length; ++i) {
            FilterStatus status;
            f = this.m_filters[i];
            if (!f.isDefined() || (status = f.checkValues()) == null) continue;
            this.setStatus(true, status.getError());
            this.highlight(status.getComponent());
            return false;
        }
        for (i = 0; i < this.m_filters.length; ++i) {
            f = this.m_filters[i];
            f.registerValues();
            f.clearComponents();
        }
        return true;
    }

    @Override
    protected boolean cancelCalled() {
        for (int i = 0; i < this.m_filters.length; ++i) {
            Filter f = this.m_filters[i];
            f.clearComponents();
        }
        return true;
    }
}

