/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.graphics.AbstractSelectionGesture;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Path2D;

public class SelectionGestureSquare
extends AbstractSelectionGesture {
    private static final float[] DASH1 = new float[]{10.0f};
    private static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, DASH1, 0.0f);
    private final Rectangle m_selectionRectangle = new Rectangle();
    private int m_x1;
    private int m_x2;
    private int m_y1;
    private int m_y2;

    @Override
    public void startSelection(int x, int y) {
        this.m_selectionRectangle.x = x;
        this.m_selectionRectangle.y = y;
        this.m_x1 = x;
        this.m_y1 = y;
        this.m_x2 = x;
        this.m_y2 = y;
        this.m_isSelecting = true;
        this.m_action = 0;
    }

    @Override
    public void continueSelection(int x, int y) {
        this.m_x2 = x;
        this.m_y2 = y;
        this.m_minX = Math.min(this.m_x1, this.m_x2);
        this.m_maxX = Math.max(this.m_x1, this.m_x2);
        this.m_minY = Math.min(this.m_y1, this.m_y2);
        this.m_maxY = Math.max(this.m_y1, this.m_y2);
        this.m_selectionRectangle.x = this.m_minX;
        this.m_selectionRectangle.y = this.m_minY;
        this.m_selectionRectangle.width = this.m_maxX - this.m_minX;
        this.m_selectionRectangle.height = this.m_maxY - this.m_minY;
    }

    @Override
    public void stopSelection(int x, int y) {
        this.continueSelection(x, y);
        this.m_isSelecting = false;
        this.m_action = Math.abs(this.m_y2 - this.m_y1) < 10 && Math.abs(this.m_x2 - this.m_x1) < 10 ? 1 : 2;
    }

    @Override
    public Point getClickPoint() {
        return new Point((this.m_x1 + this.m_x2) / 2, (this.m_y1 + this.m_y2) / 2);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.m_isSelecting) {
            return;
        }
        if (Math.abs(this.m_y2 - this.m_y1) < 10 && Math.abs(this.m_x2 - this.m_x1) < 10) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(CyclicColorPalette.BLUE_SELECTION_ZONE);
        Stroke sOld = g2.getStroke();
        g2.setStroke(DASHED_STROKE);
        ((Graphics2D)g).draw(this.m_selectionRectangle);
        g2.setStroke(sOld);
    }

    @Override
    public Path2D.Double getSelectionPath() {
        return new Path2D.Double(this.m_selectionRectangle);
    }
}

