/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.marker;

import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.LineMarker;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;

public class IntervalMarker
extends AbstractMarker {
    private double m_startValue;
    private double m_endValue;
    private LineMarker m_lineMarkerStart;
    private LineMarker m_lineMarkerEnd;
    private Color m_colorArea;
    private Color m_lineColor;

    public IntervalMarker(BasePlotPanel plotPanel, Color colorArea, Color lineColor, double startValue, double endValue) {
        super(plotPanel);
        this.m_colorArea = colorArea;
        this.m_lineColor = lineColor;
        this.m_startValue = startValue;
        this.m_endValue = endValue;
        this.m_lineMarkerStart = new LineMarker(plotPanel, startValue, lineColor);
        this.m_lineMarkerEnd = new LineMarker(plotPanel, endValue, lineColor);
    }

    @Override
    public void paint(Graphics2D g) {
        XAxis xAxis = this.m_plotPanel.getXAxis();
        YAxis yAxis = this.m_plotPanel.getYAxis();
        int sx = xAxis.valueToPixel(this.m_startValue);
        int ex = xAxis.valueToPixel(this.m_endValue);
        int y0 = yAxis.getY();
        int y1 = yAxis.getHeight();
        g.setComposite(AlphaComposite.getInstance(3, 0.1f));
        g.setColor(this.m_colorArea);
        g.fillRect(sx, y0, ex - sx, y1);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        this.m_lineMarkerStart.paint(g);
        this.m_lineMarkerEnd.paint(g);
    }

    @Override
    public AbstractMarker clone(BasePlotPanel plotPanel) throws CloneNotSupportedException {
        IntervalMarker clone = (IntervalMarker)super.clone(plotPanel);
        clone.m_lineMarkerEnd = (LineMarker)this.m_lineMarkerEnd.clone(plotPanel);
        clone.m_lineMarkerStart = (LineMarker)this.m_lineMarkerStart.clone(plotPanel);
        return clone;
    }
}

