/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.parallelcoordinates;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.MoveableInterface;
import fr.proline.studio.graphics.PlotParallelCoordinates;
import fr.proline.studio.graphics.parallelcoordinates.AbstractValue;
import fr.proline.studio.graphics.parallelcoordinates.NumberValue;
import fr.proline.studio.graphics.parallelcoordinates.StringValue;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ParallelCoordinatesAxis
implements MoveableInterface {
    public static final int AXIS_WIDTH = 10;
    public static final int PAD_Y_UP = 40;
    public static final int PAD_Y_DOWN = 20;
    public static final int PAD_HANDLE = 2;
    public static final int PAD_NAN = 20;
    private static final Color COLOR_TRANSPARENT_GRAY = new Color(164, 164, 164, 128);
    private static final Color COLOR_SELECTED = new Color(164, 80, 40, 128);
    protected Font m_valuesFont = null;
    protected FontMetrics m_valuesFontMetrics = null;
    private ArrayList<AbstractValue> m_values = null;
    private HashMap<Integer, AbstractValue> m_rowIndexToValueMap = null;
    private boolean m_hasNan = false;
    private boolean m_log = false;
    private int m_firstNonNanValueIndex = -1;
    private String m_columnName = null;
    private int m_x;
    private int m_y = 40;
    private int m_heightTotal;
    private boolean m_numericAxis;
    private boolean m_discreteAxis;
    private int m_id;
    private final PlotParallelCoordinates m_plot;
    private double m_selectionMinPercentage = 0.0;
    private double m_selectionMaxPercentage = 1.0;
    private int m_movingX = 0;
    private boolean m_displaySelected = false;
    private Double m_rangeMin = null;
    private Double m_rangeMax = null;
    private Double m_rangeMinWithNaN = null;
    private boolean m_forceNaN = false;
    private OverSubObject m_overSubObject = OverSubObject.NONE;

    public ParallelCoordinatesAxis(int id, ExtendedTableModelInterface compareDataInterface, int colId, PlotParallelCoordinates plot) {
        Class dataClass = compareDataInterface.getDataColumnClass(colId);
        this.m_id = id;
        this.m_plot = plot;
        this.m_values = new ArrayList(compareDataInterface.getRowCount());
        this.m_rowIndexToValueMap = new HashMap();
        if (dataClass.equals(String.class)) {
            this.prepareStringData(compareDataInterface, colId);
            this.m_numericAxis = false;
            this.m_discreteAxis = true;
            Collections.sort(this.m_values);
            this.m_firstNonNanValueIndex = this.m_values.size() - 1;
        } else if (dataClass.equals(Long.class) || dataClass.equals(Integer.class)) {
            this.prepareNumberData(compareDataInterface, colId);
            this.m_numericAxis = true;
            this.m_discreteAxis = true;
            Collections.sort(this.m_values, Collections.reverseOrder());
            this.m_firstNonNanValueIndex = this.m_values.size() - 1;
            this.m_rangeMin = ((NumberValue)this.m_values.get(this.m_firstNonNanValueIndex)).doubleValue();
            this.m_rangeMax = ((NumberValue)this.m_values.get(0)).doubleValue();
        } else {
            this.prepareNumberData(compareDataInterface, colId);
            this.m_numericAxis = true;
            this.m_discreteAxis = false;
            Collections.sort(this.m_values, Collections.reverseOrder());
            this.searchFirstNonNaNValue();
            this.m_rangeMin = ((NumberValue)this.m_values.get(this.m_firstNonNanValueIndex)).doubleValue();
            this.m_rangeMax = ((NumberValue)this.m_values.get(0)).doubleValue();
        }
        this.m_rangeMinWithNaN = this.m_rangeMin;
        this.m_columnName = compareDataInterface.getDataColumnIdentifier(colId);
        if (dataClass.equals(String.class)) {
            int iDiff = 0;
            String prev = null;
            for (int i = 0; i < this.m_values.size(); ++i) {
                String v = ((StringValue)this.m_values.get(i)).toString();
                if (prev != null && !prev.equals(v)) {
                    ++iDiff;
                }
                prev = v;
                this.m_values.get(i).setIndex(iDiff);
            }
        } else {
            for (int i = 0; i < this.m_values.size(); ++i) {
                this.m_values.get(i).setIndex(i);
            }
        }
    }

    public int getId() {
        return this.m_id;
    }

    public void setId(int id) {
        this.m_id = id;
    }

    public double getRealMaxValue() {
        return ((NumberValue)this.m_values.get(0)).doubleValue();
    }

    public double getRealMinValue() {
        return ((NumberValue)this.m_values.get(this.m_firstNonNanValueIndex)).doubleValue();
    }

    public void setRange(Double rangeMin, Double rangeMax, boolean forceNaN) {
        double vMin = (this.m_rangeMax - this.m_rangeMinWithNaN) * (1.0 - this.m_selectionMinPercentage) + this.m_rangeMinWithNaN;
        double vMax = (this.m_rangeMax - this.m_rangeMinWithNaN) * (1.0 - this.m_selectionMaxPercentage) + this.m_rangeMinWithNaN;
        this.m_rangeMin = rangeMin;
        this.m_rangeMinWithNaN = rangeMin;
        this.m_rangeMax = rangeMax;
        this.m_forceNaN = forceNaN;
        this.m_selectionMinPercentage = 1.0 - (vMin - this.m_rangeMin) / (this.m_rangeMax - this.m_rangeMin);
        this.m_selectionMaxPercentage = 1.0 - (vMax - this.m_rangeMin) / (this.m_rangeMax - this.m_rangeMin);
    }

    public void paint(Graphics2D g, int plotWidth) {
        if (this.m_valuesFont == null) {
            this.m_valuesFont = g.getFont().deriveFont(0, 10.0f);
            this.m_valuesFontMetrics = g.getFontMetrics(this.m_valuesFont);
        }
        g.setColor(Color.black);
        int x = this.getX();
        g.drawLine(x, this.m_y, x, this.m_y + this.m_heightTotal);
        int y1 = (int)Math.round((double)this.m_y + (double)this.m_heightTotal * this.m_selectionMinPercentage);
        int y2 = (int)Math.round((double)this.m_y + (double)this.m_heightTotal * this.m_selectionMaxPercentage);
        int height = (int)Math.round((double)this.m_heightTotal * (this.m_selectionMaxPercentage - this.m_selectionMinPercentage));
        g.setColor(this.m_displaySelected ? COLOR_SELECTED : COLOR_TRANSPARENT_GRAY);
        g.fillRect(this.m_x, y1, 10, height);
        g.setColor(Color.white);
        g.drawRect(this.m_x, y1, 10, height);
        int handleSize = 6;
        g.drawRect(this.m_x + 2, y1 + 2, handleSize, handleSize);
        g.drawRect(this.m_x + 2, y1 + height - 2 - handleSize, handleSize, handleSize);
        if (Math.abs(this.m_movingX) > 10) {
            g.setColor(Color.gray);
            g.drawLine(x + this.m_movingX, this.m_y, x + this.m_movingX, this.m_y + this.m_heightTotal);
            g.setColor(COLOR_TRANSPARENT_GRAY);
            g.fillRect(this.m_x + this.m_movingX, y1, 10, height);
            g.setColor(Color.lightGray);
            g.drawRect(this.m_x + this.m_movingX, y1, 10, height);
        }
        g.setFont(this.m_valuesFont);
        int fontHeight = this.m_valuesFontMetrics.getHeight();
        int textX = this.xForLabel(this.m_columnName, plotWidth);
        int textY = fontHeight + 4;
        if (this.m_displaySelected) {
            Rectangle2D r = this.m_valuesFontMetrics.getStringBounds(this.m_columnName, g);
            g.setColor(Color.white);
            g.fillRect((int)Math.round(r.getX()) + textX - 2, (int)Math.round(r.getY()) + textY, (int)Math.round(r.getWidth()) + 4, (int)Math.round(r.getHeight()));
        }
        g.setColor(Color.black);
        g.drawString(this.m_columnName, textX, textY);
        if (this.m_numericAxis) {
            Rectangle2D r;
            double vMin = this.m_rangeMinWithNaN;
            double vMax = ((NumberValue)this.m_values.get(0)).doubleValue();
            String min = this.m_discreteAxis ? (this.m_firstNonNanValueIndex == -1 || vMin < this.m_rangeMin ? "NaN" : Integer.toString((int)Math.round(Math.floor(this.m_rangeMin)))) : String.format("%6.5e", this.m_rangeMin);
            textX = this.xForLabel(min, plotWidth);
            textY = this.m_y + this.m_heightTotal + fontHeight + 4;
            if (this.m_displaySelected) {
                Rectangle2D r2 = this.m_valuesFontMetrics.getStringBounds(min, g);
                g.setColor(Color.white);
                g.fillRect((int)Math.round(r2.getX()) + textX - 2, (int)Math.round(r2.getY()) + textY, (int)Math.round(r2.getWidth()) + 4, (int)Math.round(r2.getHeight()));
            }
            g.setColor(Color.black);
            g.drawString(min, textX, textY);
            String max = this.m_discreteAxis ? (this.m_firstNonNanValueIndex == -1 || vMax < this.m_rangeMin ? "NaN" : Integer.toString((int)Math.round(Math.floor(this.m_rangeMax)))) : String.format("%6.5e", this.m_rangeMax);
            textX = this.xForLabel(max, plotWidth);
            textY = 20 + fontHeight + 4;
            if (this.m_displaySelected) {
                Rectangle2D r3 = this.m_valuesFontMetrics.getStringBounds(max, g);
                g.setColor(Color.white);
                g.fillRect((int)Math.round(r3.getX()) + textX - 2, (int)Math.round(r3.getY()) + textY, (int)Math.round(r3.getWidth()) + 4, (int)Math.round(r3.getHeight()));
            }
            g.setColor(Color.black);
            g.drawString(max, textX, textY);
            if (y1 > this.m_y) {
                double v = (this.m_rangeMax - this.m_rangeMinWithNaN) * (1.0 - this.m_selectionMinPercentage) + this.m_rangeMinWithNaN;
                String minValueSelected = this.m_discreteAxis ? (this.m_firstNonNanValueIndex == -1 || v < this.m_rangeMin ? "NaN" : Integer.toString((int)Math.round(Math.floor(v)))) : (this.m_firstNonNanValueIndex == -1 || v < this.m_rangeMin ? "NaN" : String.format("%6.5e", v));
                r = this.m_valuesFontMetrics.getStringBounds(minValueSelected, g);
                textX = this.xForLabel(minValueSelected, plotWidth);
                textY = y1 - fontHeight;
                g.setColor(Color.white);
                g.fillRect((int)Math.round(r.getX()) + textX - 2, (int)Math.round(r.getY()) + textY, (int)Math.round(r.getWidth()) + 4, (int)Math.round(r.getHeight()));
                g.setColor(Color.black);
                g.drawString(minValueSelected, textX, textY);
            }
            if (y2 < this.m_y + this.m_heightTotal) {
                double v = (this.m_rangeMax - this.m_rangeMinWithNaN) * (1.0 - this.m_selectionMaxPercentage) + this.m_rangeMinWithNaN;
                String maxValueSelected = this.m_discreteAxis ? (this.m_firstNonNanValueIndex == -1 || v < this.m_rangeMin ? "NaN" : Integer.toString((int)Math.round(Math.ceil(v)))) : (this.m_firstNonNanValueIndex == -1 || v < this.m_rangeMin ? "NaN" : String.format("%6.5e", v));
                r = this.m_valuesFontMetrics.getStringBounds(maxValueSelected, g);
                textX = this.xForLabel(maxValueSelected, plotWidth);
                textY = y2 + fontHeight + 4;
                g.setColor(Color.white);
                g.fillRect((int)Math.round(r.getX()) + textX - 2, (int)Math.round(r.getY()) + textY, (int)Math.round(r.getWidth()) + 4, (int)Math.round(r.getHeight()));
                g.setColor(Color.black);
                g.drawString(maxValueSelected, textX, textY);
            }
        } else {
            Rectangle2D r;
            String valueMin = this.m_values.get(0).toString();
            textX = this.xForLabel(valueMin, plotWidth);
            textY = 20 + fontHeight + 4;
            if (this.m_displaySelected) {
                Rectangle2D r4 = this.m_valuesFontMetrics.getStringBounds(valueMin, g);
                g.setColor(Color.white);
                g.fillRect((int)Math.round(r4.getX()) + textX - 2, (int)Math.round(r4.getY()) + textY, (int)Math.round(r4.getWidth()) + 4, (int)Math.round(r4.getHeight()));
            }
            g.setColor(Color.black);
            g.drawString(valueMin, textX, textY);
            String valueMax = this.m_values.get(this.m_values.size() - 1).toString();
            textX = this.xForLabel(valueMax, plotWidth);
            textY = this.m_y + this.m_heightTotal + fontHeight + 4;
            if (this.m_displaySelected) {
                Rectangle2D r5 = this.m_valuesFontMetrics.getStringBounds(valueMax, g);
                g.setColor(Color.white);
                g.fillRect((int)Math.round(r5.getX()) + textX - 2, (int)Math.round(r5.getY()) + textY, (int)Math.round(r5.getWidth()) + 4, (int)Math.round(r5.getHeight()));
            }
            g.setColor(Color.black);
            g.drawString(valueMax, textX, textY);
            if (y1 > this.m_y) {
                int index = (int)Math.round((double)(this.m_values.size() - 1) * this.m_selectionMinPercentage + 0.5);
                if (index > this.m_values.size() - 1) {
                    index = this.m_values.size() - 1;
                } else if (index < 0) {
                    index = 0;
                }
                valueMin = this.m_values.get(index).toString();
                r = this.m_valuesFontMetrics.getStringBounds(valueMin, g);
                textX = this.xForLabel(valueMin, plotWidth);
                textY = y1 - fontHeight;
                g.setColor(Color.white);
                g.fillRect((int)Math.round(r.getX()) + textX - 2, (int)Math.round(r.getY()) + textY, (int)Math.round(r.getWidth()) + 4, (int)Math.round(r.getHeight()));
                g.setColor(Color.black);
                g.drawString(valueMin, textX, textY);
            }
            if (y2 < this.m_y + this.m_heightTotal) {
                int index = (int)Math.round((double)(this.m_values.size() - 1) * this.m_selectionMaxPercentage - 0.5);
                if (index > this.m_values.size() - 1) {
                    index = this.m_values.size() - 1;
                } else if (index < 0) {
                    index = 0;
                }
                valueMax = this.m_values.get(index).toString();
                r = this.m_valuesFontMetrics.getStringBounds(valueMax, g);
                textX = this.xForLabel(valueMax, plotWidth);
                textY = y2 + fontHeight + 4;
                g.setColor(Color.white);
                g.fillRect((int)Math.round(r.getX()) + textX - 2, (int)Math.round(r.getY()) + textY, (int)Math.round(r.getWidth()) + 4, (int)Math.round(r.getHeight()));
                g.setColor(Color.black);
                g.drawString(valueMax, textX, textY);
            }
        }
    }

    private int xForLabel(String label, int plotWidth) {
        int stringWidth = this.m_valuesFontMetrics.stringWidth(label);
        int x = this.getX() - stringWidth / 2;
        if (x < 0) {
            x = 0;
        } else if (x + stringWidth >= plotWidth) {
            x = plotWidth - stringWidth - 1;
        }
        return x;
    }

    public void setPosition(int x, int height) {
        this.m_x = x;
        this.m_heightTotal = height - 40 - 20;
        this.manageNaN();
    }

    public boolean hasNaN() {
        return this.m_hasNan;
    }

    private void manageNaN() {
        if (this.m_hasNan || this.m_forceNaN) {
            int i;
            double naNValue;
            if (this.m_firstNonNanValueIndex == -1) {
                naNValue = 0.0;
            } else {
                double min = ((NumberValue)this.m_values.get(this.m_firstNonNanValueIndex)).doubleValue();
                double max = ((NumberValue)this.m_values.get(0)).doubleValue();
                naNValue = max == min ? min - 1.0 : max - (double)this.m_heightTotal * ((max - min) / (double)(this.m_heightTotal - 20));
                this.m_rangeMinWithNaN = naNValue;
            }
            for (i = this.m_values.size() - 1; i > this.m_firstNonNanValueIndex; --i) {
                ((NumberValue)this.m_values.get(i)).setValue(naNValue);
                ((NumberValue)this.m_values.get(i)).setError(true);
            }
            for (i = this.m_firstNonNanValueIndex; i >= 0; --i) {
                ((NumberValue)this.m_values.get(i)).setError(false);
            }
        }
    }

    private void putBackNaN() {
        for (int i = this.m_values.size() - 1; i > this.m_firstNonNanValueIndex; --i) {
            NumberValue v = (NumberValue)this.m_values.get(i);
            v.setValue(Double.NaN);
        }
    }

    private void setNegativeValuesAsNaN() {
        NumberValue v;
        int indexFound = -1;
        int i = this.m_firstNonNanValueIndex;
        while (i >= 0 && (v = (NumberValue)this.m_values.get(i)).doubleValue() < 1.0E-14) {
            v.setValue(Double.NaN);
            indexFound = i--;
        }
        if (indexFound != -1) {
            this.m_firstNonNanValueIndex = indexFound - 1;
        }
    }

    private void searchFirstNonNaNValue() {
        this.m_firstNonNanValueIndex = this.m_values.size() - 1;
        if (this.m_values.get(this.m_values.size() - 1).isNan()) {
            this.m_hasNan = true;
            this.m_firstNonNanValueIndex = -1;
            for (int i = this.m_values.size() - 1; i >= 0; --i) {
                if (this.m_values.get(i).isNan()) continue;
                this.m_firstNonNanValueIndex = i;
                break;
            }
        }
    }

    public boolean isRowIndexSelected(int rowIndex) {
        if (this.m_selectionMinPercentage <= 1.0E-10 && this.m_selectionMaxPercentage - 1.0 >= -1.0E-10) {
            return true;
        }
        AbstractValue v = this.m_rowIndexToValueMap.get(rowIndex);
        if (this.m_numericAxis) {
            double value = ((NumberValue)v).doubleValue();
            double vMin = this.m_rangeMinWithNaN;
            double vMax = this.m_rangeMax;
            double maxSelected = (vMax - vMin) * (1.0 - this.m_selectionMinPercentage) + vMin;
            if (value > maxSelected) {
                return false;
            }
            double minSelected = (vMax - vMin) * (1.0 - this.m_selectionMaxPercentage) + vMin;
            return !(value < minSelected);
        }
        int srcIndex = v.getIndex();
        int indexMin = (int)Math.round((double)(this.m_values.size() - 1) * this.m_selectionMinPercentage + 0.5 - 1.0E-10);
        int indexMax = (int)Math.round((double)(this.m_values.size() - 1) * this.m_selectionMaxPercentage - 0.5 + 1.0E-10);
        return indexMax >= srcIndex && indexMin <= srcIndex;
    }

    public int getPositionByRowIndex(int rowIndex) {
        return this.getRelativePositionByRowIndex(rowIndex) + this.m_y;
    }

    public int getRelativePositionByRowIndex(int rowIndex) {
        AbstractValue v = this.m_rowIndexToValueMap.get(rowIndex);
        if (this.m_numericAxis) {
            if (!this.m_hasNan && !this.m_forceNaN) {
                double min = this.m_rangeMin;
                double max = this.m_rangeMax;
                double value = ((NumberValue)v).doubleValue();
                return (int)((1.0 - (value - min) / (max - min)) * (double)this.m_heightTotal);
            }
            double min = this.m_rangeMinWithNaN;
            double max = this.m_rangeMax;
            double value = ((NumberValue)v).doubleValue();
            return (int)((1.0 - (value - min) / (max - min)) * (double)this.m_heightTotal);
        }
        int maxIndex = this.m_values.get(this.m_values.size() - 1).getIndex();
        if (maxIndex == 0) {
            maxIndex = 1;
        }
        return (int)Math.round((double)v.getIndex() / (double)maxIndex * (double)this.m_heightTotal);
    }

    public boolean isOnError(int rowIndex) {
        AbstractValue v = this.m_rowIndexToValueMap.get(rowIndex);
        return v.error();
    }

    public int getX() {
        return this.m_x + 5;
    }

    public int getHeight() {
        return this.m_heightTotal;
    }

    public int getRowIndexFromIndex(int index) {
        return this.m_values.get(index).getRowIndex();
    }

    private void prepareStringData(ExtendedTableModelInterface compareDataInterface, int colId) {
        int nbRows = compareDataInterface.getRowCount();
        for (int i = 0; i < nbRows; ++i) {
            String value = (String)compareDataInterface.getDataValueAt(i, colId);
            if (value == null) {
                value = "";
            }
            StringValue nValue = new StringValue(value, i);
            this.m_values.add(nValue);
            this.m_rowIndexToValueMap.put(i, nValue);
        }
    }

    private void prepareNumberData(ExtendedTableModelInterface compareDataInterface, int colId) {
        int nbRows = compareDataInterface.getRowCount();
        for (int i = 0; i < nbRows; ++i) {
            Number v = (Number)compareDataInterface.getDataValueAt(i, colId);
            NumberValue nValue = v != null ? new NumberValue(v, i) : new NumberValue(Double.NaN, i);
            this.m_values.add(nValue);
            this.m_rowIndexToValueMap.put(i, nValue);
        }
    }

    public boolean isLog() {
        return this.m_log;
    }

    public boolean canLog() {
        return this.m_numericAxis && !this.m_log;
    }

    public void log() {
        double vMin = (this.m_rangeMax - this.m_rangeMinWithNaN) * (1.0 - this.m_selectionMinPercentage) + this.m_rangeMinWithNaN;
        double vMax = (this.m_rangeMax - this.m_rangeMinWithNaN) * (1.0 - this.m_selectionMaxPercentage) + this.m_rangeMinWithNaN;
        vMin = Math.log10(vMin);
        vMax = Math.log10(vMax);
        this.m_log = true;
        this.putBackNaN();
        this.setNegativeValuesAsNaN();
        for (int i = this.m_firstNonNanValueIndex; i >= 0; --i) {
            NumberValue v = (NumberValue)this.m_values.get(i);
            v.log();
        }
        this.m_hasNan = this.m_firstNonNanValueIndex != -1;
        this.manageNaN();
        this.m_rangeMinWithNaN = this.m_rangeMin = Double.valueOf(((NumberValue)this.m_values.get(this.m_firstNonNanValueIndex)).doubleValue());
        this.m_rangeMax = ((NumberValue)this.m_values.get(0)).doubleValue();
        this.m_selectionMinPercentage = 1.0 - (vMin - this.m_rangeMin) / (this.m_rangeMax - this.m_rangeMin);
        this.m_selectionMaxPercentage = 1.0 - (vMax - this.m_rangeMin) / (this.m_rangeMax - this.m_rangeMin);
        this.m_columnName = "log10(" + this.m_columnName + ")";
    }

    public void doubleClicked() {
        if (this.m_selectionMinPercentage > 0.0 || this.m_selectionMaxPercentage < 1.0) {
            this.m_selectionMinPercentage = 0.0;
            this.m_selectionMaxPercentage = 1.0;
            this.setSelected(true, false);
            this.m_plot.axisChanged();
        }
    }

    public MoveableInterface getOverMovable(int x, int y) {
        if (x >= this.m_x && x <= this.m_x + 10 && y >= this.m_y && y <= this.m_y + this.m_heightTotal) {
            int y1 = (int)Math.round((double)this.m_y + (double)this.m_heightTotal * this.m_selectionMinPercentage);
            int y2 = (int)Math.round((double)this.m_y + (double)this.m_heightTotal * this.m_selectionMaxPercentage);
            this.m_overSubObject = y >= y1 && y <= y1 + 10 ? OverSubObject.HANDLE_UP : (y <= y2 && y >= y2 - 10 ? OverSubObject.HANDLE_BOTTOM : (y >= y1 && y <= y2 ? OverSubObject.SCROLLBAR : OverSubObject.NONE));
            this.m_movingX = 0;
            return this;
        }
        this.m_overSubObject = OverSubObject.NONE;
        return null;
    }

    @Override
    public boolean insideXY(int x, int y) {
        return true;
    }

    @Override
    public void moveDXY(int deltaX, int deltaY) {
        if (deltaY != 0) {
            double deltaMinHandle = 12.0 / (double)this.m_heightTotal;
            double percentageMove = (double)deltaY / (double)this.m_heightTotal;
            switch (this.m_overSubObject) {
                case HANDLE_UP: {
                    this.m_selectionMinPercentage += percentageMove;
                    if (this.m_selectionMinPercentage <= 0.0) {
                        this.m_selectionMinPercentage = 0.0;
                    } else if (this.m_selectionMinPercentage + deltaMinHandle >= this.m_selectionMaxPercentage) {
                        this.m_selectionMinPercentage = this.m_selectionMaxPercentage - deltaMinHandle;
                    }
                    this.m_plot.axisChanged();
                    break;
                }
                case HANDLE_BOTTOM: {
                    this.m_selectionMaxPercentage += percentageMove;
                    if (this.m_selectionMaxPercentage >= 1.0) {
                        this.m_selectionMaxPercentage = 1.0;
                    } else if (this.m_selectionMinPercentage + deltaMinHandle >= this.m_selectionMaxPercentage) {
                        this.m_selectionMaxPercentage = this.m_selectionMinPercentage + deltaMinHandle;
                    }
                    this.m_plot.axisChanged();
                    break;
                }
                case SCROLLBAR: {
                    if (this.m_selectionMinPercentage + percentageMove < 0.0) {
                        percentageMove = -this.m_selectionMinPercentage;
                    } else if (this.m_selectionMaxPercentage + percentageMove > 1.0) {
                        percentageMove = 1.0 - this.m_selectionMaxPercentage;
                    }
                    if (percentageMove == 0.0) break;
                    this.m_selectionMinPercentage += percentageMove;
                    this.m_selectionMaxPercentage += percentageMove;
                    this.m_plot.axisChanged();
                    break;
                }
            }
        }
        if (deltaX != 0 && !this.m_overSubObject.equals((Object)OverSubObject.HANDLE_BOTTOM) && !this.m_overSubObject.equals((Object)OverSubObject.HANDLE_UP)) {
            boolean plottingMovableAxis;
            boolean plottingMovableAxisPrevious = Math.abs(this.m_movingX) > 10;
            this.m_movingX += deltaX;
            boolean bl = plottingMovableAxis = Math.abs(this.m_movingX) > 10;
            if (plottingMovableAxisPrevious ^ plottingMovableAxis) {
                this.m_plot.axisIsMoving();
            }
        }
    }

    @Override
    public boolean isMoveable() {
        return true;
    }

    @Override
    public void snapToData(boolean isCtrlOrShiftDown) {
        this.m_plot.selectAxis(this, isCtrlOrShiftDown);
        if (Math.abs(this.m_movingX) > 5) {
            this.m_plot.axisMoved(this, this.m_movingX);
        }
        this.m_movingX = 0;
    }

    @Override
    public void setSelected(boolean s, boolean isCtrlOrShiftDown) {
        this.m_plot.selectAxis(this, isCtrlOrShiftDown);
    }

    public void displaySelected(boolean selected) {
        this.m_displaySelected = selected;
    }

    public boolean isSelected() {
        return this.m_displaySelected;
    }

    public boolean isNumeric() {
        return this.m_numericAxis;
    }

    private static enum OverSubObject {
        HANDLE_UP,
        HANDLE_BOTTOM,
        SCROLLBAR,
        NONE;

    }
}

