/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExportModelInterface;
import fr.proline.studio.export.ExportModelUtilities;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterProviderInterface;
import fr.proline.studio.graphics.BestGraphicsInterface;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.table.Column;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.DecoratedTableModelInterface;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public abstract class AbstractNonLazyTableModel
extends DecoratedTableModel
implements DecoratedTableModelInterface,
ExtendedTableModelInterface,
TableModel,
FilterProviderInterface,
BestGraphicsInterface,
ExportModelInterface {
    private String name;
    private Column[] m_columns;

    protected Column[] getColumns() {
        if (this.m_columns == null) {
            this.m_columns = Column.pack(this.getClass());
        }
        return this.m_columns;
    }

    @Override
    public int getColumnCount() {
        return this.getColumns().length;
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumns()[column].getName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getColumns()[columnIndex].getColumnClass();
    }

    @Override
    public Class getDataColumnClass(int columnIndex) {
        return this.getColumns()[columnIndex].getDataColumnClass();
    }

    @Override
    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    @Override
    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> getExternalData() {
        return null;
    }

    @Override
    public PlotInformation getPlotInformation() {
        return null;
    }

    @Override
    public String getToolTipForHeader(int col) {
        return this.getColumns()[col].getTooltip();
    }

    @Override
    public TableCellRenderer getRenderer(int row, int col) {
        return this.getColumns()[col].getRenderer();
    }

    @Override
    public String getExportRowCell(int row, int col) {
        return ExportModelUtilities.getExportRowCell(this, row, col);
    }

    @Override
    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    @Override
    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    @Override
    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        for (Column c : this.getColumns()) {
            Filter filter = c.getFilter();
            if (filter == null) continue;
            filtersMap.put(c.getIndex(), filter);
        }
    }

    @Override
    public PlotType getBestPlotType() {
        return null;
    }

    @Override
    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }
}

