/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.filter.BooleanFilter;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.LongFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.table.TableCellRenderer;

public class Column {
    public static TableCellRenderer DOUBLE_5DIGITS_RIGHT = new DoubleRenderer(new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 5);
    public static TableCellRenderer DOUBLE_2DIGITS_RIGHT = new DoubleRenderer(new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 4), 2);
    public static TableCellRenderer STRING_LEFT = new DefaultAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class), 2);
    private String name;
    private String tooltip;
    private Class type;
    private int index;
    private boolean isLazy;
    private Filter filter;
    private TableCellRenderer renderer;

    public Column(String name, String tooltip, Class type, int index, TableCellRenderer renderer) {
        this.name = name;
        this.tooltip = tooltip;
        this.type = type;
        this.index = index;
        this.isLazy = false;
        this.renderer = renderer;
    }

    public Column(String name, String tooltip, Class type, int index) {
        this(name, tooltip, type, index, null);
    }

    public Column(String name, Class type, int index) {
        this(name, name, type, index);
    }

    public static Column[] pack(Class modelClass) {
        Field[] declaredFields = modelClass.getFields();
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(Column.class)) continue;
            try {
                Column value = (Column)field.get(null);
                columns.add(value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        columns.sort(Comparator.comparingInt(Column::getIndex));
        return columns.toArray(new Column[0]);
    }

    public String getName() {
        return this.name;
    }

    public Class getColumnClass() {
        return this.isLazy ? LazyData.class : this.type;
    }

    public Class getDataColumnClass() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Filter getDefaultFilter() {
        if (Boolean.class.isAssignableFrom(this.type)) {
            return new BooleanFilter(this.getName(), null, this.getIndex());
        }
        if (String.class.isAssignableFrom(this.type)) {
            return new StringDiffFilter(this.getName(), null, this.getIndex());
        }
        if (Double.class.isAssignableFrom(this.type) || Float.class.isAssignableFrom(this.type)) {
            return new DoubleFilter(this.getName(), null, this.getIndex());
        }
        if (Integer.class.isAssignableFrom(this.type)) {
            return new IntegerFilter(this.getName(), null, this.getIndex());
        }
        if (Long.class.isAssignableFrom(this.type)) {
            return new LongFilter(this.getName(), null, this.getIndex());
        }
        return null;
    }

    public Filter getFilter() {
        if (this.filter == null) {
            this.filter = this.getDefaultFilter();
        }
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public TableCellRenderer getRenderer() {
        return this.renderer;
    }
}

