/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.brucker.timstof;

import fr.profi.brucker.timstof.TDFLibrary;
import fr.profi.util.StringUtils;
import fr.profi.util.ThreadLogger;
import fr.profi.util.system.OSInfo;
import fr.profi.util.system.OSType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDFNativeLibrariesFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TDFNativeLibrariesFactory.class);
    private static final String LINUX_LIBRARY_NAME = "libtimsdata.so";
    private static final String LINUX_AMD64_LIBRARY_PATHNAME = "native/Linux/amd64/libtimsdata.so";
    private static final String WINDOWS_LIBRARY_NAME = "timsdata.dll";
    private static final String WINDOWS_X86_LIBRARY_PATHNAME = "native/Windows/x86/timsdata.dll";
    private static final String WINDOWS_AMD64_LIBRARY_PATHNAME = "native/Windows/amd64/timsdata.dll";
    private static final String TMP_DIR_KEY = "java.io.tmpdir";
    private static final String LINUX_NUMERIC_LOCALE_KEY = "LC_NUMERIC";
    private static final String LINUX_LOCALE_KEY = "LC_ALL";
    private static final String LINUX_LANG_KEY = "LANG";
    private static final int BUFFER_SIZE = 8192;
    private static final Object LOADER_LOCK = new Object();
    private static boolean loaded;
    private static TDFLibrary tdfLib;

    private TDFNativeLibrariesFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TDFLibrary loadAndGetNativeLibraries() {
        Object object = LOADER_LOCK;
        synchronized (object) {
            if (!loaded) {
                Thread currentThread = Thread.currentThread();
                if (!(currentThread.getUncaughtExceptionHandler() instanceof ThreadLogger)) {
                    currentThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(LOG));
                }
                LOG.debug("Loading Brucker Timstof native libraries");
                OSType osType = OSInfo.getOSType();
                if (osType == null) {
                    LOG.warn("Unable to detect running OS Type");
                } else {
                    LOG.debug("Detected OS Type {}", (Object)osType);
                    String libraryPathname = null;
                    String targetLibraryName = null;
                    switch (osType) {
                        case LINUX_AMD64: {
                            TDFNativeLibrariesFactory.checkLinuxLocale();
                            libraryPathname = LINUX_AMD64_LIBRARY_PATHNAME;
                            targetLibraryName = LINUX_LIBRARY_NAME;
                            break;
                        }
                        case WINDOWS_X86: {
                            libraryPathname = WINDOWS_X86_LIBRARY_PATHNAME;
                            targetLibraryName = WINDOWS_LIBRARY_NAME;
                            break;
                        }
                        case WINDOWS_AMD64: {
                            libraryPathname = WINDOWS_AMD64_LIBRARY_PATHNAME;
                            targetLibraryName = WINDOWS_LIBRARY_NAME;
                        }
                    }
                    if (libraryPathname != null) {
                        File nativeLibrary = TDFNativeLibrariesFactory.extractLibrary(libraryPathname, targetLibraryName);
                        if (nativeLibrary != null && nativeLibrary.isFile()) {
                            String nativeLibraryAbsolutePathname = nativeLibrary.getAbsolutePath();
                            LOG.debug("Loading [{}]", (Object)nativeLibraryAbsolutePathname);
                            tdfLib = TDFLibrary.getInstance(nativeLibraryAbsolutePathname);
                            LOG.info("Library [{}] successfully loaded", (Object)nativeLibraryAbsolutePathname);
                            loaded = true;
                        } else {
                            LOG.warn("Invalid extracted [{}] file", (Object)targetLibraryName);
                        }
                    } else {
                        LOG.warn("No known native library for OS Type {}", (Object)osType);
                    }
                }
            }
        }
        return tdfLib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractLibrary(String libraryPathname, String targetLibraryName) {
        File result = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            is = classLoader.getResourceAsStream(libraryPathname);
            if (is == null) {
                LOG.warn("Cannot find [{}] library", (Object)libraryPathname);
            } else {
                String tmpDirPathname = System.getProperty(TMP_DIR_KEY);
                if (tmpDirPathname == null) {
                    LOG.warn("Unable to retrieve \"{}\" system property", (Object)TMP_DIR_KEY);
                } else {
                    File tmpDir = new File(tmpDirPathname);
                    if (tmpDir.isDirectory()) {
                        File targetLibraryFile = new File(tmpDir, targetLibraryName);
                        LOG.debug("Extracting [{}] to [{}]", (Object)libraryPathname, (Object)targetLibraryFile.getAbsoluteFile());
                        os = new FileOutputStream(targetLibraryFile);
                        byte[] buffer = new byte[8192];
                        int readLength = is.read(buffer);
                        while (readLength != -1) {
                            os.write(buffer, 0, readLength);
                            readLength = is.read(buffer);
                        }
                        result = targetLibraryFile;
                    } else {
                        LOG.warn("Invalid temp directory [{}]", (Object)tmpDirPathname);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Error extracting [" + libraryPathname + ']', (Throwable)ex);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException exClose) {
                    result = null;
                    LOG.error("Error closing [" + targetLibraryName + "] OutputStream", (Throwable)exClose);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException exClose) {
                    LOG.error("Error closing [" + libraryPathname + "] InputStream", (Throwable)exClose);
                }
            }
        }
        return result;
    }

    private static void checkLinuxLocale() {
        String linuxNativeLocale = System.getenv(LINUX_NUMERIC_LOCALE_KEY);
        if (StringUtils.isEmpty((String)linuxNativeLocale) && StringUtils.isEmpty((String)(linuxNativeLocale = System.getenv(LINUX_LOCALE_KEY)))) {
            linuxNativeLocale = System.getenv(LINUX_LANG_KEY);
        }
        String englishLanguage = Locale.ENGLISH.getLanguage();
        if (StringUtils.isEmpty((String)linuxNativeLocale)) {
            Locale javaLocale = Locale.getDefault();
            if (!englishLanguage.equals(javaLocale.getLanguage())) {
                LOG.warn("Linux TimsTof library expects ENGLISH locale, current Java locale: " + javaLocale);
            }
        } else if (!linuxNativeLocale.startsWith(englishLanguage)) {
            LOG.warn("Linux TimsTof library expects ENGLISH locale, current system locale: " + linuxNativeLocale);
        }
    }
}

