/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.brucker.timstof.model;

import it.unimi.dsi.fastutil.doubles.Double2FloatMap;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.util.Arrays;

public class Spectrum {
    private String m_title;
    private int index;
    private int msLevel;
    private float retentionTime;
    private double[] m_masses;
    private float[] m_intensities;

    public Spectrum(String title, int msLevel, float retentionTime, double[] masses, float[] intensities) {
        this.m_title = title;
        this.msLevel = msLevel;
        this.retentionTime = retentionTime;
        this.m_masses = masses;
        this.m_intensities = intensities;
    }

    public Spectrum(String title, int msLevel, float retentionTime, Double2FloatMap masses2Intensities) {
        this.m_title = title;
        this.msLevel = msLevel;
        this.retentionTime = retentionTime;
        DoubleArrayList masses = new DoubleArrayList((DoubleCollection)masses2Intensities.keySet());
        masses.sort(DoubleComparators.NATURAL_COMPARATOR);
        this.m_masses = new double[masses.size()];
        this.m_intensities = new float[masses.size()];
        int i = 0;
        DoubleListIterator doubleListIterator = masses.iterator();
        while (doubleListIterator.hasNext()) {
            double mass;
            this.m_masses[i] = mass = ((Double)doubleListIterator.next()).doubleValue();
            this.m_intensities[i] = masses2Intensities.get(mass);
            ++i;
        }
    }

    void addPeaks(double[] masses, float[] intensities) {
        if (masses.length != intensities.length) {
            throw new IllegalArgumentException("Specified masses and intensities array must have same length ");
        }
        double[] newMasses = Arrays.copyOf(this.m_masses, this.m_masses.length + masses.length);
        float[] newIntensities = Arrays.copyOf(this.m_intensities, this.m_intensities.length + intensities.length);
        for (int i = this.m_masses.length; i < newMasses.length; ++i) {
            newMasses[i] = masses[i - this.m_masses.length];
            newIntensities[i] = intensities[i - this.m_masses.length];
        }
        this.m_masses = newMasses;
        this.m_intensities = newIntensities;
    }

    void addPeaks(Double2FloatMap masses2Intensities) {
        DoubleArrayList masses = new DoubleArrayList((DoubleCollection)masses2Intensities.keySet());
        masses.sort(DoubleComparators.NATURAL_COMPARATOR);
        double[] newMasses = Arrays.copyOf(this.m_masses, this.m_masses.length + masses.size());
        float[] newIntensities = Arrays.copyOf(this.m_intensities, this.m_intensities.length + masses.size());
        int i = this.m_masses.length;
        DoubleListIterator doubleListIterator = masses.iterator();
        while (doubleListIterator.hasNext()) {
            double mass;
            newMasses[i] = mass = ((Double)doubleListIterator.next()).doubleValue();
            newIntensities[i] = masses2Intensities.get(mass);
            ++i;
        }
        this.m_masses = newMasses;
        this.m_intensities = newIntensities;
    }

    public double[] getMasses() {
        return this.m_masses;
    }

    public float[] getIntensities() {
        return this.m_intensities;
    }

    public String getTitle() {
        return this.m_title;
    }
}

