/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.brucker.timstof.model;

import fr.profi.brucker.timstof.converter.SpectrumGeneratingMethod;
import fr.profi.brucker.timstof.model.AbstractTimsFrame;
import fr.profi.brucker.timstof.model.PasefMsMsData;
import fr.profi.brucker.timstof.model.Spectrum;
import it.unimi.dsi.fastutil.doubles.Double2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;

public class TimsPASEFFrame
extends AbstractTimsFrame {
    private Int2ObjectMap<PasefMsMsData> m_pasefMsMsInfoByPrecursor = new Int2ObjectOpenHashMap();

    public TimsPASEFFrame(int id, int nbrScans, int nbrPeaks, int scanMode, int maxIntensity, int summedIntensity, double time) {
        super(id, nbrScans, nbrPeaks, scanMode, AbstractTimsFrame.MsMsType.PASEF, maxIntensity, summedIntensity, time);
    }

    @Override
    public void clearSpectraData() {
        super.clearSpectraData();
        for (PasefMsMsData msmsData : this.m_pasefMsMsInfoByPrecursor.values()) {
            msmsData.resetSpectrumData();
        }
    }

    @Override
    public void setMassIntensityByScan(Int2ObjectMap<Double2FloatMap> massIntByScan) {
        IntIterator scansIdIt = massIntByScan.keySet().iterator();
        while (scansIdIt.hasNext()) {
            int scId = scansIdIt.nextInt();
            Double2FloatMap massInt = (Double2FloatMap)massIntByScan.get(scId);
            for (PasefMsMsData msmsData : this.m_pasefMsMsInfoByPrecursor.values()) {
                if (!msmsData.containsScan(scId)) continue;
                msmsData.addSpectrumData(massInt);
            }
        }
        this.m_spectrumDataSet = true;
    }

    public IntArrayList getPrecursorIds() {
        if (this.m_pasefMsMsInfoByPrecursor != null) {
            return new IntArrayList((IntCollection)this.m_pasefMsMsInfoByPrecursor.keySet());
        }
        return null;
    }

    public Spectrum getPrecursorSpectrum(int precursorIndex) {
        if (this.m_pasefMsMsInfoByPrecursor != null && this.m_spectrumDataSet) {
            return ((PasefMsMsData)this.m_pasefMsMsInfoByPrecursor.get(precursorIndex)).getPasefSpectrum();
        }
        return null;
    }

    public double getPrecursorCollisionEnergy(int precursorIndex) {
        if (this.m_pasefMsMsInfoByPrecursor != null && this.m_spectrumDataSet) {
            return ((PasefMsMsData)this.m_pasefMsMsInfoByPrecursor.get(precursorIndex)).getCollisionEnergy();
        }
        return 0.0;
    }

    @Override
    public ObjectList<Spectrum> getAllSpectra() {
        if (!this.m_spectrumDataSet) {
            return null;
        }
        ObjectArrayList allSp = new ObjectArrayList();
        ObjectIterator pasefMsMsDataIt = this.m_pasefMsMsInfoByPrecursor.values().iterator();
        while (pasefMsMsDataIt.hasNext()) {
            allSp.add((Object)((PasefMsMsData)pasefMsMsDataIt.next()).getPasefSpectrum());
        }
        return allSp;
    }

    @Override
    public int getSpectrumCount() {
        if (this.m_pasefMsMsInfoByPrecursor != null) {
            return this.m_pasefMsMsInfoByPrecursor.size();
        }
        return 0;
    }

    @Override
    public void createSingleSpectrum(SpectrumGeneratingMethod msCreateMethod) {
        switch (msCreateMethod) {
            case FULL: {
                this.createSingleSpFromAllSpectra();
                break;
            }
            case SMOOTH: {
                throw new IllegalArgumentException("Smooth method not supported for PASEF Spectra Frames");
            }
        }
    }

    public List<PasefMsMsData> getPasefMsMSData() {
        return new ObjectArrayList(this.m_pasefMsMsInfoByPrecursor.values());
    }

    public void setPasefMsMsData(List<PasefMsMsData> pasefMsMsInfo) {
        pasefMsMsInfo.forEach(pMsms -> {
            PasefMsMsData cfr_ignored_0 = (PasefMsMsData)this.m_pasefMsMsInfoByPrecursor.put(pMsms.getPrecursorId(), pMsms);
        });
    }
}

