/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam;

import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.AccessDatabaseWorkerPool;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import org.slf4j.LoggerFactory;

public class AccessDatabaseWorkerThread
extends Thread {
    private AbstractDatabaseTask m_action = null;
    private static int m_threadCounter = 0;
    private AccessDatabaseWorkerPool m_workerPool = null;

    public AccessDatabaseWorkerThread(AccessDatabaseWorkerPool workerPool) {
        super("AccessDatabaseWorkerThread" + m_threadCounter);
        ++m_threadCounter;
        this.m_workerPool = workerPool;
    }

    public synchronized boolean isAvailable() {
        return this.m_action == null;
    }

    public synchronized void setAction(AbstractDatabaseTask action) {
        this.m_action = action;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                AbstractDatabaseTask action = null;
                AccessDatabaseWorkerThread accessDatabaseWorkerThread = this;
                synchronized (accessDatabaseWorkerThread) {
                    while (true) {
                        if (this.m_action != null) break;
                        this.wait();
                    }
                    action = this.m_action;
                    this.notifyAll();
                }
                action.getTaskInfo().setRunning(true);
                boolean success = action.fetchData();
                action.callback(success, !action.hasSubTasksToBeDone());
                AccessDatabaseThread.getAccessDatabaseThread().actionDone(action);
                AccessDatabaseWorkerThread accessDatabaseWorkerThread2 = this;
                synchronized (accessDatabaseWorkerThread2) {
                    this.m_action = null;
                }
                this.m_workerPool.threadFinished();
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger("ProlineStudio.DAM").debug("Unexpected exception in main loop of AccessDatabaseWorkerThread", t);
            return;
        }
    }
}

