/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.data;

import fr.proline.core.orm.uds.RawFile;
import fr.proline.core.orm.uds.Run;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.io.File;
import java.util.HashMap;
import java.util.List;

public class RunInfoData
extends AbstractData {
    public Status m_status = Status.NOT_INITIALIZED;
    private File m_rawFileOnDisk = null;
    private RawFile m_linkedRawFile = null;
    private RawFile m_selectedRawFile = null;
    private String m_peakListPath = null;
    private Run m_run = null;
    private String m_message = null;
    private HashMap<String, RawFile> m_potentialRawFileMap = null;

    public void setStatus(Status status) {
        this.m_status = status;
    }

    public Status getStatus() {
        return this.m_status;
    }

    public void setPotentialRawFiles(HashMap<String, RawFile> potentialRawFileMap) {
        this.m_potentialRawFileMap = potentialRawFileMap;
    }

    public void addPotentialRawFiles(RawFile linkedFile) {
        String fileName;
        if (this.m_potentialRawFileMap == null) {
            this.m_potentialRawFileMap = new HashMap();
        }
        if (this.m_potentialRawFileMap.get(fileName = linkedFile.getRawFileName()) == null) {
            this.m_potentialRawFileMap.put(fileName, linkedFile);
        }
    }

    public boolean hasPotentialRawFiles() {
        return this.m_potentialRawFileMap != null && !this.m_potentialRawFileMap.isEmpty();
    }

    public HashMap<String, RawFile> getPotentialRawFiles() {
        return this.m_potentialRawFileMap;
    }

    public void setPeakListPath(String peakListPath) {
        this.m_peakListPath = peakListPath;
    }

    public String getPeakListPath() {
        return this.m_peakListPath;
    }

    public void setMessage(String message) {
        this.m_message = message;
    }

    public boolean hasRawFile() {
        return this.m_linkedRawFile != null || this.m_selectedRawFile != null || this.m_rawFileOnDisk != null;
    }

    public boolean isRunInfoInDatabase() {
        if (this.m_linkedRawFile != null) {
            return true;
        }
        return this.m_selectedRawFile != null && this.m_selectedRawFile.getOwnerId() != 0L;
    }

    @Override
    public String getName() {
        String name = null;
        if (this.m_linkedRawFile != null) {
            name = this.m_linkedRawFile.getMzDbFileName();
        } else if (this.m_selectedRawFile != null) {
            name = this.m_selectedRawFile.getMzDbFileName();
        } else if (this.m_rawFileOnDisk != null) {
            name = this.m_rawFileOnDisk.getName();
        }
        if (name != null) {
            return name;
        }
        if (this.m_message != null) {
            return this.m_message;
        }
        return "Search...";
    }

    public void setRawFileOnDisk(File rawFileOnDisk) {
        this.m_rawFileOnDisk = rawFileOnDisk;
        this.m_selectedRawFile = null;
        this.m_linkedRawFile = null;
    }

    public File getRawFileOnDisk() {
        return this.m_rawFileOnDisk;
    }

    public void setLinkedRawFile(RawFile rawFile) {
        this.m_linkedRawFile = rawFile;
        this.m_selectedRawFile = null;
        this.m_rawFileOnDisk = null;
    }

    public RawFile getLinkedRawFile() {
        return this.m_linkedRawFile;
    }

    public RawFile getSelectedRawFile() {
        return this.m_selectedRawFile;
    }

    public void setSelectedRawFile(RawFile rawFile) {
        this.m_selectedRawFile = rawFile;
        this.m_rawFileOnDisk = null;
        this.m_linkedRawFile = null;
    }

    @Override
    public void load(AbstractDatabaseCallback callback, List<AbstractData> list, AbstractDatabaseTask.Priority priority, boolean identificationDataset) {
    }

    public Run getRun() {
        return this.m_run;
    }

    public void setRun(Run run) {
        this.m_run = run;
    }

    public static enum Status {
        MISSING,
        USER_DEFINED,
        SYSTEM_PROPOSED,
        LAST_DEFINED,
        LINKED_IN_DATABASE,
        NOT_INITIALIZED;

    }
}

