/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.taskinfo;

import fr.proline.studio.dam.taskinfo.TaskInfo;
import java.util.ArrayList;
import java.util.TreeSet;

public class TaskInfoManager {
    private static final int MAX_SIZE = 5000;
    private TreeSet<TaskInfo> m_tasks = new TreeSet();
    private ArrayList<TaskInfo> m_taskToBeUpdated = new ArrayList();
    private static TaskInfoManager m_singleton = null;
    private int m_lastUpdate = -1;
    private int m_curUpdate = 0;

    public static TaskInfoManager getTaskInfoManager() {
        if (m_singleton == null) {
            m_singleton = new TaskInfoManager();
        }
        return m_singleton;
    }

    private TaskInfoManager() {
    }

    public synchronized void add(TaskInfo taskInfo) {
        this.m_tasks.add(taskInfo);
        if (this.m_tasks.size() > 5000) {
            this.m_tasks.remove(this.m_tasks.last());
        }
        ++this.m_curUpdate;
    }

    public synchronized void clear() {
        TreeSet<TaskInfo> tasks = new TreeSet<TaskInfo>();
        for (TaskInfo task : this.m_tasks) {
            if (task.isFinished() && task.isSuccess()) continue;
            tasks.add(task);
        }
        this.m_tasks.clear();
        this.m_tasks = tasks;
        ArrayList<TaskInfo> taskToBeUpdated = new ArrayList<TaskInfo>();
        for (TaskInfo task : this.m_taskToBeUpdated) {
            if (task.isFinished() && task.isSuccess()) continue;
            taskToBeUpdated.add(task);
        }
        this.m_taskToBeUpdated.clear();
        this.m_taskToBeUpdated = taskToBeUpdated;
        ++this.m_curUpdate;
    }

    public synchronized void cancel(TaskInfo taskInfo) {
        this.m_tasks.remove(taskInfo);
        ++this.m_curUpdate;
    }

    public synchronized TaskInfo getTaskInfoWithJMSId(String jmsId) {
        if (jmsId == null) {
            return null;
        }
        for (TaskInfo nextOne : this.m_tasks) {
            if (!jmsId.equals(nextOne.getJmsMessageID())) continue;
            return nextOne;
        }
        return null;
    }

    public synchronized void update(TaskInfo taskInfo) {
        this.m_taskToBeUpdated.add(taskInfo);
        ++this.m_curUpdate;
    }

    public synchronized void update(TaskInfo taskInfo, boolean changeSorting) {
        if (changeSorting) {
            this.update(taskInfo);
        } else {
            ++this.m_curUpdate;
        }
    }

    public synchronized boolean askBeforeExitingApp() {
        if (this.isUpdateNeeded()) {
            this.updateAll();
        }
        for (TaskInfo infoCur : this.m_tasks) {
            if (!infoCur.isWaiting() && !infoCur.isRunning() || !infoCur.askBeforeExitingApplication()) continue;
            return true;
        }
        return false;
    }

    private synchronized void updateAll() {
        int nb = this.m_taskToBeUpdated.size();
        for (int i = 0; i < nb; ++i) {
            TaskInfo info = this.m_taskToBeUpdated.get(i);
            this.m_tasks.remove(info);
            info.update();
            this.m_tasks.add(info);
        }
        this.m_taskToBeUpdated.clear();
    }

    public synchronized boolean isUpdateNeeded() {
        return this.m_curUpdate != this.m_lastUpdate;
    }

    public synchronized boolean copyData(ArrayList<TaskInfo> destinationList, boolean copyHiddenTasksTasks) {
        if (this.m_curUpdate == this.m_lastUpdate && !destinationList.isEmpty()) {
            return false;
        }
        this.m_lastUpdate = this.m_curUpdate;
        this.updateAll();
        int sizeDestination = destinationList.size();
        int index = 0;
        for (TaskInfo infoCur : this.m_tasks) {
            if (!copyHiddenTasksTasks && infoCur.isHidden() && infoCur.getTaskError() == null) continue;
            if (index < sizeDestination) {
                infoCur.copyData(destinationList.get(index));
            } else {
                destinationList.add(new TaskInfo(infoCur));
            }
            ++index;
        }
        if (destinationList.size() > index) {
            destinationList.subList(index, destinationList.size()).clear();
        }
        return true;
    }
}

