/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.studio.dam.taskinfo.AbstractLongTask;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.PriorityChangement;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseTask
extends AbstractLongTask
implements Comparable<AbstractDatabaseTask> {
    protected static final Logger m_logger = LoggerFactory.getLogger("ProlineStudio.DAM.Task");
    protected AbstractDatabaseCallback m_callback;
    protected Priority m_defaultPriority;
    protected Priority m_currentPriority;
    protected Long m_id;
    private static long m_idIncrement = 0L;
    protected TaskError m_taskError = null;
    protected int m_errorId = -1;
    protected AbstractDatabaseTask m_consecutiveTask = null;
    public static final String TASK_LIST_INFO = "Database Access";

    public AbstractDatabaseTask(AbstractDatabaseCallback callback, TaskInfo taskInfo) {
        this(callback, Priority.NORMAL_1, taskInfo);
    }

    public AbstractDatabaseTask(AbstractDatabaseCallback callback, Priority priority, TaskInfo taskInfo) {
        super(taskInfo);
        this.m_callback = callback;
        this.m_defaultPriority = priority;
        this.m_currentPriority = priority;
        if (++m_idIncrement == Long.MAX_VALUE) {
            m_idIncrement = 0L;
        }
        this.m_id = m_idIncrement;
    }

    public void updatePercentage() {
    }

    public void abortTask() {
        this.getTaskInfo().setAborted();
    }

    public void deleteThis() {
        this.m_callback = null;
        if (this.m_consecutiveTask != null) {
            this.m_consecutiveTask.deleteThis();
            this.m_consecutiveTask = null;
        }
    }

    public void setConsecutiveTask(AbstractDatabaseTask task) {
        this.m_consecutiveTask = task;
    }

    public AbstractDatabaseTask getConsecutiveTask() {
        return this.m_consecutiveTask;
    }

    public boolean hasConsecutiveTask() {
        return this.m_consecutiveTask != null;
    }

    public Long getId() {
        return this.m_id;
    }

    public Priority getCurrentPriority() {
        return this.m_currentPriority;
    }

    public void setPriority(Priority priority) {
        this.m_defaultPriority = priority;
        this.m_currentPriority = priority;
    }

    public void applyPriorityChangement(PriorityChangement priorityChangement) {
        this.incrementPriority();
    }

    public void resetPriority() {
        this.m_currentPriority = this.m_defaultPriority;
    }

    public void incrementPriority() {
        switch (this.m_defaultPriority) {
            case LOW: {
                this.m_currentPriority = Priority.NORMAL_1;
                break;
            }
            case NORMAL_1: {
                this.m_currentPriority = Priority.NORMAL_2;
                break;
            }
            case NORMAL_2: {
                this.m_currentPriority = Priority.NORMAL_3;
                break;
            }
            case NORMAL_3: {
                this.m_currentPriority = Priority.HIGH_1;
                break;
            }
            case HIGH_1: {
                this.m_currentPriority = Priority.HIGH_2;
                break;
            }
            case HIGH_2: {
                this.m_currentPriority = Priority.HIGH_3;
                break;
            }
            case HIGH_3: {
                this.m_currentPriority = Priority.TOP;
            }
        }
    }

    public void speedUpPriority() {
        switch (this.m_defaultPriority) {
            case LOW: {
                this.m_currentPriority = Priority.NORMAL_3;
                break;
            }
            case NORMAL_1: {
                this.m_currentPriority = Priority.HIGH_1;
                break;
            }
            case NORMAL_2: {
                this.m_currentPriority = Priority.HIGH_2;
                break;
            }
            case NORMAL_3: {
                this.m_currentPriority = Priority.HIGH_3;
                break;
            }
            case HIGH_1: 
            case HIGH_2: 
            case HIGH_3: {
                this.m_currentPriority = Priority.TOP;
            }
        }
    }

    public abstract boolean fetchData();

    public abstract boolean needToFetch();

    public boolean hasSubTasksToBeDone() {
        return false;
    }

    public void callback(final boolean success, final boolean finished) {
        if (this.m_callback == null) {
            this.getTaskInfo().setFinished(success, this.m_taskError, true);
            return;
        }
        this.m_callback.setErrorMessage(this.m_taskError, this.m_errorId);
        if (this.m_callback.mustBeCalledInAWT()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractDatabaseTask.this.m_callback.run(success, AbstractDatabaseTask.this.m_id, null, finished);
                    AbstractDatabaseTask.this.getTaskInfo().setFinished(success, AbstractDatabaseTask.this.getTaskError(), true);
                }
            });
        } else {
            this.m_callback.run(success, this.m_id, null, finished);
            this.getTaskInfo().setFinished(success, this.getTaskError(), true);
        }
    }

    @Override
    public int compareTo(AbstractDatabaseTask task) {
        long diff = task.m_currentPriority.ordinal() - this.m_currentPriority.ordinal();
        if (diff != 0L) {
            return diff > 0L ? 1 : -1;
        }
        diff = this.m_id - task.m_id;
        if (diff == 0L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }

    public TaskError getTaskError() {
        return this.m_taskError;
    }

    public static enum Priority {
        LOW,
        NORMAL_1,
        NORMAL_2,
        NORMAL_3,
        HIGH_1,
        HIGH_2,
        HIGH_3,
        TOP;

    }
}

