/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import fr.proline.core.orm.msi.ObjectTree;
import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.PeptideMatch;
import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.SequenceMatch;
import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptidePTM;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DPtmSiteProperties;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseSlicerTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.ptm.JSONPTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.JSONPTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.JSONPTMSite2;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.performancetest.PerformanceTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.openide.util.Exceptions;

public class DatabasePTMsTask
extends AbstractDatabaseSlicerTask {
    private long m_projectId = -1L;
    private DDataset m_dataset = null;
    private PTMDataset m_ptmDataset = null;
    private List<PTMSite> m_ptmSitesOutput = null;
    private List<PTMDataset> m_ptmDatasetOutput = null;
    public static final int SUB_TASK_PTMSITE_PEPTIDES = 0;
    public static final int SUB_TASK_PTMCLUSTER_PEPTIDES = 1;
    public static final int SUB_TASK_PTMSITE_PEPINSTANCES = 2;
    public static final int SUB_TASK_COUNT = 3;
    final int SLICE_SIZE = 1000;
    private List<Long> m_bestSitesPepMatchIds = null;
    private HashMap<Long, List<PTMSite>> m_ptmSitesByBestPepMatchId = null;
    private List<Long> m_bestClustersPepMatchIds = null;
    private HashMap<Long, List<PTMCluster>> m_ptmClustersByBestPepMatchId = null;
    private List<Long> m_peptideIds = null;
    private int m_action;
    private static final int LOAD_PTMDATASET = 0;
    private static final int FILL_ALL_PTM_SITES_PEPINFO = 1;
    private static final int FILL_ALL_PTM_INFO = 2;
    private boolean m_loadSitesAsClusters;
    public static final String ERROR_PTM_CLUSTER_LOADING = "PTM Cluster Loading Error";

    public DatabasePTMsTask(AbstractDatabaseCallback callback) {
        super(callback);
    }

    public void initFillPTMInfo(Long projectId) {
        this.init(3, new TaskInfo("Load PTM Info", false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_action = 2;
    }

    public void initFillPTMSites(long projectId, PTMDataset ptmDS, List<PTMSite> ptmSitesToFill) {
        this.init(3, new TaskInfo("Load peptides of PTM Sites", false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_ptmSitesOutput = ptmSitesToFill;
        this.m_ptmDataset = ptmDS;
        this.m_action = 1;
    }

    public void initLoadPTMDataset(Long projectId, DDataset dataset, List<PTMDataset> ptmDataset, boolean loadSitesAsClusters) {
        this.init(3, new TaskInfo("Load PTM Dataset for " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_ptmDatasetOutput = ptmDataset;
        this.m_dataset = dataset;
        this.m_action = 0;
        this.m_loadSitesAsClusters = loadSitesAsClusters;
    }

    @Override
    public boolean needToFetch() {
        switch (this.m_action) {
            case 1: {
                return this.m_peptideIds == null || this.m_peptideIds.isEmpty();
            }
            case 0: {
                return this.m_ptmDatasetOutput == null || this.m_ptmDatasetOutput.isEmpty();
            }
            case 2: {
                return DInfoPTM.getInfoPTMMap().isEmpty();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean fetchData() {
        try {
            switch (this.m_action) {
                case 0: {
                    if (this.needToFetch()) {
                        boolean bl = this.fetchPTMDatasetMainTask();
                        return bl;
                    }
                    boolean bl = this.fetchDataSubTaskFor();
                    return bl;
                }
                case 1: {
                    if (this.needToFetch()) {
                        boolean bl = this.fetchAllPTMSitesPeptideMatches();
                        return bl;
                    }
                    boolean bl = this.fetchDataSubTaskFor();
                    return bl;
                }
                case 2: {
                    if (!this.needToFetch()) return true;
                    boolean bl = this.fetchPTMInfo();
                    return bl;
                }
            }
            return true;
        }
        finally {
            PerformanceTest.displayTimeAllThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataSubTaskFor() {
        SubTask slice = this.m_subTaskManager.getNextSubTask();
        if (slice == null) {
            return true;
        }
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            switch (slice.getSubTaskId()) {
                case 0: {
                    this.fetchSiteBestPeptideMatches(slice, entityManagerMSI);
                    break;
                }
                case 1: {
                    this.fetchClusterBestPeptideMatches(slice, entityManagerMSI);
                    break;
                }
                case 2: {
                    this.fetchPTMSitesPepInstances(slice, entityManagerMSI);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchPTMInfo() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            this.fetchGenericPTMData(entityManagerMSI);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchPTMDatasetMainTask() {
        PerformanceTest.startTime((String)"fetchPTMDatasetMainTask");
        long start = System.currentTimeMillis();
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            ResultSummary rsm = (ResultSummary)entityManagerMSI.find(ResultSummary.class, (Object)this.m_dataset.getResultSummaryId());
            if (rsm.getObjectTreeIdByName().isEmpty() || rsm.getObjectTreeIdByName().get("result_summary.ptm_dataset") == null) {
                this.m_taskError = new TaskError(ERROR_PTM_CLUSTER_LOADING, "\"Identification Modification Sites\"  has not been run on this dataset.");
                throw new RuntimeException("\"Identification Modification Sites\"  has not been run on this dataset.");
            }
            ObjectTree ot = (ObjectTree)entityManagerMSI.find(ObjectTree.class, rsm.getObjectTreeIdByName().get("result_summary.ptm_dataset"));
            ObjectMapper mapper = new ObjectMapper();
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            JSONPTMDataset jsonDS = (JSONPTMDataset)mapper.readValue(ot.getClobData(), JSONPTMDataset.class);
            this.m_ptmDataset = new PTMDataset(this.m_dataset);
            this.m_ptmDataset.setIsVersion2(true);
            this.m_ptmDataset.setLeafResultSummaryIds(Arrays.asList(jsonDS.leafResultSummaryIds));
            this.m_ptmDatasetOutput.add(this.m_ptmDataset);
            this.createPTMDatasetPTMSites(jsonDS, entityManagerMSI);
            for (Long i : jsonDS.ptmIds) {
                this.m_ptmDataset.addInfoPTM((DInfoPTM)DInfoPTM.getInfoPTMMap().get(i));
            }
            if (!this.m_loadSitesAsClusters) {
                this.createPTMDatasetPTMCluster(jsonDS, entityManagerMSI);
            } else {
                this.createPTMDatasetPTMCluster(entityManagerMSI);
            }
        }
        long end = System.currentTimeMillis();
        PerformanceTest.stopTime((String)"fetchPTMDatasetMainTask");
        return true;
    }

    private boolean createPTMDatasetPTMSites(JSONPTMDataset jsonDataset, EntityManager entityManagerMSI) throws Exception {
        PerformanceTest.startTime((String)"createPTMDatasetPTMSites");
        ArrayList<PTMSite> ptmSites = new ArrayList<PTMSite>();
        long start = System.currentTimeMillis();
        Long rsmId = this.m_ptmDataset.getDataset().getResultSummaryId();
        TypedQuery typicalProteinQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DProteinMatch(pm.id, pm.accession, pm.score, pm.peptideCount, pm.resultSet.id, pm.description, pm.geneName, pm.serializedProperties, pepset.id, pepset.score, pepset.sequenceCount, pepset.peptideCount, pepset.peptideMatchCount, pepset.resultSummaryId) FROM PeptideSetProteinMatchMap pset_to_pm JOIN pset_to_pm.proteinMatch as pm JOIN pset_to_pm.peptideSet as pepset JOIN pepset.proteinSet as ps WHERE ps.resultSummary.id=:rsmId AND ps.isValidated=true AND ps.representativeProteinMatchId=pm.id  ORDER BY pepset.score DESC", DProteinMatch.class);
        typicalProteinQuery.setParameter("rsmId", (Object)rsmId);
        List typicalProteinMatchesArray = typicalProteinQuery.getResultList();
        long stop = System.currentTimeMillis();
        m_logger.debug(" ** {} typical ProtMatches and {} PTMSites loaded in {} ms", typicalProteinMatchesArray.size(), jsonDataset.ptmSites.length, stop - start);
        start = stop;
        List accessions = typicalProteinMatchesArray.stream().map(DProteinMatch::getAccession).collect(Collectors.toList());
        HashMap<String, List<Long>> allProtMatchesIdPerAccession = new HashMap<String, List<Long>>();
        int bufferSize = 10000;
        int readAccessionCount = 0;
        while (readAccessionCount < accessions.size()) {
            PerformanceTest.startTime((String)"STEP1");
            Query protMatchQuery = entityManagerMSI.createQuery("SELECT pm.id, pm.accession FROM ProteinMatch pm, ResultSummary rsm WHERE pm.accession IN (:accList) AND rsm.resultSet.id = pm.resultSet.id AND rsm.id in (:rsmIds) ");
            int lastIndex = readAccessionCount + bufferSize > accessions.size() ? accessions.size() : readAccessionCount + bufferSize;
            protMatchQuery.setParameter("accList", accessions.subList(readAccessionCount, lastIndex));
            protMatchQuery.setParameter("rsmIds", this.m_ptmDataset.getLeafResultSummaryIds());
            for (Object[] results : protMatchQuery.getResultList()) {
                Long prMatchAcc = (Long)results[0];
                String acc = (String)results[1];
                if (!allProtMatchesIdPerAccession.containsKey(acc)) {
                    allProtMatchesIdPerAccession.put(acc, new ArrayList());
                }
                ((List)allProtMatchesIdPerAccession.get(acc)).add(prMatchAcc);
            }
            readAccessionCount = lastIndex;
            PerformanceTest.stopTime((String)"STEP1");
        }
        this.m_ptmDataset.setLeafProtMatchesIdPerAccession(allProtMatchesIdPerAccession);
        stop = System.currentTimeMillis();
        m_logger.debug(" ** Creates ProtMatches map for leaf RSM, map size = {} ; loaded in {} ms", (Object)allProtMatchesIdPerAccession.size(), (Object)(stop - start));
        start = stop;
        this.fetchGenericPTMData(entityManagerMSI);
        this.m_ptmSitesByBestPepMatchId = new HashMap();
        Map<Long, DProteinMatch> proteinMatchMap = typicalProteinMatchesArray.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        for (JSONPTMSite2 jsonSite : jsonDataset.ptmSites) {
            PTMSite site2 = new PTMSite(jsonSite, proteinMatchMap.get(jsonSite.proteinMatchId));
            site2.setPTMSpecificity((DInfoPTM)DInfoPTM.getInfoPTMMap().get(jsonSite.ptmDefinitionId));
            if (site2.getProteinMatch() != null) {
                ptmSites.add(site2);
            }
            if (!this.m_ptmSitesByBestPepMatchId.containsKey(jsonSite.bestPeptideMatchId)) {
                this.m_ptmSitesByBestPepMatchId.put(jsonSite.bestPeptideMatchId, new ArrayList());
            }
            this.m_ptmSitesByBestPepMatchId.get(jsonSite.bestPeptideMatchId).add(site2);
        }
        stop = System.currentTimeMillis();
        m_logger.debug(" ** {} PTM Sites built in {} ms", (Object)ptmSites.size(), (Object)(stop - start));
        start = stop;
        this.m_ptmDataset.setPTMSites(ptmSites);
        PerformanceTest.stopTime((String)"createPTMDatasetPTMSites");
        this.m_bestSitesPepMatchIds = Arrays.asList(jsonDataset.ptmSites).stream().map(site -> site.bestPeptideMatchId).distinct().collect(Collectors.toList());
        SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(0, this.m_bestSitesPepMatchIds.size(), 1000);
        this.fetchSiteBestPeptideMatches(subTask, entityManagerMSI);
        stop = System.currentTimeMillis();
        m_logger.debug(" ** First {} Best PSM + Peptide + Spectrum + Query from PepInstances created in {} ms", (Object)1000, (Object)(stop - start));
        return true;
    }

    private boolean createPTMDatasetPTMCluster(JSONPTMDataset jsonDataset, EntityManager entityManagerMSI) throws Exception {
        long start = System.currentTimeMillis();
        PerformanceTest.startTime((String)"createPTMDatasetPTMCluster");
        this.m_bestClustersPepMatchIds = new ArrayList<Long>();
        ArrayList<PTMCluster> allClusters = new ArrayList<PTMCluster>();
        this.m_ptmClustersByBestPepMatchId = new HashMap();
        for (JSONPTMCluster cluster : jsonDataset.ptmClusters) {
            PTMCluster ptmCluster = new PTMCluster(cluster, this.m_ptmDataset);
            if (ptmCluster.getPTMSites() == null || ptmCluster.getPTMSites().isEmpty()) continue;
            Long bestPepMatchID = cluster.bestPeptideMatchId;
            this.m_bestClustersPepMatchIds.add(bestPepMatchID);
            allClusters.add(ptmCluster);
            if (!this.m_ptmClustersByBestPepMatchId.containsKey(bestPepMatchID)) {
                this.m_ptmClustersByBestPepMatchId.put(bestPepMatchID, new ArrayList());
            }
            this.m_ptmClustersByBestPepMatchId.get(bestPepMatchID).add(ptmCluster);
        }
        this.m_ptmDataset.setPTMClusters(allClusters);
        PerformanceTest.stopTime((String)"createPTMDatasetPTMCluster");
        long stop = System.currentTimeMillis();
        m_logger.debug(" -- Created {} Cluster in {} ms", (Object)allClusters.size(), (Object)(stop - start));
        start = stop;
        SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(1, this.m_bestClustersPepMatchIds.size(), 1000);
        this.fetchClusterBestPeptideMatches(subTask, entityManagerMSI);
        stop = System.currentTimeMillis();
        m_logger.debug(" -- First {} Best PSM + Peptide + Spectrum + Query from PepInstances created in {} ms", (Object)1000, (Object)(stop - start));
        return true;
    }

    private boolean createPTMDatasetPTMCluster(EntityManager entityManagerMSI) throws Exception {
        long start = System.currentTimeMillis();
        this.m_bestClustersPepMatchIds = new ArrayList<Long>();
        PerformanceTest.startTime((String)"createPTMDatasetPTMCluster");
        ArrayList<PTMCluster> allClusters = new ArrayList<PTMCluster>();
        this.m_ptmClustersByBestPepMatchId = new HashMap();
        for (PTMSite site : this.m_ptmDataset.getPTMSites()) {
            PTMCluster ptmCluster = new PTMCluster(site.getId(), site.getLocalisationConfidence(), Arrays.asList(site.getId()), site.getPeptideIds(), this.m_ptmDataset);
            if (ptmCluster.getPTMSites() == null || ptmCluster.getPTMSites().isEmpty()) continue;
            Long bestPepMatchID = site.getBestProbabilityPepMatchId();
            this.m_bestClustersPepMatchIds.add(bestPepMatchID);
            allClusters.add(ptmCluster);
            if (!this.m_ptmClustersByBestPepMatchId.containsKey(bestPepMatchID)) {
                this.m_ptmClustersByBestPepMatchId.put(bestPepMatchID, new ArrayList());
            }
            this.m_ptmClustersByBestPepMatchId.get(bestPepMatchID).add(ptmCluster);
        }
        this.m_ptmDataset.setPTMClusters(allClusters);
        PerformanceTest.stopTime((String)"createPTMDatasetPTMCluster");
        long stop = System.currentTimeMillis();
        m_logger.debug(" -- Created {} Cluster in {} ms", (Object)allClusters.size(), (Object)(stop - start));
        start = stop;
        SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(1, this.m_bestClustersPepMatchIds.size(), 1000);
        this.fetchClusterBestPeptideMatches(subTask, entityManagerMSI);
        stop = System.currentTimeMillis();
        m_logger.debug(" -- First {} Best PSM + Peptide + Spectrum + Query from PepInstances created in {} ms", (Object)1000, (Object)(stop - start));
        return true;
    }

    private void fetchGenericPTMData(EntityManager entityManagerMSI) {
        PerformanceTest.startTime((String)"fetchGenericPTMData");
        HashMap infoPTMMAp = DInfoPTM.getInfoPTMMap();
        if (!infoPTMMAp.isEmpty()) {
            PerformanceTest.stopTime((String)"fetchGenericPTMData");
            return;
        }
        TypedQuery ptmInfoQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DInfoPTM(spec.id, spec.residue, spec.location, ptm.shortName, evidence.composition, evidence.monoMass) \nFROM fr.proline.core.orm.msi.PtmSpecificity as spec, fr.proline.core.orm.msi.Ptm as ptm, fr.proline.core.orm.msi.PtmEvidence as evidence \nWHERE spec.ptm=ptm AND ptm=evidence.ptm AND evidence.type='Precursor' ", DInfoPTM.class);
        List ptmInfoList = ptmInfoQuery.getResultList();
        for (DInfoPTM infoPTM : ptmInfoList) {
            DInfoPTM.addInfoPTM((DInfoPTM)infoPTM);
        }
        PerformanceTest.stopTime((String)"fetchGenericPTMData");
    }

    private boolean fetchSiteBestPeptideMatches(SubTask subTask, EntityManager entityManagerMSI) {
        List sliceOfPeptideMatchIds = subTask.getSubList(this.m_bestSitesPepMatchIds);
        return this.fetchBestPeptideMatches(sliceOfPeptideMatchIds, entityManagerMSI, true);
    }

    private boolean fetchClusterBestPeptideMatches(SubTask subTask, EntityManager entityManagerMSI) {
        List sliceOfPeptideMatchIds = subTask.getSubList(this.m_bestClustersPepMatchIds);
        return this.fetchBestPeptideMatches(sliceOfPeptideMatchIds, entityManagerMSI, false);
    }

    private boolean fetchBestPeptideMatches(List<Long> sliceOfPeptideMatchIds, EntityManager entityManagerMSI, boolean isSite) {
        long start = System.currentTimeMillis();
        PerformanceTest.startTime((String)"fetchBestPeptideMatches");
        PerformanceTest.startTime((String)"STEP1");
        Query peptidesQuery = entityManagerMSI.createQuery("SELECT pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.serializedProperties, sp.firstTime, sp.precursorIntensity, sp.title, p, ms.id, ms.initialId, ptmString\n   FROM fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pipm, fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.PeptideInstance pi, fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.PeptideReadablePtmString ptmString, fr.proline.core.orm.msi.MsQuery ms, fr.proline.core.orm.msi.Spectrum sp  \n   WHERE pipm.id.peptideMatchId IN (:peptideMatchList) AND pipm.id.peptideInstanceId=pi.id AND pipm.id.peptideMatchId=pm.id AND pm.peptideId=p.id AND pm.msQuery=ms AND ms.spectrum=sp AND pi.resultSummary.id in (:rmsIds) AND ptmString.peptide=p AND ptmString.resultSet.id=pm.resultSet.id");
        peptidesQuery.setParameter("peptideMatchList", sliceOfPeptideMatchIds);
        List<Long> rsmIds = this.m_ptmDataset.getLeafResultSummaryIds();
        rsmIds.add(this.m_ptmDataset.getDataset().getResultSummaryId());
        peptidesQuery.setParameter("rmsIds", rsmIds);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        List l = peptidesQuery.getResultList();
        Iterator itPeptidesQuery = l.iterator();
        ArrayList<DPeptideMatch> allPepMatches = new ArrayList<DPeptideMatch>();
        PerformanceTest.stopTime((String)"STEP1");
        while (itPeptidesQuery.hasNext()) {
            PerformanceTest.startTime((String)"STEP2");
            Object[] resCur = (Object[])itPeptidesQuery.next();
            Long pmId = (Long)resCur[0];
            Integer pmRank = (Integer)resCur[1];
            Integer pmCharge = (Integer)resCur[2];
            Float pmDeltaMoz = (Float)resCur[3];
            Double pmExperimentalMoz = (Double)resCur[4];
            Integer pmMissedCleavage = (Integer)resCur[5];
            Float pmScore = (Float)resCur[6];
            Long pmResultSetId = (Long)resCur[7];
            Integer pmCdPrettyRank = (Integer)resCur[8];
            Integer pmSdPrettyRank = (Integer)resCur[9];
            String serializedProperties = (String)resCur[10];
            Float firstTime = (Float)resCur[11];
            Float precursorIntensity = (Float)resCur[12];
            String title = (String)resCur[13];
            DSpectrum spectrum = new DSpectrum();
            spectrum.setFirstTime(firstTime);
            spectrum.setPrecursorIntensity(precursorIntensity);
            spectrum.setTitle(title);
            PerformanceTest.stopTime((String)"STEP2");
            PerformanceTest.startTime((String)"STEP3");
            DPeptideMatch pm = new DPeptideMatch(pmId.longValue(), pmRank, pmCharge.intValue(), pmDeltaMoz, pmExperimentalMoz.doubleValue(), pmMissedCleavage.intValue(), pmScore, pmResultSetId.longValue(), pmCdPrettyRank, pmSdPrettyRank);
            pm.setRetentionTime(firstTime);
            pm.setSerializedProperties(serializedProperties);
            try {
                JsonNode node = mapper.readTree(serializedProperties);
                JsonNode child = node.get("ptm_site_properties");
                DPtmSiteProperties properties = (DPtmSiteProperties)mapper.treeToValue((TreeNode)child, DPtmSiteProperties.class);
                pm.setPtmSiteProperties(properties);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            PerformanceTest.stopTime((String)"STEP3");
            PerformanceTest.startTime((String)"STEP4");
            Peptide p = (Peptide)resCur[14];
            Long msqId = (Long)resCur[15];
            Integer msqInitialId = (Integer)resCur[16];
            PeptideReadablePtmString ptmString = (PeptideReadablePtmString)resCur[17];
            p.getTransientData().setPeptideReadablePtmString(ptmString);
            p.getTransientData().setPeptideReadablePtmStringLoaded();
            DMsQuery msq = new DMsQuery(pmId.longValue(), msqId.longValue(), msqInitialId.intValue(), precursorIntensity);
            msq.setDSpectrum(spectrum);
            pm.setPeptide(p);
            pm.setMsQuery(msq);
            PerformanceTest.stopTime((String)"STEP4");
            PerformanceTest.startTime((String)"STEP5");
            if (isSite) {
                List<PTMSite> sites = this.m_ptmSitesByBestPepMatchId.get(pmId);
                if (sites != null && !sites.isEmpty()) {
                    sites.stream().forEach(site -> {
                        PTMSite finalSite = this.m_ptmDataset.getPTMSite(site.getId());
                        if (finalSite != null) {
                            finalSite.setBestProbabilityPepMatch(pm);
                        }
                    });
                }
            } else {
                List<PTMCluster> clusters = this.m_ptmClustersByBestPepMatchId.get(pmId);
                if (clusters != null && !clusters.isEmpty()) {
                    clusters.stream().forEach(cluster -> cluster.setRepresentativePepMatch(pm));
                }
            }
            allPepMatches.add(pm);
            PerformanceTest.stopTime((String)"STEP5");
        }
        long stop = System.currentTimeMillis();
        m_logger.debug("  --- {} PeptideMatches loaded in {} ms", (Object)sliceOfPeptideMatchIds.size(), (Object)(stop - start));
        start = stop;
        PerformanceTest.startTime((String)"STEP6");
        List pepId = allPepMatches.stream().map(peM -> peM.getPeptide().getId()).collect(Collectors.toList());
        HashMap<Long, ArrayList<DPeptidePTM>> ptmMap = this.fetchPeptidePTMForPeptides(entityManagerMSI, new ArrayList<Long>(pepId));
        for (DPeptideMatch pm : allPepMatches) {
            Peptide p = pm.getPeptide();
            Long idPeptide = p.getId();
            ArrayList<DPeptidePTM> ptmList = ptmMap.get(idPeptide);
            pm.setPeptidePTMArray(ptmList);
            HashMap<Integer, DPeptidePTM> mapToPtm = new HashMap<Integer, DPeptidePTM>();
            if (ptmList == null) continue;
            for (DPeptidePTM peptidePTM : ptmList) {
                mapToPtm.put((int)peptidePTM.getSeqPosition(), peptidePTM);
            }
            p.getTransientData().setDPeptidePtmMap(mapToPtm);
        }
        PerformanceTest.stopTime((String)"STEP6");
        stop = System.currentTimeMillis();
        m_logger.debug(" --- Associated PTM data loaded in {} ms", (Object)(stop - start));
        PerformanceTest.stopTime((String)"fetchBestPeptideMatches");
        return true;
    }

    private HashMap<Long, ArrayList<DPeptidePTM>> fetchPeptidePTMForPeptides(EntityManager entityManagerMSI, ArrayList<Long> allPeptidesIds) {
        PerformanceTest.startTime((String)"fetchPeptidePTMForPeptides");
        HashMap<Long, ArrayList<DPeptidePTM>> ptmMap = new HashMap<Long, ArrayList<DPeptidePTM>>();
        TypedQuery ptmQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DPeptidePTM(pptm.peptide.id, pptm.specificity.id, pptm.seqPosition) \nFROM PeptidePtm as pptm  \nWHERE pptm.peptide.id IN (:peptideList) ", DPeptidePTM.class);
        ptmQuery.setParameter("peptideList", allPeptidesIds);
        List ptmList = ptmQuery.getResultList();
        for (DPeptidePTM ptm : ptmList) {
            Long peptideId = ptm.getIdPeptide();
            ArrayList<Object> list = ptmMap.get(peptideId);
            if (list == null) {
                list = new ArrayList();
                ptmMap.put(peptideId, list);
            }
            list.add(ptm);
        }
        PerformanceTest.stopTime((String)"fetchPeptidePTMForPeptides");
        return ptmMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchAllPTMSitesPeptideMatches() {
        PerformanceTest.startTime((String)"fetchAllPTMSitesPeptideMatches");
        long start = System.currentTimeMillis();
        m_logger.debug(" START fetchAllPTMSitesPeptideMatches task ");
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            Set allPepIds = this.m_ptmSitesOutput.stream().flatMap(s -> s.getPeptideIds().stream()).collect(Collectors.toSet());
            this.m_peptideIds = new ArrayList<Long>();
            this.m_peptideIds.addAll(allPepIds);
            SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(2, this.m_peptideIds.size(), 1000);
            this.fetchPTMSitesPepInstances(subTask, entityManagerMSI);
            long stop = System.currentTimeMillis();
            m_logger.debug(" fetchAllPTMSitesPeptideMatches :{} of {} PTM Sites filled in {} ms", 1000, this.m_ptmSitesOutput.size(), stop - start);
        }
        PerformanceTest.stopTime((String)"fetchAllPTMSitesPeptideMatches");
        return true;
    }

    private boolean fetchPTMSitesPepInstances(SubTask subTask, EntityManager entityManagerMSI) throws IOException {
        List sliceOfPeptideIds = subTask.getSubList(this.m_peptideIds);
        return this.fetchPTMSitesPepInstances(sliceOfPeptideIds, entityManagerMSI);
    }

    private boolean fetchPTMSitesPepInstances(List<Long> sliceOfPeptideIds, EntityManager entityManagerMSI) throws IOException {
        boolean datasetIsLeaf;
        PerformanceTest.startTime((String)"fetchPTMSitesPepInstances");
        long start = System.currentTimeMillis();
        m_logger.debug(" @@ START fetchPTMSitesPepInstances SUBTASK ");
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        int nbrPepIds = sliceOfPeptideIds.size();
        Long rsetId = this.m_ptmDataset.getDataset().getResultSetId();
        if (rsetId == null && this.m_ptmDataset.getDataset().getResultSummary() != null && this.m_ptmDataset.getDataset().getResultSummary().getResultSet() != null) {
            rsetId = this.m_ptmDataset.getDataset().getResultSummary().getResultSet().getId();
        }
        Long dsRsmId = this.m_ptmDataset.getDataset().getResultSummaryId();
        List<Long> allRsmIds = this.m_ptmDataset.getLeafResultSummaryIds();
        boolean bl = datasetIsLeaf = allRsmIds.size() == 1 && this.m_ptmDataset.getLeafResultSummaryIds().get(0).equals(dsRsmId);
        if (!datasetIsLeaf) {
            allRsmIds.add(dsRsmId);
        }
        PerformanceTest.startTime((String)"peptidesQuery");
        Query peptidesQuery = entityManagerMSI.createQuery("SELECT pi.id FROM fr.proline.core.orm.msi.PeptideInstance pi   WHERE pi.peptide.id IN (:peptideIdsList) AND pi.resultSummary.id in (:rmsIds)");
        peptidesQuery.setParameter("peptideIdsList", sliceOfPeptideIds);
        peptidesQuery.setParameter("rmsIds", allRsmIds);
        Iterator itPeptidesQuery = peptidesQuery.getResultList().iterator();
        ArrayList<Long> peptideInstanceIds = new ArrayList<Long>();
        while (itPeptidesQuery.hasNext()) {
            Long resCur = (Long)itPeptidesQuery.next();
            peptideInstanceIds.add(resCur);
        }
        int nbrPepInstIds = peptideInstanceIds.size();
        PerformanceTest.stopTime((String)"peptidesQuery");
        long end = System.currentTimeMillis();
        m_logger.debug(" @@ fetchPTMSitesPepInstances: Read " + nbrPepInstIds + " pep instances corresponding to " + nbrPepIds + " peptides in " + (end - start) + " ms");
        start = end;
        PerformanceTest.startTime((String)"dataQuery");
        HashMap<Long, Peptide> allPeptidesMap = new HashMap<Long, Peptide>();
        HashMap<Long, DPeptideInstance> leafPeptideInstancesById = new HashMap<Long, DPeptideInstance>();
        HashMap leafPeptideInstancesByPepId = new HashMap();
        HashMap<Long, DPeptideInstance> parentPeptideInstancesByPepId = new HashMap<Long, DPeptideInstance>();
        Query dataQuery = entityManagerMSI.createQuery("SELECT pm, pi, sm, sp.firstTime, sp.precursorIntensity, sp.title,  msq.id, msq.initialId   FROM fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pipm, fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.PeptideInstance pi,  fr.proline.core.orm.msi.SequenceMatch sm , fr.proline.core.orm.msi.MsQuery msq , fr.proline.core.orm.msi.Spectrum sp   WHERE pipm.id.peptideInstanceId IN ( :peptideInstanceList ) AND pipm.id.peptideInstanceId=pi.id AND pipm.id.peptideMatchId=pm.id  AND sm.id.peptideId = pi.peptide.id  AND sm.resultSetId = pm.resultSet.id AND sm.id.peptideId=pm.peptideId AND pm.msQuery.id = msq.id AND msq.spectrum.id = sp.id ");
        dataQuery.setParameter("peptideInstanceList", new ArrayList(peptideInstanceIds));
        List l = dataQuery.getResultList();
        Iterator itPeptidesMatchesQuery = l.iterator();
        PerformanceTest.stopTime((String)"dataQuery");
        end = System.currentTimeMillis();
        m_logger.debug(" @@ fetchPTMSitesPepInstances: query result size " + l.size() + " in " + (end - start) + " ms");
        start = end;
        PerformanceTest.startTime((String)"itPeptidesMatchesQuery loop");
        while (itPeptidesMatchesQuery.hasNext()) {
            PerformanceTest.startTime((String)"STEP1");
            Object[] resCur = (Object[])itPeptidesMatchesQuery.next();
            PeptideMatch pm = (PeptideMatch)resCur[0];
            PeptideInstance pi2 = (PeptideInstance)resCur[1];
            SequenceMatch sm = (SequenceMatch)resCur[2];
            Float firstTime = (Float)resCur[3];
            Float precursorIntensity = (Float)resCur[4];
            String spectrumTitle = (String)resCur[5];
            Long msQueryId = (Long)resCur[6];
            Integer msQueryInitialId = (Integer)resCur[7];
            PerformanceTest.stopTime((String)"STEP1");
            PerformanceTest.startTime((String)"STEP2");
            DSpectrum spectrum = new DSpectrum();
            spectrum.setFirstTime(firstTime);
            spectrum.setPrecursorIntensity(precursorIntensity);
            spectrum.setTitle(spectrumTitle);
            PerformanceTest.stopTime((String)"STEP2");
            PerformanceTest.startTime((String)"STEP3");
            DPeptideMatch dpm = new DPeptideMatch(pm.getId(), pm.getRank(), pm.getCharge(), pm.getDeltaMoz(), pm.getExperimentalMoz(), pm.getMissedCleavage(), pm.getScore(), pm.getResultSet().getId(), pm.getCDPrettyRank(), pm.getSDPrettyRank());
            dpm.setRetentionTime(spectrum.getFirstTime());
            dpm.setSerializedProperties(pm.getSerializedProperties());
            dpm.setSequenceMatch(sm);
            PerformanceTest.stopTime((String)"STEP3");
            PerformanceTest.startTime((String)"STEP4");
            JsonNode node = mapper.readTree(dpm.getSerializedProperties());
            JsonNode child = node.get("ptm_site_properties");
            DPtmSiteProperties properties = (DPtmSiteProperties)mapper.treeToValue((TreeNode)child, DPtmSiteProperties.class);
            dpm.setPtmSiteProperties(properties);
            PerformanceTest.stopTime((String)"STEP4");
            PerformanceTest.startTime((String)"STEP5");
            Peptide p = pi2.getPeptide();
            p.getTransientData().setPeptideReadablePtmStringLoaded();
            allPeptidesMap.put(p.getId(), p);
            DMsQuery msq = new DMsQuery(pm.getId(), msQueryId.longValue(), msQueryInitialId.intValue(), spectrum.getPrecursorIntensity());
            msq.setDSpectrum(spectrum);
            dpm.setPeptide(p);
            dpm.setMsQuery(msq);
            PerformanceTest.stopTime((String)"STEP5");
            PerformanceTest.startTime((String)"STEP6");
            if (dsRsmId.equals(pi2.getResultSummary().getId())) {
                if (!parentPeptideInstancesByPepId.containsKey(p.getId())) {
                    DPeptideInstance dpi = new DPeptideInstance(pi2);
                    dpi.setResultSummary(pi2.getResultSummary());
                    dpi.setPeptide(p);
                    dpi.setPeptideMatches(new ArrayList());
                    parentPeptideInstancesByPepId.put(p.getId(), dpi);
                }
                if (pi2.getBestPeptideMatchId() == dpm.getId()) {
                    ((DPeptideInstance)parentPeptideInstancesByPepId.get(p.getId())).setBestPeptideMatch(dpm);
                }
                ((DPeptideInstance)parentPeptideInstancesByPepId.get(p.getId())).getPeptideMatches().add(dpm);
            }
            if (!dsRsmId.equals(pi2.getResultSummary().getId()) || datasetIsLeaf) {
                if (!leafPeptideInstancesByPepId.containsKey(p.getId())) {
                    leafPeptideInstancesByPepId.put(p.getId(), new ArrayList());
                }
                List pepInsts = (List)leafPeptideInstancesByPepId.get(p.getId());
                boolean alreadyread = false;
                for (DPeptideInstance readPepI : pepInsts) {
                    if (readPepI.getId() != pi2.getId()) continue;
                    alreadyread = true;
                }
                if (!alreadyread) {
                    DPeptideInstance dpi = new DPeptideInstance(pi2);
                    dpi.setResultSummary(pi2.getResultSummary());
                    dpi.setPeptide(p);
                    dpi.setPeptideMatches(new ArrayList());
                    leafPeptideInstancesById.put(dpi.getId(), dpi);
                    pepInsts.add(dpi);
                }
                if (pi2.getBestPeptideMatchId() == dpm.getId()) {
                    ((DPeptideInstance)leafPeptideInstancesById.get(pi2.getId())).setBestPeptideMatch(dpm);
                }
                ((DPeptideInstance)leafPeptideInstancesById.get(pi2.getId())).getPeptideMatches().add(dpm);
            }
            PerformanceTest.stopTime((String)"STEP6");
        }
        PerformanceTest.stopTime((String)"itPeptidesMatchesQuery loop");
        end = System.currentTimeMillis();
        m_logger.debug(" @@ fetchPTMSitesPepInstances: Created leafPeptideInstancesById. Nbr : " + leafPeptideInstancesById.size() + " in " + (end - start) + " ms");
        start = end;
        PerformanceTest.startTime((String)"ptmStingQuery");
        Set allPeptides = allPeptidesMap.keySet();
        Query ptmStingQuery = entityManagerMSI.createQuery("SELECT p.id, ptmString FROM fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.PeptideReadablePtmString ptmString WHERE p.id IN (:listId) AND ptmString.peptide=p AND ptmString.resultSet.id=:rsetId");
        ptmStingQuery.setParameter("listId", allPeptides);
        ptmStingQuery.setParameter("rsetId", (Object)rsetId);
        List ptmStrings = ptmStingQuery.getResultList();
        for (Object[] res : ptmStrings) {
            Long peptideId = (Long)res[0];
            PeptideReadablePtmString ptmString = (PeptideReadablePtmString)res[1];
            Peptide peptide = (Peptide)allPeptidesMap.get(peptideId);
            peptide.getTransientData().setPeptideReadablePtmString(ptmString);
        }
        PerformanceTest.stopTime((String)"ptmStingQuery");
        PerformanceTest.startTime((String)"fetchGenericPTMData");
        this.fetchGenericPTMData(entityManagerMSI);
        PerformanceTest.stopTime((String)"fetchGenericPTMData");
        PerformanceTest.startTime((String)"fetchPeptidePTMForPeptides");
        HashMap<Long, ArrayList<DPeptidePTM>> ptmMap = this.fetchPeptidePTMForPeptides(entityManagerMSI, new ArrayList<Long>(allPeptidesMap.keySet()));
        PerformanceTest.stopTime((String)"fetchPeptidePTMForPeptides");
        PerformanceTest.startTime((String)"parentPeptideInstancesByPepId.values().stream().flatMap");
        List allpeptideMatches = leafPeptideInstancesById.values().stream().flatMap(pi -> pi.getPeptideMatches().stream()).collect(Collectors.toList());
        allpeptideMatches.addAll(parentPeptideInstancesByPepId.values().stream().flatMap(pi -> pi.getPeptideMatches().stream()).collect(Collectors.toList()));
        PerformanceTest.stopTime((String)"parentPeptideInstancesByPepId.values().stream().flatMap");
        end = System.currentTimeMillis();
        m_logger.debug(" @@ fetchPTMSitesPepInstances got PTM info  for all peptideMatches . nbr " + allpeptideMatches.size() + " in " + (end - start) + " ms");
        start = end;
        PerformanceTest.startTime((String)"allpeptideMatches loop");
        for (DPeptideMatch pm : allpeptideMatches) {
            Peptide p = pm.getPeptide();
            Long idPeptide = p.getId();
            ArrayList<DPeptidePTM> ptmList = ptmMap.get(idPeptide);
            pm.setPeptidePTMArray(ptmList);
            HashMap<Integer, DPeptidePTM> mapToPtm = new HashMap<Integer, DPeptidePTM>();
            if (ptmList == null) continue;
            Iterator<DPeptidePTM> iterator = ptmList.iterator();
            while (iterator.hasNext()) {
                DPeptidePTM peptidePTM = iterator.next();
                mapToPtm.put((int)peptidePTM.getSeqPosition(), peptidePTM);
            }
            p.getTransientData().setDPeptidePtmMap(mapToPtm);
        }
        PerformanceTest.stopTime((String)"allpeptideMatches loop");
        m_logger.info(" @@ {} peptides matching to {} peptide matches retrieved", (Object)allPeptides.size(), (Object)allpeptideMatches.size());
        m_logger.info(" @@ {} peptide instances retrieved", (Object)parentPeptideInstancesByPepId.size());
        PerformanceTest.startTime((String)"m_ptmSitesOutput loop");
        for (PTMSite site : this.m_ptmSitesOutput) {
            ArrayList<DPeptideInstance> leafPeptideInstances = new ArrayList<DPeptideInstance>();
            HashSet parentPeptideInstancesAsSet = new HashSet();
            for (Long pepId : site.getPeptideIds()) {
                if (leafPeptideInstancesByPepId.containsKey(pepId)) {
                    leafPeptideInstances.addAll((Collection)leafPeptideInstancesByPepId.get(pepId));
                }
                if (!parentPeptideInstancesByPepId.containsKey(pepId)) continue;
                parentPeptideInstancesAsSet.add(parentPeptideInstancesByPepId.get(pepId));
            }
            if (leafPeptideInstances.isEmpty() && parentPeptideInstancesAsSet.isEmpty()) continue;
            ArrayList<DPeptideInstance> parentPeptideInstances = new ArrayList<DPeptideInstance>();
            parentPeptideInstances.addAll(parentPeptideInstancesAsSet);
            site.addPeptideInstances(parentPeptideInstances, leafPeptideInstances);
        }
        PerformanceTest.stopTime((String)"m_ptmSitesOutput loop");
        end = System.currentTimeMillis();
        m_logger.debug(" @@ END fetchPTMSitesPepInstances subtask  in " + (end - start) + " ms");
        PerformanceTest.stopTime((String)"fetchPTMSitesPepInstances");
        return true;
    }
}

