/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.SearchSetting;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class DatabaseRsetProperties
extends AbstractDatabaseTask {
    private long m_projectId;
    private DDataset m_dataset = null;
    private ResultSet m_rset = null;

    public DatabaseRsetProperties(AbstractDatabaseCallback callback, long projectId, DDataset dataset) {
        super(callback, new TaskInfo("Load Properties for Search Result " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
    }

    public DatabaseRsetProperties(AbstractDatabaseCallback callback, long projectId, ResultSet rset, String name) {
        super(callback, new TaskInfo("Load Properties for Search Result " + name, false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_rset = rset;
    }

    @Override
    public boolean needToFetch() {
        if (this.m_rset == null) {
            this.m_rset = this.m_dataset.getResultSet();
        }
        return this.m_rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getPeptideMatchesCount() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fetchData() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            MsiSearch msiSearch;
            entityManagerMSI.getTransaction().begin();
            this.fetchData_count(entityManagerMSI, this.m_rset);
            ResultSet rsetDecoy = this.m_rset.getDecoyResultSet();
            if (rsetDecoy != null) {
                this.fetchData_count(entityManagerMSI, rsetDecoy);
            }
            if ((msiSearch = this.m_rset.getMsiSearch()) != null) {
                SearchSetting searchSetting = msiSearch.getSearchSetting();
                SearchSetting mergedSearchSetting = (SearchSetting)entityManagerMSI.merge((Object)searchSetting);
                Set enzymeSet = mergedSearchSetting.getEnzymes();
                Iterator it = enzymeSet.iterator();
                while (it.hasNext()) {
                    it.next();
                }
                searchSetting.setEnzymes(enzymeSet);
                Set usedPtmSet = mergedSearchSetting.getUsedPtms();
                Iterator itPtm = usedPtmSet.iterator();
                while (itPtm.hasNext()) {
                    itPtm.next();
                }
                searchSetting.setUsedPtms(usedPtmSet);
                Set setDatabaseMapSet = mergedSearchSetting.getSearchSettingsSeqDatabaseMaps();
                Iterator itSeqDbMap = setDatabaseMapSet.iterator();
                while (itSeqDbMap.hasNext()) {
                    itSeqDbMap.next();
                }
                searchSetting.setSearchSettingsSeqDatabaseMaps(setDatabaseMapSet);
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    private void fetchData_count(EntityManager entityManagerMSI, ResultSet rset) throws Exception {
        Long rsetId = rset.getId();
        long step1 = System.currentTimeMillis();
        Query countProteinMatchQuery = entityManagerMSI.createNativeQuery("SELECT count(*) FROM protein_match pm WHERE pm.result_set_id=?");
        countProteinMatchQuery.setParameter(1, (Object)rsetId);
        BigInteger proteinMatchNumber = (BigInteger)countProteinMatchQuery.getSingleResult();
        rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setProteinMatchesCount(Integer.valueOf(proteinMatchNumber.intValue()));
        long step2 = System.currentTimeMillis();
        Query countPeptideMatchQuery = entityManagerMSI.createNativeQuery("SELECT count(*) FROM peptide_match pm WHERE pm.result_set_id=?");
        countPeptideMatchQuery.setParameter(1, (Object)rsetId);
        BigInteger peptideMatchNumber = (BigInteger)countPeptideMatchQuery.getSingleResult();
        rset.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setPeptideMatchesCount(Integer.valueOf(peptideMatchNumber.intValue()));
        long step3 = System.currentTimeMillis();
        m_logger.info("Time SQL REQUEST " + (step3 - step2) + "   " + (step2 - step1));
    }
}

