/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class DatabaseRsummaryProperties
extends AbstractDatabaseTask {
    private long m_projectId;
    private DDataset m_dataset = null;
    private ResultSummary m_rsm = null;

    public DatabaseRsummaryProperties(AbstractDatabaseCallback callback, long projectId, DDataset dataset) {
        super(callback, new TaskInfo("Load Properties for Identification Summary " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
    }

    public DatabaseRsummaryProperties(AbstractDatabaseCallback callback, long projectId, ResultSummary rset, String name) {
        super(callback, new TaskInfo("Load Properties for Identification Summary " + name, false, "Database Access", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_projectId = projectId;
        this.m_rsm = rset;
    }

    @Override
    public boolean needToFetch() {
        if (this.m_rsm == null) {
            this.m_rsm = this.m_dataset.getResultSummary();
        }
        return this.m_rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).getNumberOfProteinSets() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fetchData() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            this.fetchData_count(entityManagerMSI, this.m_rsm);
            ResultSummary rsmDecoy = this.m_rsm.getDecoyResultSummary();
            if (rsmDecoy != null) {
                this.fetchData_count(entityManagerMSI, rsmDecoy);
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    private void fetchData_count(EntityManager entityManagerMSI, ResultSummary rsm) throws Exception {
        Long rsmId = rsm.getId();
        TypedQuery countProteinSetsQuery = entityManagerMSI.createQuery("SELECT count(ps) FROM ProteinSet ps WHERE ps.resultSummary.id=:rsmId AND ps.isValidated=true", Long.class);
        countProteinSetsQuery.setParameter("rsmId", (Object)rsmId);
        Long proteinSetNumber = (Long)countProteinSetsQuery.getSingleResult();
        rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setNumberOfProteinSet(Integer.valueOf(proteinSetNumber.intValue()));
        TypedQuery countPeptidesQuery = entityManagerMSI.createQuery("SELECT count(pi) FROM PeptideInstance pi WHERE pi.resultSummary.id=:rsmId AND pi.validatedProteinSetCount > 0", Long.class);
        countPeptidesQuery.setParameter("rsmId", (Object)rsmId);
        rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setNumberOfPeptides(Integer.valueOf(((Long)countPeptidesQuery.getSingleResult()).intValue()));
        TypedQuery countPeptideMatchesQuery = entityManagerMSI.createQuery("SELECT  sum(pi.peptideMatchCount) FROM PeptideInstance pi WHERE pi.resultSummary.id=:rsmId AND pi.validatedProteinSetCount > 0", Long.class);
        countPeptideMatchesQuery.setParameter("rsmId", (Object)rsmId);
        rsm.getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setNumberOfPeptideMatches(Integer.valueOf(((Long)countPeptideMatchesQuery.getSingleResult()).intValue()));
    }
}

