/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks;

import java.util.List;

public class SubTask
implements Comparable<SubTask> {
    private int m_subTaskId;
    private int m_startIndex;
    private int m_stopIndex;
    private boolean m_highPriority = false;

    public SubTask(int subTaskId, int startIndex, int stopIndex) {
        this.m_subTaskId = subTaskId;
        this.m_startIndex = startIndex;
        this.m_stopIndex = stopIndex;
    }

    public List getSubList(List l) {
        if (this.m_startIndex == 0 && this.m_stopIndex == l.size() - 1) {
            return l;
        }
        return l.subList(this.m_startIndex, this.m_stopIndex + 1);
    }

    public int getSubTaskId() {
        return this.m_subTaskId;
    }

    public int getStartIndex() {
        return this.m_startIndex;
    }

    public int getStopIndex() {
        return this.m_stopIndex;
    }

    public boolean hasIndex(int index) {
        return index >= this.m_startIndex && index <= this.m_stopIndex;
    }

    public boolean hasCommonIndexes(int start, int stop) {
        return this.hasIndex(start) || this.hasIndex(stop);
    }

    public boolean isHighPriority() {
        return this.m_highPriority;
    }

    public void setHighPriority(boolean highPriority) {
        this.m_highPriority = highPriority;
    }

    @Override
    public int compareTo(SubTask o) {
        if (this.m_highPriority && !o.m_highPriority) {
            return -1;
        }
        if (!this.m_highPriority && o.m_highPriority) {
            return 1;
        }
        int diffIndex = this.m_startIndex - o.m_startIndex;
        if (diffIndex != 0) {
            return diffIndex;
        }
        return this.m_subTaskId - o.m_subTaskId;
    }
}

