/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.data.ptm;

import fr.proline.core.orm.msi.SequenceMatch;
import fr.proline.core.orm.msi.dto.DInfoPTM;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMDataset {
    protected static final Logger LOG = LoggerFactory.getLogger("ProlineStudio.DAM.Task");
    private DDataset m_dataset;
    private List<PTMSite> m_proteinPTMSites;
    private List<Long> m_leafRSMIds;
    private List<DInfoPTM> m_ptmOfInterest;
    private List<PTMCluster> m_ptmClusters;
    private final Map<Long, Map<Long, List<PTMPeptideInstance>>> m_parentPtmPepInstByPepIdByProtMatchId = new HashMap<Long, Map<Long, List<PTMPeptideInstance>>>();
    private final Map<Long, Map<Long, List<PTMPeptideInstance>>> m_leafPtmPepInstByPepInstIdByProtMatchId = new HashMap<Long, Map<Long, List<PTMPeptideInstance>>>();
    private Map<String, List<Long>> m_allLeafProtMatchesIdPerAccession;
    private Boolean m_isVersion2;

    public PTMDataset(DDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("dataset from which PTM sites are extracted cannot be null");
        }
        this.m_dataset = dataset;
        this.m_isVersion2 = false;
        this.m_ptmOfInterest = new ArrayList<DInfoPTM>();
    }

    public DDataset getDataset() {
        return this.m_dataset;
    }

    public List<Long> getLeafResultSummaryIds() {
        if (!this.isVersion2() || this.m_leafRSMIds == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Long>(this.m_leafRSMIds);
    }

    public void setLeafResultSummaryIds(List<Long> l) {
        this.m_leafRSMIds = new ArrayList<Long>(l);
    }

    public boolean isVersion2() {
        return this.m_isVersion2;
    }

    public void setIsVersion2(boolean isV2) {
        this.m_isVersion2 = isV2;
    }

    public boolean isIdentification() {
        return this.m_dataset.isIdentification();
    }

    public boolean isQuantitation() {
        return this.m_dataset.isQuantitation();
    }

    public void addInfoPTM(DInfoPTM ptm) {
        this.m_ptmOfInterest.add(ptm);
    }

    public List<PTMSite> getPTMSites() {
        return this.m_proteinPTMSites;
    }

    public void setPTMSites(List<PTMSite> proteinPTMSites) {
        proteinPTMSites.stream().forEach(site -> site.setDataset(this));
        this.m_proteinPTMSites = proteinPTMSites;
    }

    public List<PTMCluster> getPTMClusters() {
        return this.m_ptmClusters;
    }

    public void setPTMClusters(List<PTMCluster> ptmClusters) {
        this.m_ptmClusters = ptmClusters;
    }

    public PTMSite getPTMSite(Long id) {
        if (!this.isVersion2()) {
            return null;
        }
        Optional<PTMSite> ptmSite = this.m_proteinPTMSites.stream().filter(site -> site.getId().equals(id)).findFirst();
        return ptmSite.orElse(null);
    }

    public void setQuantProteinSets(List<DMasterQuantProteinSet> masterQuantProteinSetList, Map<Long, Long> typicalProteinMatchIdByProteinMatchId) {
        DMasterQuantProteinSet mqps;
        Long typicalPMId;
        HashMap<Long, DMasterQuantProteinSet> mqProteinSetByProteinMatchId = new HashMap<Long, DMasterQuantProteinSet>();
        for (DMasterQuantProteinSet mqps2 : masterQuantProteinSetList) {
            if (mqps2.getProteinSet() == null) continue;
            mqProteinSetByProteinMatchId.put(mqps2.getProteinSet().getProteinMatchId(), mqps2);
        }
        for (PTMSite site : this.m_proteinPTMSites) {
            typicalPMId = typicalProteinMatchIdByProteinMatchId.get(site.getProteinMatch().getId());
            mqps = (DMasterQuantProteinSet)mqProteinSetByProteinMatchId.get(typicalPMId);
            site.setQuantProteinSet(mqps);
        }
        if (this.m_ptmClusters != null) {
            for (PTMCluster cluster : this.m_ptmClusters) {
                typicalPMId = typicalProteinMatchIdByProteinMatchId.get(cluster.getProteinMatch().getId());
                mqps = (DMasterQuantProteinSet)mqProteinSetByProteinMatchId.get(typicalPMId);
                cluster.setQuantProteinSet(mqps);
            }
        }
    }

    public List<PTMPeptideInstance> getLeafPTMPeptideInstances(Long proteinMatchId, Long pepInstId) {
        Map<Long, List<PTMPeptideInstance>> m = this.m_leafPtmPepInstByPepInstIdByProtMatchId.get(proteinMatchId);
        if (m != null) {
            return m.get(pepInstId);
        }
        return Collections.EMPTY_LIST;
    }

    public void addLeafPTMPeptideInstance(PTMPeptideInstance pepInst, Long proteinMatchId) {
        Map<Long, List<PTMPeptideInstance>> m = this.m_leafPtmPepInstByPepInstIdByProtMatchId.get(proteinMatchId);
        if (m == null) {
            m = new HashMap<Long, List<PTMPeptideInstance>>();
            ArrayList<PTMPeptideInstance> ptmPepInst = new ArrayList<PTMPeptideInstance>();
            ptmPepInst.add(pepInst);
            m.put(pepInst.getPeptideInstance().getId(), ptmPepInst);
        } else if (m.get(pepInst.getPeptideInstance().getId()) == null) {
            ArrayList<PTMPeptideInstance> ptmPepInst = new ArrayList<PTMPeptideInstance>();
            ptmPepInst.add(pepInst);
            m.put(pepInst.getPeptideInstance().getId(), ptmPepInst);
        } else {
            m.get(pepInst.getPeptideInstance().getId()).add(pepInst);
        }
        this.m_leafPtmPepInstByPepInstIdByProtMatchId.put(proteinMatchId, m);
    }

    public Collection<PTMPeptideInstance> getPTMPeptideInstances(Long proteinMatchId) {
        Map<Long, List<PTMPeptideInstance>> m = this.m_parentPtmPepInstByPepIdByProtMatchId.get(proteinMatchId);
        if (m != null) {
            return m.values().stream().flatMap(entry -> entry.stream()).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    public PTMPeptideInstance getPTMPeptideInstance(DProteinMatch proteinMatch, DPeptideInstance peptideInstance, Integer protPosition) {
        PTMPeptideInstance foundPtmPepIns;
        List potentialPtmPepInsts;
        Map<Long, List<PTMPeptideInstance>> ptmPepInstanceByPepId;
        List<PTMPeptideInstance> registeredPtmPepInsts;
        Long proteinMatchId = proteinMatch.getId();
        if (!this.m_parentPtmPepInstByPepIdByProtMatchId.containsKey(proteinMatchId)) {
            this.m_parentPtmPepInstByPepIdByProtMatchId.put(proteinMatchId, new HashMap());
        }
        if ((registeredPtmPepInsts = (ptmPepInstanceByPepId = this.m_parentPtmPepInstByPepIdByProtMatchId.get(proteinMatchId)).get(peptideInstance.getPeptideId())) == null) {
            registeredPtmPepInsts = new ArrayList<PTMPeptideInstance>();
        }
        if ((potentialPtmPepInsts = registeredPtmPepInsts.stream().filter(ptmPepInst -> protPosition >= ptmPepInst.getStartPosition() && protPosition <= ptmPepInst.getStopPosition()).collect(Collectors.toList())).isEmpty()) {
            foundPtmPepIns = new PTMPeptideInstance(peptideInstance);
            registeredPtmPepInsts.add(foundPtmPepIns);
            if (peptideInstance.getPeptideMatches() != null) {
                List pepInsSequenceMatches = peptideInstance.getPeptideMatches().stream().map(pepM -> pepM.getSequenceMatch()).collect(Collectors.toList());
                for (SequenceMatch sm : pepInsSequenceMatches) {
                    if (protPosition < sm.getId().getStart() || protPosition > sm.getId().getStop()) continue;
                    foundPtmPepIns.setStartPosition(sm.getId().getStart());
                    break;
                }
            }
            ptmPepInstanceByPepId.put(peptideInstance.getPeptideId(), registeredPtmPepInsts);
        } else {
            foundPtmPepIns = (PTMPeptideInstance)potentialPtmPepInsts.get(0);
            if (potentialPtmPepInsts.size() > 1) {
                LOG.warn(" ----- GET PTMPeptideInstance for Prot id " + proteinMatchId + " pep " + peptideInstance.getPeptide().getSequence() + " at position " + protPosition + " FOUND " + potentialPtmPepInsts.size());
            }
        }
        return foundPtmPepIns;
    }

    public void updateParentPTMPeptideInstanceClusters() {
        if (this.m_ptmClusters != null && !this.m_ptmClusters.isEmpty()) {
            this.m_ptmClusters.forEach(ptmC -> {
                List<PTMPeptideInstance> ptmPepInsForCluster = ptmC.getParentPTMPeptideInstances();
                ptmPepInsForCluster.forEach(peI -> peI.addCluster((PTMCluster)ptmC));
            });
        }
    }

    public void setLeafProtMatchesIdPerAccession(Map<String, List<Long>> allProtMatchesIdPerAccession) {
        this.m_allLeafProtMatchesIdPerAccession = allProtMatchesIdPerAccession;
    }

    public List<Long> getProtMatchesIdForAccession(String protMatcherAccession) {
        return this.m_allLeafProtMatchesIdPerAccession.getOrDefault(protMatcherAccession, new ArrayList());
    }
}

