/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.data.ptm;

import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMSite;
import fr.proline.studio.dam.tasks.data.ptm.PTMSitePeptideInstance;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMPeptideInstance {
    protected static final Logger m_logger = LoggerFactory.getLogger("ProlineStudio.DAM.Task");
    private final DPeptideInstance m_peptideInstance;
    private final List<PTMSite> m_sites = new ArrayList<PTMSite>();
    private final List<PTMCluster> m_clusters = new ArrayList<PTMCluster>();
    private Integer m_startPosition;

    public PTMPeptideInstance(DPeptideInstance peptideInstance) {
        this.m_peptideInstance = peptideInstance;
    }

    public String getSequence() {
        return this.m_peptideInstance.getPeptide().getSequence();
    }

    public void addPTMSite(PTMSite site) {
        if (!this.m_sites.contains(site)) {
            this.m_sites.add(site);
            this.m_sites.sort(Comparator.comparingInt(PTMSite::getPositionOnProtein));
        }
    }

    public void setStartPosition(int start) {
        this.m_startPosition = start;
    }

    public Integer getStartPosition() {
        return this.m_startPosition;
    }

    public Integer getStopPosition() {
        return this.m_startPosition + this.m_peptideInstance.getPeptide().getSequence().length();
    }

    public DPeptideInstance getPeptideInstance() {
        return this.m_peptideInstance;
    }

    public List<PTMSite> getPTMSites() {
        return this.m_sites;
    }

    public void addCluster(PTMCluster cluster) {
        this.m_clusters.add(cluster);
    }

    public List<PTMCluster> getClusters() {
        return this.m_clusters;
    }

    public DPeptideMatch getRepresentativePepMatch() {
        return this._getRepresentativePepMatch(this.m_clusters);
    }

    public DPeptideMatch getRepresentativePepMatch(List<PTMCluster> clusters) {
        List<PTMCluster> matchingClusters = this.m_clusters.stream().filter(clusters::contains).collect(Collectors.toList());
        return matchingClusters.isEmpty() ? null : this._getRepresentativePepMatch(matchingClusters);
    }

    public DPeptideMatch _getRepresentativePepMatch(List<PTMCluster> clusters) {
        if (clusters.size() > 1) {
            m_logger.debug("searching a representative PSM for multiple clusters simultaneously not yet implemented: use only the first cluster");
        }
        PTMCluster cluster = this.m_clusters.get(0);
        DPeptideMatch pepMatch = null;
        for (PTMSite nextSite : cluster.getPTMSites()) {
            PTMSitePeptideInstance ptmSitePepInst = nextSite.getPTMSitePeptideInstance(this.getPeptideInstance().getPeptideId());
            if (ptmSitePepInst == null) continue;
            pepMatch = ptmSitePepInst.getRepresentativePepMatch();
            break;
        }
        return pepMatch;
    }

    public List<DPeptideMatch> getPepMatchesOnProteinMatch(DProteinMatch proteinMatch) {
        ArrayList<DPeptideMatch> pepMatches = new ArrayList<DPeptideMatch>();
        List<Long> allowedProtMatchIds = this.m_sites.get(0).getPTMdataset().getProtMatchesIdForAccession(proteinMatch.getAccession());
        pepMatches.addAll(this.m_peptideInstance.getPeptideMatches().stream().filter(dpm -> allowedProtMatchIds.contains(dpm.getSequenceMatch().getId().getProteinMatchId())).collect(Collectors.toList()));
        return pepMatches;
    }

    public String toString() {
        return "PTMPeptideInstance{" + this.getSequence() + " Position=(" + this.getStartPosition() + "-" + this.getStopPosition() + this.m_sites.toString() + "}";
    }
}

