/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dam.tasks.xic;

import fr.proline.core.orm.msi.ObjectTree;
import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.PeptideReadablePtmString;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DCluster;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.msi.dto.DQuantPeptide;
import fr.proline.core.orm.msi.dto.DQuantProteinSet;
import fr.proline.core.orm.msi.dto.MasterQuantPeptideProperties;
import fr.proline.core.orm.msi.dto.MasterQuantProteinSetProperties;
import fr.proline.core.orm.uds.BiologicalGroup;
import fr.proline.core.orm.uds.BiologicalSample;
import fr.proline.core.orm.uds.Dataset;
import fr.proline.core.orm.uds.GroupSetup;
import fr.proline.core.orm.uds.MasterQuantitationChannel;
import fr.proline.core.orm.uds.QuantitationChannel;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.core.orm.uds.SampleAnalysis;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.core.orm.uds.dto.DMasterQuantitationChannel;
import fr.proline.core.orm.uds.dto.DQuantitationChannel;
import fr.proline.core.orm.util.DStoreCustomPoolConnectorFactory;
import fr.proline.core.orm.util.JsonSerializer;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseSlicerTask;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabasePTMSitesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadLcMSTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class DatabaseLoadXicMasterQuantTask
extends AbstractDatabaseSlicerTask {
    private static final int SLICE_SIZE = 1000;
    public static final int SUB_TASK_COUNT_QC = 0;
    public static final int SUB_TASK_PROTEIN_SET = 1;
    public static final int SUB_TASK_COUNT_PROTEIN = 2;
    public static final int SUB_TASK_COUNT_PEPTIDE = 3;
    public static final int SUB_TASK_PEPTIDE_INSTANCE = 4;
    public static final int SUB_TASK_COUNT_PEPTIDE_ION = 5;
    public static final int SUB_TASK_PEPTIDE_ION = 6;
    public static final int SUB_TASK_PEPTIDE = 7;
    public static final int SUB_TASK_MSQUERY = 8;
    public static final int SUB_TASK_PROTEINSET_NAME_LIST = 9;
    public static final int SUB_TASK_COUNT_PSM = 10;
    public static final int SUB_TASK_PTM_PEPTIDE_INSTANCE = 11;
    public static final int SUB_TASK_NB = 12;
    private List<Long> m_proteinSetIds = null;
    private List<Long> m_resultSetIds = null;
    private List<Long> m_peptideInstanceIds = null;
    private List<Long> m_masterQuantPeptideIonIds = null;
    private Long m_projectId;
    private DDataset m_dataset;
    private List<DMasterQuantProteinSet> m_masterQuantProteinSetList;
    private List<DMasterQuantPeptide> m_masterQuantPeptideList;
    private DMasterQuantProteinSet m_dMasterQuantProteinSet;
    private Long[] m_peptideInstanceIdArray;
    private DMasterQuantPeptide m_masterQuantPeptide;
    private DMasterQuantPeptideIon m_aggregatedMasterQuantPeptideIon;
    private List<DMasterQuantPeptideIon> m_masterQuantPeptideIonList;
    private HashMap<Long, DQuantitationChannel> m_quantitationChannelsMap;
    private ArrayList<Long> m_childrenDatasetIds;
    private DMasterQuantPeptide m_masterQuantPeptideForPSM;
    private Map<Long, List<Long>> m_psmIdPerQC;
    private List<DPeptideMatch> m_peptideMatchList;
    private boolean m_xic;
    private ArrayList<Long> m_peptideMatchIds = null;
    private HashMap<Long, DPeptideMatch> m_peptideMatchMap = null;
    private HashMap<Long, ArrayList<DPeptideMatch>> m_peptideMatchSequenceMatchArrayMap = null;
    private int action;
    private static final int LOAD_PROTEIN_SET_FOR_XIC = 0;
    private static final int LOAD_PEPTIDE_FOR_XIC = 1;
    private static final int LOAD_QUANT_CHANNELS_FOR_XIC = 2;
    private static final int LOAD_PEPTIDE_FOR_PROTEIN_SET = 3;
    private static final int LOAD_PEPTIDE_ION_FOR_XIC = 4;
    private static final int LOAD_PEPTIDE_ION_FOR_PEPTIDE = 5;
    private static final int LOAD_PSM_FOR_PEPTIDE = 6;
    private static final int LOAD_PEPTIDE_FROM_PEPTIDES_INSTANCES = 7;
    private static final int LOAD_PEPTIDE_ION_FOR_AGGREGATE_PEPTIDE_ION = 8;

    public DatabaseLoadXicMasterQuantTask(AbstractDatabaseCallback callback) {
        super(callback);
    }

    public void initLoadProteinSets(long projectId, DDataset dataset, List<DMasterQuantProteinSet> masterQuantProteinSetList) {
        this.init(12, new TaskInfo("Load Protein Sets of XIC " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
        this.m_masterQuantProteinSetList = masterQuantProteinSetList;
        this.action = 0;
    }

    public void initLoadQuantChannels(long projectId, DDataset dataset) {
        this.init(12, new TaskInfo("Load Quant Channels of XIC " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
        this.action = 2;
    }

    public void initLoadPeptides(long projectId, DDataset dataset, List<DMasterQuantPeptide> masterQuantPeptideList, boolean xic) {
        this.init(12, new TaskInfo("Load Peptides of XIC " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
        this.m_masterQuantPeptideList = masterQuantPeptideList;
        this.m_xic = xic;
        this.action = 1;
    }

    public void initLoadPeptides(long projectId, DDataset dataset, DMasterQuantProteinSet masterQuantProteinSet, List<DMasterQuantPeptide> masterQuantPeptideList, boolean xic) {
        String proteinSetName = "";
        if (masterQuantProteinSet != null) {
            proteinSetName = this.getMasterQuantProteinSetName(masterQuantProteinSet);
        }
        this.init(12, new TaskInfo("Load Peptides of proteinSet " + proteinSetName, false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
        this.m_masterQuantPeptideList = masterQuantPeptideList;
        this.m_dMasterQuantProteinSet = masterQuantProteinSet;
        this.m_xic = xic;
        this.action = 3;
    }

    public void initLoadPeptides(long projectId, DDataset dataset, Long[] peptideInstanceIdArray, List<DMasterQuantPeptide> masterQuantPeptideList, boolean xic) {
        this.init(12, new TaskInfo("Load Peptides from peptide Instances ", false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
        this.m_masterQuantPeptideList = masterQuantPeptideList;
        this.m_peptideInstanceIdArray = peptideInstanceIdArray;
        this.m_xic = xic;
        this.action = 7;
    }

    public void initLoadPeptideIons(long projectId, DDataset dataset, DMasterQuantPeptide masterQuantPeptide, List<DMasterQuantPeptideIon> masterQuantPeptideIonList) {
        String peptideName = "";
        if (masterQuantPeptide != null && masterQuantPeptide.getPeptideInstance() != null && masterQuantPeptide.getPeptideInstance().getPeptide() != null) {
            peptideName = masterQuantPeptide.getPeptideInstance().getPeptide().getSequence();
        }
        this.init(12, new TaskInfo("Load Peptides Ions of peptide " + peptideName, false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
        this.m_masterQuantPeptide = masterQuantPeptide;
        this.m_masterQuantPeptideIonList = masterQuantPeptideIonList;
        this.action = 5;
    }

    public void initLoadParentPeptideIons(long projectId, DDataset dataset, DMasterQuantPeptide masterQuantPeptide, DMasterQuantPeptideIon aggregatedMasterQuantPeptide, List<DMasterQuantPeptideIon> masterQuantPeptideIonList, HashMap<Long, DQuantitationChannel> quantitationChannelsMap, ArrayList<Long> childrenDatasetIds) {
        String peptideName = "";
        if (aggregatedMasterQuantPeptide != null && aggregatedMasterQuantPeptide.getRepresentativePepMatch() != null && aggregatedMasterQuantPeptide.getRepresentativePepMatch().getPeptide() != null) {
            peptideName = aggregatedMasterQuantPeptide.getRepresentativePepMatch().getPeptide().getSequence();
        }
        this.init(12, new TaskInfo("Load Parents Peptides Ions of peptide " + peptideName, false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
        this.m_masterQuantPeptide = masterQuantPeptide;
        this.m_aggregatedMasterQuantPeptideIon = aggregatedMasterQuantPeptide;
        this.m_masterQuantPeptideIonList = masterQuantPeptideIonList;
        this.m_quantitationChannelsMap = quantitationChannelsMap;
        this.m_childrenDatasetIds = childrenDatasetIds;
        this.action = 8;
    }

    public void initLoadPeptideIons(long projectId, DDataset dataset, List<DMasterQuantPeptideIon> masterQuantPeptideIonList) {
        this.init(12, new TaskInfo("Load Peptides Ions of XIC " + dataset.getName(), false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
        this.m_masterQuantPeptideIonList = masterQuantPeptideIonList;
        this.action = 4;
    }

    public void initLoadPSMForPeptide(long projectId, DDataset dataset, DMasterQuantPeptide masterQuantPeptide, List<DPeptideMatch> listPeptideMatch, Map<Long, List<Long>> psmPerQC) {
        String peptideName = "";
        if (masterQuantPeptide != null && masterQuantPeptide.getPeptideInstance() != null && masterQuantPeptide.getPeptideInstance().getPeptide() != null) {
            peptideName = masterQuantPeptide.getPeptideInstance().getPeptide().getSequence();
        }
        this.init(12, new TaskInfo("Load Peptide Match of peptide " + peptideName, false, "Database Access", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_projectId = projectId;
        this.m_dataset = dataset;
        this.m_masterQuantPeptideForPSM = masterQuantPeptide;
        this.m_psmIdPerQC = psmPerQC;
        this.m_peptideMatchList = listPeptideMatch;
        this.action = 6;
    }

    @Override
    public void abortTask() {
        super.abortTask();
        switch (this.action) {
            case 0: {
                this.m_masterQuantProteinSetList = null;
                break;
            }
            case 2: {
                this.m_dataset = null;
                break;
            }
            case 1: {
                this.m_masterQuantPeptideList = null;
                break;
            }
            case 3: 
            case 7: {
                this.m_masterQuantPeptideList = null;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                this.m_masterQuantPeptideIonList = null;
                break;
            }
            case 6: {
                this.m_peptideMatchList = null;
            }
        }
    }

    @Override
    public boolean fetchData() {
        if (this.action == 2) {
            if (this.needToFetch()) {
                this.m_taskError = DatabaseLoadXicMasterQuantTask.fetchDataQuantChannels(this.m_projectId, this.m_dataset);
                return this.m_taskError == null;
            }
        } else {
            if (this.action == 0) {
                if (this.needToFetch()) {
                    if (this.m_dataset.getMasterQuantitationChannels() == null || this.m_dataset.getMasterQuantitationChannels().isEmpty()) {
                        this.m_taskError = DatabaseLoadXicMasterQuantTask.fetchDataQuantChannels(this.m_projectId, this.m_dataset);
                    }
                    if (this.m_dataset.getMapAlignments() == null || this.m_dataset.getMapAlignments().isEmpty()) {
                        this.m_taskError = DatabaseLoadLcMSTask.fetchDataMainTaskAlignmentForXic(this.m_projectId, this.m_dataset);
                    }
                    return this.fetchDataProteinMainTask();
                }
                return this.fetchProteinSetDataSubTask();
            }
            if (this.action == 1) {
                if (this.needToFetch()) {
                    if (this.m_dataset.getMasterQuantitationChannels() == null || this.m_dataset.getMasterQuantitationChannels().isEmpty()) {
                        this.m_taskError = DatabaseLoadXicMasterQuantTask.fetchDataQuantChannels(this.m_projectId, this.m_dataset);
                    }
                    if (this.m_dataset.getMapAlignments() == null || this.m_dataset.getMapAlignments().isEmpty()) {
                        DatabaseLoadLcMSTask.fetchDataMainTaskAlignmentForXic(this.m_projectId, this.m_dataset);
                    }
                    return this.fetchDataPeptideMainTask(this.m_xic, null);
                }
                return this.fetchPeptideInstanceDataSubTask(this.m_xic);
            }
            if (this.action == 3) {
                if (this.needToFetch()) {
                    if (this.m_dataset.getMapAlignments() == null || this.m_dataset.getMapAlignments().isEmpty()) {
                        this.m_taskError = DatabaseLoadLcMSTask.fetchDataMainTaskAlignmentForXic(this.m_projectId, this.m_dataset);
                    }
                    return this.fetchDataPeptideForProteinSetMainTask(this.m_xic);
                }
            } else {
                if (this.action == 7) {
                    if (this.needToFetch()) {
                        if (this.m_dataset.getMapAlignments() == null || this.m_dataset.getMapAlignments().isEmpty()) {
                            this.m_taskError = DatabaseLoadLcMSTask.fetchDataMainTaskAlignmentForXic(this.m_projectId, this.m_dataset);
                        }
                        return this.fetchDataPeptideMainTask(this.m_xic, this.m_peptideInstanceIdArray);
                    }
                    return this.fetchPeptideInstanceDataSubTask(this.m_xic);
                }
                if (this.action == 4) {
                    if (this.needToFetch()) {
                        if (this.m_dataset.getMasterQuantitationChannels() == null || this.m_dataset.getMasterQuantitationChannels().isEmpty()) {
                            this.m_taskError = DatabaseLoadXicMasterQuantTask.fetchDataQuantChannels(this.m_projectId, this.m_dataset);
                        }
                        if (this.m_dataset.getMapAlignments() == null || this.m_dataset.getMapAlignments().isEmpty()) {
                            this.m_taskError = DatabaseLoadLcMSTask.fetchDataMainTaskAlignmentForXic(this.m_projectId, this.m_dataset);
                        }
                        return this.fetchDataPeptideIonMainTask();
                    }
                    return this.fetchPeptideIonDataSubTask();
                }
                if (this.action == 5) {
                    if (this.needToFetch()) {
                        if (this.m_dataset.getMapAlignments() == null || this.m_dataset.getMapAlignments().isEmpty()) {
                            this.m_taskError = DatabaseLoadLcMSTask.fetchDataMainTaskAlignmentForXic(this.m_projectId, this.m_dataset);
                        }
                        return this.fetchDataPeptideIonForPeptideMainTask();
                    }
                } else if (this.action == 5) {
                    if (this.needToFetch()) {
                        if (this.m_dataset.getMapAlignments() == null || this.m_dataset.getMapAlignments().isEmpty()) {
                            this.m_taskError = DatabaseLoadLcMSTask.fetchDataMainTaskAlignmentForXic(this.m_projectId, this.m_dataset);
                        }
                        return this.fetchDataPeptideIonForPeptideMainTask();
                    }
                } else if (this.action == 8) {
                    if (this.needToFetch()) {
                        return this.fetchDataPeptideIonForAggregatePeptideIonMainTask();
                    }
                } else if (this.action == 6) {
                    if (this.needToFetch()) {
                        return this.fetchDataPSMForPeptideMainTask();
                    }
                    return this.fetchDataSubTask();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataSubTask() {
        SubTask subTask = this.m_subTaskManager.getNextSubTask();
        if (subTask == null) {
            return true;
        }
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            switch (subTask.getSubTaskId()) {
                case 7: {
                    this.fetchPeptide(entityManagerMSI, subTask);
                    break;
                }
                case 8: {
                    this.fetchMsQuery(entityManagerMSI, subTask);
                    break;
                }
                case 9: {
                    this.fetchProteinSetName(entityManagerMSI, subTask);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    @Override
    public boolean needToFetch() {
        switch (this.action) {
            case 0: {
                return this.m_masterQuantProteinSetList == null || this.m_masterQuantProteinSetList.isEmpty();
            }
            case 2: {
                return true;
            }
            case 1: {
                return this.m_masterQuantPeptideList == null || this.m_masterQuantPeptideList.isEmpty();
            }
            case 3: 
            case 7: {
                return this.m_masterQuantPeptideList == null || this.m_masterQuantPeptideList.isEmpty();
            }
            case 4: {
                return this.m_masterQuantPeptideIonList == null || this.m_masterQuantPeptideIonList.isEmpty();
            }
            case 5: 
            case 8: {
                return this.m_masterQuantPeptideIonList == null || this.m_masterQuantPeptideIonList.isEmpty();
            }
            case 6: {
                return this.m_peptideMatchList == null || this.m_peptideMatchList.isEmpty();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskError fetchDataQuantChannels(Long projectId, DDataset dataset) {
        long start = System.currentTimeMillis();
        EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();
        EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(projectId.longValue()).createEntityManager();
        EntityManager entityManagerLCMS = DStoreCustomPoolConnectorFactory.getInstance().getLcMsDbConnector(projectId.longValue()).createEntityManager();
        try {
            Map objectTreeIdByName;
            entityManagerUDS.getTransaction().begin();
            entityManagerMSI.getTransaction().begin();
            entityManagerLCMS.getTransaction().begin();
            Dataset datasetDB = (Dataset)entityManagerUDS.find(Dataset.class, (Object)dataset.getId());
            QuantitationMethod quantMethodDB = datasetDB.getMethod();
            List listMasterQuantitationChannels = datasetDB.getMasterQuantitationChannels();
            dataset.setQuantitationMethod(quantMethodDB);
            List labels = quantMethodDB.getLabels();
            labels.size();
            dataset.setDescription(datasetDB.getDescription());
            ArrayList<DMasterQuantitationChannel> masterQuantitationChannels = null;
            if (listMasterQuantitationChannels != null && !listMasterQuantitationChannels.isEmpty()) {
                masterQuantitationChannels = new ArrayList<DMasterQuantitationChannel>();
                for (MasterQuantitationChannel masterQuantitationChannel : listMasterQuantitationChannels) {
                    Long resultSummaryId = masterQuantitationChannel.getQuantResultSummaryId();
                    List<DQuantitationChannel> listDQuantChannels = DatabaseLoadXicMasterQuantTask.createDQuantChannelsForMQC(projectId, masterQuantitationChannel, entityManagerMSI, entityManagerUDS, entityManagerLCMS);
                    DMasterQuantitationChannel dMaster = new DMasterQuantitationChannel(masterQuantitationChannel.getId(), masterQuantitationChannel.getName(), resultSummaryId, listDQuantChannels, masterQuantitationChannel.getDataset(), masterQuantitationChannel.getSerializedProperties());
                    DDataset identDataset = null;
                    Object identResultSummaryId = null;
                    Dataset identDatasetDB = masterQuantitationChannel.getIdentDataset();
                    if (identDatasetDB != null) {
                        identDataset = new DDataset(identDatasetDB.getId(), identDatasetDB.getProject(), identDatasetDB.getName(), identDatasetDB.getType(), identDatasetDB.getChildrenCount(), identDatasetDB.getResultSetId(), identDatasetDB.getResultSummaryId(), identDatasetDB.getNumber());
                    }
                    identResultSummaryId = masterQuantitationChannel.getIdentResultSummaryId();
                    dMaster.setIdentDataset(identDataset);
                    dMaster.setIdentResultSummaryId((Long)identResultSummaryId);
                    masterQuantitationChannels.add(dMaster);
                }
                MasterQuantitationChannel masterQuantitationChannel = (MasterQuantitationChannel)listMasterQuantitationChannels.get(0);
                Long resultSummaryId = masterQuantitationChannel.getQuantResultSummaryId();
                if (dataset.getResultSummary() == null || dataset.getResultSetId() == null || dataset.getResultSet() == null) {
                    ResultSummary rsm = (ResultSummary)entityManagerMSI.find(ResultSummary.class, (Object)resultSummaryId);
                    Set objTreeByName = rsm.getObjectTreeIdByName().keySet();
                    if (dataset.getResultSummaryId() == null) {
                        dataset.setResultSummaryId(resultSummaryId);
                    }
                    if (dataset.getResultSummary() == null) {
                        dataset.setResultSummary(rsm);
                    }
                    if (dataset.getResultSet() == null) {
                        dataset.setResultSet(rsm.getResultSet());
                    }
                    if (dataset.getResultSetId() == null) {
                        dataset.setResultSetId(Long.valueOf(rsm.getResultSet().getId()));
                    }
                }
            }
            dataset.setMasterQuantitationChannels(masterQuantitationChannels);
            Set groupSetupSet = datasetDB.getGroupSetups();
            if (groupSetupSet != null && !groupSetupSet.isEmpty()) {
                GroupSetup groupSetup = (GroupSetup)groupSetupSet.iterator().next();
                List listBiolGroup = groupSetup.getBiologicalGroups();
                for (Object biolGroup : listBiolGroup) {
                    List listBiologicalSamples = biolGroup.getBiologicalSamples();
                    for (BiologicalSample bioSample : listBiologicalSamples) {
                        for (SampleAnalysis splAnalysis : bioSample.getSampleAnalyses()) {
                            splAnalysis.getDataset();
                        }
                    }
                }
                dataset.setGroupSetup(groupSetup);
            }
            if (!dataset.getMasterQuantitationChannels().isEmpty()) {
                List listQch = ((DMasterQuantitationChannel)dataset.getMasterQuantitationChannels().get(0)).getQuantitationChannels();
                if (dataset.getGroupSetup() != null && !dataset.getGroupSetup().getBiologicalGroups().isEmpty()) {
                    ArrayList<DQuantitationChannel> sortedQch = new ArrayList<DQuantitationChannel>();
                    List listBiolGroup = dataset.getGroupSetup().getBiologicalGroups();
                    for (BiologicalGroup biolGroup : listBiolGroup) {
                        List listBiologicalSamples = biolGroup.getBiologicalSamples();
                        for (BiologicalSample sample : listBiologicalSamples) {
                            List listQchSample = sample.getQuantitationChannels();
                            block13: for (QuantitationChannel qchS : listQchSample) {
                                for (DQuantitationChannel dqch : listQch) {
                                    if (dqch.getId() != qchS.getId()) continue;
                                    dqch.setBiologicalGroupId(Long.valueOf(biolGroup.getId()));
                                    dqch.setBiologicalGroupName(biolGroup.getName());
                                    sortedQch.add(dqch);
                                    continue block13;
                                }
                            }
                        }
                    }
                    ((DMasterQuantitationChannel)dataset.getMasterQuantitationChannels().get(0)).setQuantitationChannels(sortedQch);
                }
            }
            if ((objectTreeIdByName = datasetDB.getObjectTreeIdByName()) != null) {
                for (Map.Entry entry : objectTreeIdByName.entrySet()) {
                    if (!((String)entry.getKey()).startsWith("quantitation")) continue;
                    Long objectId = (Long)entry.getValue();
                    fr.proline.core.orm.uds.ObjectTree objectTree = (fr.proline.core.orm.uds.ObjectTree)entityManagerUDS.find(fr.proline.core.orm.uds.ObjectTree.class, (Object)objectId);
                    dataset.setObjectTree(objectTree);
                }
            }
            entityManagerMSI.getTransaction().commit();
            entityManagerUDS.getTransaction().commit();
            entityManagerLCMS.getTransaction().commit();
            m_logger.info("fetchQuantChannels took " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            String trace2String = Arrays.stream(e.getStackTrace()).map(es -> es.toString()).collect(Collectors.joining("\n"));
            m_logger.error("fetchDataQuantChannels failed: {}, \n StackTrace:\n{}", (Object)e, (Object)trace2String);
            TaskError taskError = new TaskError(e);
            try {
                entityManagerMSI.getTransaction().rollback();
                entityManagerUDS.getTransaction().rollback();
                entityManagerLCMS.getTransaction().rollback();
            }
            catch (Exception rollbackException) {
                m_logger.error(DatabaseLoadXicMasterQuantTask.class.getSimpleName() + " failed : potential network problem", rollbackException);
            }
            TaskError taskError2 = taskError;
            return taskError2;
        }
        finally {
            entityManagerLCMS.close();
            entityManagerMSI.close();
            entityManagerUDS.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskError fetchDataset(Long projectId, ArrayList<Long> childrenDatasetId, ArrayList<DDataset> m_childrenDatasetList) {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            String query = "SELECT d FROM fr.proline.core.orm.uds.Dataset d WHERE d.id IN (:list) ";
            TypedQuery queryDataset = entityManagerUDS.createQuery(query, Dataset.class);
            queryDataset.setParameter("list", childrenDatasetId);
            List datasets = queryDataset.getResultList();
            for (Dataset d : datasets) {
                DDataset dDataset = new DDataset(d.getId(), d.getProject(), d.getName(), d.getType(), d.getChildrenCount(), d.getResultSetId(), d.getResultSummaryId(), d.getNumber());
                TaskError taskError = DatabaseLoadXicMasterQuantTask.fetchDataQuantChannels(projectId, dDataset);
                if (taskError != null) {
                    TaskError taskError2 = taskError;
                    return taskError2;
                }
                m_childrenDatasetList.add(dDataset);
            }
            entityManagerUDS.getTransaction().commit();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskError fetchDataQuantChannels(HashSet<Long> ids, HashMap<Long, DQuantitationChannel> quantitationChannelsMap) {
        try (EntityManager entityManagerUDS = DStoreCustomPoolConnectorFactory.getInstance().getUdsDbConnector().createEntityManager();){
            entityManagerUDS.getTransaction().begin();
            String query = "SELECT qc FROM fr.proline.core.orm.uds.QuantitationChannel qc WHERE qc.id IN (:list) ";
            TypedQuery queryLinkedRs = entityManagerUDS.createQuery(query, QuantitationChannel.class);
            queryLinkedRs.setParameter("list", ids);
            List quantitationChannels = queryLinkedRs.getResultList();
            for (QuantitationChannel qc : quantitationChannels) {
                quantitationChannelsMap.put(qc.getId(), new DQuantitationChannel(qc));
            }
            entityManagerUDS.getTransaction().commit();
        }
        return null;
    }

    private static List<DQuantitationChannel> createDQuantChannelsForMQC(Long projectId, MasterQuantitationChannel masterQuantitationChannel, EntityManager entityManagerMSI, EntityManager entityManagerUDS, EntityManager entityManagerLCMS) {
        List listQuantitationChannels = masterQuantitationChannel.getQuantitationChannels();
        ArrayList<DQuantitationChannel> listDQuantChannels = new ArrayList<DQuantitationChannel>();
        for (QuantitationChannel qc : listQuantitationChannels) {
            DQuantitationChannel dqc = new DQuantitationChannel(qc);
            String resultFileName = "";
            String rawPath = "";
            Long rsId = null;
            String queryMsi = "SELECT msi.resultFileName, pl.path, rsm.resultSet.id  FROM MsiSearch msi, Peaklist pl, ResultSet rs, ResultSummary rsm  WHERE rsm.id=:rsmId AND rsm.resultSet.id = rs.id AND rs.msiSearch.id = msi.id AND msi.peaklist.id = pl.id ";
            Query qMsi = entityManagerMSI.createQuery(queryMsi);
            qMsi.setParameter("rsmId", (Object)qc.getIdentResultSummaryId());
            try {
                Object[] res = (Object[])qMsi.getSingleResult();
                resultFileName = (String)res[0];
                rawPath = (String)res[1];
                if (resultFileName != null && resultFileName.contains(".")) {
                    resultFileName = resultFileName.substring(0, resultFileName.indexOf(46));
                }
                rsId = (Long)res[2];
            }
            catch (NoResultException | NonUniqueResultException res) {
                // empty catch block
            }
            String rawFileIdentifier = null;
            String queryQCName = "SELECT ds.name, run.rawFile.identifier FROM fr.proline.core.orm.uds.Dataset ds, fr.proline.core.orm.uds.QuantitationChannel qc, fr.proline.core.orm.uds.Run run WHERE ds.resultSummaryId = qc.identResultSummaryId AND qc.id=:qChId AND ds.project.id=:projectId AND qc.run.id=run.id ";
            Query queryQCNameQ = entityManagerUDS.createQuery(queryQCName);
            queryQCNameQ.setParameter("qChId", (Object)qc.getId());
            queryQCNameQ.setParameter("projectId", (Object)projectId);
            try {
                String name;
                Object[] res = (Object[])queryQCNameQ.getSingleResult();
                resultFileName = name = (String)res[0];
                rawFileIdentifier = (String)res[1];
            }
            catch (NoResultException | NonUniqueResultException res) {
                // empty catch block
            }
            dqc.setResultFileName(resultFileName);
            dqc.setRawFilePath(rawPath);
            dqc.setRawFileIdentifier(rawFileIdentifier);
            String mzdbFile = "";
            try {
                mzdbFile = qc.getRun().getRawFile().getMzDbFileName();
            }
            catch (Exception e) {
                String trace2String = Arrays.stream(e.getStackTrace()).map(es -> es.toString()).collect(Collectors.joining("\n"));
                m_logger.error("Error while retrieving mzdb file: {}, \n StackTrace:\n{}", (Object)e, (Object)trace2String);
            }
            dqc.setMzdbFileName(mzdbFile);
            String queryLcms = "SELECT pmrm.rawMap.id FROM fr.proline.core.orm.lcms.Map  m, ProcessedMap pm, ProcessedMapRawMapMapping pmrm WHERE m.id =:processedMapId AND m.id = pm.id AND pm.id = pmrm.id.processedMapId ";
            TypedQuery queryRawMapLcms = entityManagerLCMS.createQuery(queryLcms, Long.class);
            queryRawMapLcms.setParameter("processedMapId", (Object)qc.getLcmsMapId());
            try {
                Long rawMapId = (Long)queryRawMapLcms.getSingleResult();
                dqc.setLcmsRawMapId(rawMapId);
            }
            catch (NoResultException | NonUniqueResultException rawMapId) {
                // empty catch block
            }
            if (rsId != null) {
                ResultSet rsetFound = (ResultSet)entityManagerMSI.find(ResultSet.class, (Object)rsId);
                dqc.setIdentRs(rsetFound);
            } else {
                dqc.setIdentRs(null);
            }
            String queryIdentDsS = "SELECT ds.id FROM Dataset ds WHERE ds.resultSetId=:rsId AND ds.resultSummaryId=:rsmId AND ds.project.id=:projectId ";
            TypedQuery queryIdentDs = entityManagerUDS.createQuery(queryIdentDsS, Long.class);
            queryIdentDs.setParameter("rsId", (Object)rsId);
            queryIdentDs.setParameter("rsmId", (Object)qc.getIdentResultSummaryId());
            queryIdentDs.setParameter("projectId", (Object)projectId);
            try {
                Long identDsId = (Long)queryIdentDs.getSingleResult();
                dqc.setIdentDatasetId(identDsId);
            }
            catch (NoResultException | NonUniqueResultException e) {
                dqc.setIdentDatasetId(Long.valueOf(-1L));
            }
            dqc.setBiologicalSample(qc.getBiologicalSample());
            listDQuantChannels.add(dqc);
        }
        return listDQuantChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataProteinMainTask() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            List listMasterQuantitationChannels = this.m_dataset.getMasterQuantitationChannels();
            if (listMasterQuantitationChannels != null && !listMasterQuantitationChannels.isEmpty()) {
                for (DMasterQuantitationChannel masterQuantitationChannel : listMasterQuantitationChannels) {
                    Long resultSummaryId = masterQuantitationChannel.getQuantResultSummaryId();
                    if (resultSummaryId == null) continue;
                    Query proteinSetsQuery = entityManagerMSI.createQuery("SELECT ps.id  FROM PeptideSet pepset JOIN pepset.proteinSet as ps  WHERE ps.resultSummary.id=:rsmId AND ps.isValidated=true ORDER BY pepset.score DESC");
                    if (this.m_dataset.getQuantMethodInfo() == DDatasetType.QuantitationMethodInfo.SPECTRAL_COUNTING) {
                        proteinSetsQuery = entityManagerMSI.createQuery("SELECT ps.id  FROM PeptideSet pepset JOIN pepset.proteinSet as ps  WHERE ps.resultSummary.id=:rsmId AND ps.isValidated=true AND ps.masterQuantComponentId is not null ORDER BY pepset.score DESC");
                    }
                    proteinSetsQuery.setParameter("rsmId", (Object)resultSummaryId);
                    List proteinSets = proteinSetsQuery.getResultList();
                    if (proteinSets == null || proteinSets.isEmpty()) continue;
                    int nbProteinSet = proteinSets.size();
                    m_logger.debug("------- > fetchDataProteinMainTask : get ProtSet with MQPS: " + nbProteinSet);
                    this.m_proteinSetIds = new ArrayList<Long>(nbProteinSet);
                    this.m_resultSetIds = new ArrayList<Long>(nbProteinSet);
                    for (int i = 0; i < nbProteinSet; ++i) {
                        Long id = (Long)proteinSets.get(i);
                        this.m_proteinSetIds.add(id);
                        this.m_resultSetIds.add(resultSummaryId);
                        DMasterQuantProteinSet dMasterQuantProteinSet = new DMasterQuantProteinSet();
                        dMasterQuantProteinSet.setProteinSetId(id.longValue());
                        dMasterQuantProteinSet.setId(-1L);
                        dMasterQuantProteinSet.setQuantResultSummaryId(resultSummaryId);
                        this.m_masterQuantProteinSetList.add(dMasterQuantProteinSet);
                    }
                    SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(1, this.m_proteinSetIds.size(), 1000);
                    this.fetchProteinSetData(subTask, entityManagerMSI);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataPeptideMainTask(boolean xic, Long[] peptideInstanceIdArray) {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId.longValue()).createEntityManager();){
            List listMasterQuantitationChannels;
            entityManagerMSI.getTransaction().begin();
            boolean pepInstSpecified = peptideInstanceIdArray != null;
            boolean mqPepCreatedForSpecifiedPepInstance = true;
            this.m_peptideInstanceIds = new ArrayList<Long>();
            if (pepInstSpecified) {
                this.m_peptideInstanceIds.addAll(Arrays.asList(peptideInstanceIdArray));
                mqPepCreatedForSpecifiedPepInstance = false;
            }
            if ((listMasterQuantitationChannels = this.m_dataset.getMasterQuantitationChannels()) != null && !listMasterQuantitationChannels.isEmpty()) {
                for (DMasterQuantitationChannel masterQuantitationChannel : listMasterQuantitationChannels) {
                    Long quantResultSummaryId = masterQuantitationChannel.getQuantResultSummaryId();
                    if (quantResultSummaryId == null) continue;
                    ArrayList<Long> currentMQChPepInstanceIds = new ArrayList<Long>();
                    if (!pepInstSpecified) {
                        String queryPep = "SELECT pi.id FROM fr.proline.core.orm.msi.PeptideInstance pi WHERE pi.resultSummary.id=:rsmId ";
                        queryPep = queryPep + "ORDER BY pi.id ASC";
                        Query peptidesQuery = entityManagerMSI.createQuery(queryPep);
                        peptidesQuery.setParameter("rsmId", (Object)quantResultSummaryId);
                        List listIds = peptidesQuery.getResultList();
                        currentMQChPepInstanceIds.addAll(listIds);
                        this.m_peptideInstanceIds.addAll(currentMQChPepInstanceIds);
                        m_logger.info("### loading XIC for peptides ... query returns {} peptide instances", (Object)this.m_peptideInstanceIds.size());
                    } else if (!mqPepCreatedForSpecifiedPepInstance) {
                        mqPepCreatedForSpecifiedPepInstance = true;
                        currentMQChPepInstanceIds.addAll(this.m_peptideInstanceIds);
                    }
                    ArrayList<DMasterQuantPeptide> listDMasterQuantPeptideFake = new ArrayList<DMasterQuantPeptide>();
                    for (Long m_peptideInstanceId : currentMQChPepInstanceIds) {
                        DMasterQuantPeptide f = new DMasterQuantPeptide(-1L, -1, -1L, "", quantResultSummaryId);
                        f.setPeptideInstanceId(m_peptideInstanceId.longValue());
                        listDMasterQuantPeptideFake.add(f);
                    }
                    this.m_masterQuantPeptideList.addAll(listDMasterQuantPeptideFake);
                    if (pepInstSpecified) continue;
                    String queryNonIndent = "SELECT mqc.id FROM fr.proline.core.orm.msi.ObjectTree ot, fr.proline.core.orm.msi.MasterQuantComponent mqc WHERE mqc.resultSummary.id=:rsmId AND NOT EXISTS (select 1 from fr.proline.core.orm.msi.PeptideInstance pi where pi.resultSummary.id=:rsmId AND pi.masterQuantComponentId = mqc.id ) AND ot.id =  mqc.objectTreeId AND ot.schema.name like 'object_tree.label_free_quant_peptides' ";
                    Query quantPeptideNonIdentQuery = entityManagerMSI.createQuery(queryNonIndent);
                    quantPeptideNonIdentQuery.setParameter("rsmId", (Object)quantResultSummaryId);
                    List listPepNonIdentIds = quantPeptideNonIdentQuery.getResultList();
                    for (Long pepNonIdentId : listPepNonIdentIds) {
                        DMasterQuantPeptide f = new DMasterQuantPeptide(pepNonIdentId.longValue(), -1, -1L, "", quantResultSummaryId);
                        f.setPeptideInstanceId(-pepNonIdentId.longValue());
                        this.m_peptideInstanceIds.add(-pepNonIdentId.longValue());
                        this.m_masterQuantPeptideList.add(f);
                    }
                }
                SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(4, this.m_peptideInstanceIds.size(), 1000);
                this.fetchPeptideInstanceData(subTask, entityManagerMSI, xic);
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataPeptideIonMainTask() {
        long start = System.currentTimeMillis();
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            List listMasterQuantitationChannels = this.m_dataset.getMasterQuantitationChannels();
            if (listMasterQuantitationChannels != null && !listMasterQuantitationChannels.isEmpty()) {
                for (DMasterQuantitationChannel masterQuantitationChannel : listMasterQuantitationChannels) {
                    List listIds;
                    Long resultSummaryId = masterQuantitationChannel.getQuantResultSummaryId();
                    if (resultSummaryId == null) continue;
                    String queryPepIon = "SELECT mqpi.id FROM MasterQuantPeptideIon mqpi WHERE mqpi.resultSummary.id=:rsmId ORDER BY mqpi.id ASC";
                    Query peptideIonsQuery = entityManagerMSI.createQuery(queryPepIon);
                    peptideIonsQuery.setParameter("rsmId", (Object)resultSummaryId);
                    this.m_masterQuantPeptideIonIds = listIds = peptideIonsQuery.getResultList();
                    for (Long m_masterQuantPeptideIonId : this.m_masterQuantPeptideIonIds) {
                        DMasterQuantPeptideIon mqpi = new DMasterQuantPeptideIon();
                        mqpi.setId(m_masterQuantPeptideIonId.longValue());
                        this.m_masterQuantPeptideIonList.add(mqpi);
                    }
                    m_logger.info("Peptide Ions ids fetched in = " + (System.currentTimeMillis() - start) + " ms");
                    SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(6, this.m_masterQuantPeptideIonIds.size(), 1000);
                    if (subTask == null) continue;
                    this.fetchPeptideIonData(subTask, entityManagerMSI);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataPeptideForProteinSetMainTask(boolean xic) {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            List listMasterQuantitationChannels = this.m_dataset.getMasterQuantitationChannels();
            if (listMasterQuantitationChannels != null && !listMasterQuantitationChannels.isEmpty()) {
                for (DMasterQuantitationChannel masterQuantitationChannel : listMasterQuantitationChannels) {
                    List listIds;
                    Long resultSummaryId = masterQuantitationChannel.getQuantResultSummaryId();
                    if (resultSummaryId == null) continue;
                    Long protSetId = this.m_dMasterQuantProteinSet.getProteinSetId();
                    String queryPep = "SELECT pi.id FROM fr.proline.core.orm.msi.PeptideInstance pi, fr.proline.core.orm.msi.PeptideSetPeptideInstanceItem pspi, fr.proline.core.orm.msi.PeptideSet pepSet WHERE pi.resultSummary.id=:rsmId AND pi.id = pspi.peptideInstance.id AND pspi.peptideSet.id = pepSet.id AND pepSet.proteinSet.id=:proteinSetId ORDER BY pi.id ASC";
                    Query peptidesQuery = entityManagerMSI.createQuery(queryPep);
                    peptidesQuery.setParameter("rsmId", (Object)resultSummaryId);
                    peptidesQuery.setParameter("proteinSetId", (Object)protSetId);
                    this.m_peptideInstanceIds = listIds = peptidesQuery.getResultList();
                    ArrayList<DMasterQuantPeptide> listDMasterQuantPeptideFake = new ArrayList<DMasterQuantPeptide>();
                    for (Long m_peptideInstanceId : this.m_peptideInstanceIds) {
                        DMasterQuantPeptide f = new DMasterQuantPeptide(-1L, -1, -1L, "", resultSummaryId);
                        f.setPeptideInstanceId(m_peptideInstanceId.longValue());
                        listDMasterQuantPeptideFake.add(f);
                    }
                    this.m_masterQuantPeptideList.addAll(listDMasterQuantPeptideFake);
                    this.fetchPeptideInstanceData(entityManagerMSI, this.m_peptideInstanceIds, xic);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    private boolean fetchPeptideInstanceData(EntityManager entityManagerMSI, List<Long> listPeptideInstanceIds, boolean xic) throws Exception {
        HashMap<Long, Peptide> peptideMap = new HashMap<Long, Peptide>();
        HashMap<Long, Long> rsmIdVsQcId = new HashMap<Long, Long>();
        ArrayList<Long> rsmIdList = new ArrayList<Long>();
        List listMasterQuantitationChannels = this.m_dataset.getMasterQuantitationChannels();
        for (DMasterQuantitationChannel masterQuantChannel : listMasterQuantitationChannels) {
            List listQc = masterQuantChannel.getQuantitationChannels();
            for (DQuantitationChannel qc : listQc) {
                rsmIdVsQcId.put(qc.getIdentResultSummaryId(), qc.getId());
                rsmIdList.add(qc.getIdentResultSummaryId());
            }
        }
        boolean isBestIonSummarizingMethod = this.mayBestIonPropertySet();
        ArrayList<DPeptideInstance> peptideInstanceList = new ArrayList<DPeptideInstance>();
        String querySelect = xic ? "SELECT  pi, pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, p, pm.serializedProperties, mqpi.elutionTime FROM fr.proline.core.orm.msi.PeptideInstance pi,  fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.MasterQuantPeptideIon mqpi WHERE pi.id IN (:listId) AND pi.bestPeptideMatchId=pm.id AND pm.peptideId=p.id  AND  pi.id = mqpi.peptideInstance.id ORDER BY pm.score DESC" : "SELECT  pi, pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, p, pm.serializedProperties FROM fr.proline.core.orm.msi.PeptideInstance pi,  fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.Peptide p WHERE pi.id IN (:listId) AND pi.bestPeptideMatchId=pm.id AND pm.peptideId=p.id ORDER BY pm.score DESC";
        Query query = entityManagerMSI.createQuery(querySelect);
        query.setParameter("listId", listPeptideInstanceIds);
        List resultList = query.getResultList();
        HashMap<Long, DPeptideMatch> peptideMatchMap = new HashMap<Long, DPeptideMatch>();
        for (Object[] resCur : resultList) {
            PeptideInstance pi = (PeptideInstance)resCur[0];
            Float elutionTime = xic ? (Float)resCur[13] : pi.getElutionTime();
            DPeptideInstance dpi = new DPeptideInstance(pi);
            dpi.setElutionTime(elutionTime);
            dpi.setResultSummary(pi.getResultSummary());
            Long pmId = (Long)resCur[1];
            DPeptideMatch pm = (DPeptideMatch)peptideMatchMap.get(pmId);
            if (pm == null) {
                Integer pmRank = (Integer)resCur[2];
                Integer pmCharge = (Integer)resCur[3];
                Float pmDeltaMoz = (Float)resCur[4];
                Double pmExperimentalMoz = (Double)resCur[5];
                Integer pmMissedCleavage = (Integer)resCur[6];
                Float pmScore = (Float)resCur[7];
                Long pmResultSetId = (Long)resCur[8];
                Integer pmCdPrettyRank = (Integer)resCur[9];
                Integer pmSdPrettyRank = (Integer)resCur[10];
                String pmSerializedProp = (String)resCur[12];
                pm = new DPeptideMatch(pmId.longValue(), pmRank, pmCharge.intValue(), pmDeltaMoz, pmExperimentalMoz.doubleValue(), pmMissedCleavage.intValue(), pmScore, pmResultSetId.longValue(), pmCdPrettyRank, pmSdPrettyRank, pmSerializedProp);
                pm.setRetentionTime(elutionTime);
                peptideMatchMap.put(pmId, pm);
            }
            Peptide p = (Peptide)resCur[11];
            p.getTransientData().setPeptideReadablePtmStringLoaded();
            peptideMap.put(p.getId(), p);
            dpi.setBestPeptideMatch(pm);
            dpi.setPeptide(p);
            pm.setPeptide(p);
            peptideInstanceList.add(dpi);
        }
        DatabasePTMSitesTask.fetchReadablePTMData(entityManagerMSI, this.m_dataset.getResultSetId(), peptideMap, null);
        DatabasePTMSitesTask.fetchPTMDataForPeptides(entityManagerMSI, peptideMap, null);
        int nbMP = this.m_masterQuantPeptideList.size();
        int nbPI = peptideInstanceList.size();
        String queryDMasterQuantPeptide = "SELECT q.id, q.selectionLevel, q.objectTreeId,  q.serializedProperties,  pi.resultSummary.id, pi.id FROM MasterQuantComponent q, PeptideInstance pi  WHERE pi.id IN (:listPeptideInstanceId) AND  q.id = pi.masterQuantComponentId  ORDER BY q.id ASC ";
        Query mqPeptideQ = entityManagerMSI.createQuery(queryDMasterQuantPeptide);
        mqPeptideQ.setParameter("listPeptideInstanceId", listPeptideInstanceIds);
        List resultListMQPeptide = mqPeptideQ.getResultList();
        ArrayList<Long> listObjectTreeId = new ArrayList<Long>();
        ArrayList<Long> listPeptideId = new ArrayList<Long>();
        ArrayList<DMasterQuantPeptide> listMasterQP = new ArrayList<DMasterQuantPeptide>();
        this.m_masterQuantPeptideIonList = new ArrayList<DMasterQuantPeptideIon>();
        for (Object[] resCur : resultListMQPeptide) {
            Long bestMQPepIonId;
            List mqpepIonIds;
            MasterQuantPeptideProperties mqPepProp;
            int i = 0;
            long masterQuantPeptideId = (Long)resCur[i++];
            int selectionLevel = (Integer)resCur[i++];
            long objectTreeId = (Long)resCur[i++];
            String serializedProp = (String)resCur[i++];
            long quantRSId = (Long)resCur[i++];
            long peptideInstanceId = (Long)resCur[i++];
            DMasterQuantPeptide masterQuantPeptide = new DMasterQuantPeptide(masterQuantPeptideId, selectionLevel, objectTreeId, serializedProp, Long.valueOf(quantRSId));
            DPeptideInstance pi = null;
            for (int k = 0; k < nbPI; ++k) {
                if (((DPeptideInstance)peptideInstanceList.get(k)).getId() != peptideInstanceId) continue;
                pi = (DPeptideInstance)peptideInstanceList.get(k);
                break;
            }
            masterQuantPeptide.setPeptideInstance(pi);
            masterQuantPeptide.setPeptideInstanceId(peptideInstanceId);
            listObjectTreeId.add(objectTreeId);
            listPeptideId.add(pi.getPeptideId());
            listMasterQP.add(masterQuantPeptide);
            if (!isBestIonSummarizingMethod || (mqPepProp = masterQuantPeptide.getMasterQuantPeptideProperties()) == null || mqPepProp.getMqPepIonAbundanceSummarizingConfig() == null || (mqpepIonIds = mqPepProp.getMqPepIonAbundanceSummarizingConfig().getSelectedMasterQuantPeptideIonIds()).isEmpty() || (bestMQPepIonId = (Long)mqpepIonIds.get(0)) == null || bestMQPepIonId <= 0L) continue;
            DMasterQuantPeptideIon mqpi = new DMasterQuantPeptideIon();
            mqpi.setId(bestMQPepIonId.longValue());
            ArrayList<Long> bestMQPepIonIds = new ArrayList<Long>();
            bestMQPepIonIds.add(bestMQPepIonId);
            this.m_masterQuantPeptideIonList.clear();
            this.m_masterQuantPeptideIonList.add(mqpi);
            this.fetchPeptideIonData(entityManagerMSI, bestMQPepIonIds);
            mqpi = this.m_masterQuantPeptideIonList.get(0);
            masterQuantPeptide.setRepresentativePepMatch(mqpi.getRepresentativePepMatch());
        }
        HashMap<Long, HashMap<Long, Integer>> identPSMPerQCIdPerPepId = new HashMap<Long, HashMap<Long, Integer>>();
        if (!listPeptideId.isEmpty()) {
            String queryCountPSM = "SELECT pi.peptideMatchCount, pi.resultSummary.id, pi.peptide.id FROM PeptideInstance pi WHERE pi.resultSummary.id in (:listRsm) AND pi.peptide.id in (:listPepIds) ";
            Query queryPSM = entityManagerMSI.createQuery(queryCountPSM);
            queryPSM.setParameter("listRsm", rsmIdList);
            queryPSM.setParameter("listPepIds", listPeptideId);
            List resultListPSM = queryPSM.getResultList();
            for (Object[] nb : resultListPSM) {
                int psm = (Integer)nb[0];
                Long rsmId = (Long)nb[1];
                Long qcId = (Long)rsmIdVsQcId.get(rsmId);
                Long peptideId = (Long)nb[2];
                HashMap<Long, Integer> identPSMPerQCId = (HashMap<Long, Integer>)identPSMPerQCIdPerPepId.get(peptideId);
                if (identPSMPerQCId == null) {
                    identPSMPerQCId = new HashMap<Long, Integer>();
                }
                identPSMPerQCId.put(qcId, psm);
                identPSMPerQCIdPerPepId.put(peptideId, identPSMPerQCId);
            }
        }
        List listOt = new ArrayList();
        if (listObjectTreeId.size() > 0) {
            String otQuery = "SELECT ot FROM fr.proline.core.orm.msi.ObjectTree ot WHERE id IN (:listId) ";
            TypedQuery queryObjectTree = entityManagerMSI.createQuery(otQuery, ObjectTree.class);
            queryObjectTree.setParameter("listId", listObjectTreeId);
            listOt = queryObjectTree.getResultList();
        }
        for (DMasterQuantPeptide masterQuantPeptide : listMasterQP) {
            Map identPSMPerQCId;
            int index = -1;
            for (int k = 0; k < nbMP; ++k) {
                if (this.m_masterQuantPeptideList.get(k).getPeptideInstanceId() != masterQuantPeptide.getPeptideInstanceId()) continue;
                index = k;
                break;
            }
            String quantPeptideData = "";
            ObjectTree ot = null;
            for (ObjectTree objectTree : listOt) {
                if (objectTree.getId() != masterQuantPeptide.getObjectTreeId()) continue;
                ot = objectTree;
                break;
            }
            if (ot != null) {
                quantPeptideData = ot.getClobData();
            }
            Map quantProteinSetByQchIds = null;
            if (quantPeptideData != null && !quantPeptideData.isEmpty()) {
                quantProteinSetByQchIds = masterQuantPeptide.parseQuantPeptideFromProperties(quantPeptideData);
            }
            if ((identPSMPerQCId = (Map)identPSMPerQCIdPerPepId.get(masterQuantPeptide.getPeptideInstance().getPeptideId())) != null) {
                for (Map.Entry entrySet : quantProteinSetByQchIds.entrySet()) {
                    Long qcId = (Long)entrySet.getKey();
                    DQuantPeptide quantPeptide = (DQuantPeptide)entrySet.getValue();
                    Integer psm = (Integer)identPSMPerQCId.get(qcId);
                    if (psm == null) continue;
                    quantPeptide.setIdentPeptideMatchCount(psm);
                }
            }
            masterQuantPeptide.setQuantPeptideByQchIds(quantProteinSetByQchIds);
            masterQuantPeptide.setCluster(this.getPeptideCluster(masterQuantPeptide.getId()));
            this.m_masterQuantPeptideList.set(index, masterQuantPeptide);
        }
        ArrayList<DPeptideInstance> extendedPeptideInstanceList = null;
        for (int i = 0; i < nbMP; ++i) {
            DMasterQuantPeptide masterQuantPeptide = this.m_masterQuantPeptideList.get(i);
            if (masterQuantPeptide.getId() != -1L) continue;
            if (extendedPeptideInstanceList == null) {
                extendedPeptideInstanceList = new ArrayList<DPeptideInstance>();
                String querySelect2 = "SELECT  pi, pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.serializedProperties, p FROM fr.proline.core.orm.msi.PeptideInstance pi,  fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.Peptide p  WHERE pi.id IN (:listId) AND  pi.bestPeptideMatchId=pm.id AND pm.peptideId=p.id  ORDER BY pm.score DESC";
                Query query2 = entityManagerMSI.createQuery(querySelect2);
                query2.setParameter("listId", listPeptideInstanceIds);
                List resultList2 = query2.getResultList();
                for (Object[] resCur : resultList2) {
                    PeptideInstance pi = (PeptideInstance)resCur[0];
                    DPeptideInstance dpi = new DPeptideInstance(pi);
                    dpi.setResultSummary(pi.getResultSummary());
                    Long pmId = (Long)resCur[1];
                    DPeptideMatch pm = peptideMatchMap.get(pmId);
                    if (pm == null) {
                        Integer pmRank = (Integer)resCur[2];
                        Integer pmCharge = (Integer)resCur[3];
                        Float pmDeltaMoz = (Float)resCur[4];
                        Double pmExperimentalMoz = (Double)resCur[5];
                        Integer pmMissedCleavage = (Integer)resCur[6];
                        Float pmScore = (Float)resCur[7];
                        Long pmResultSetId = (Long)resCur[8];
                        Integer pmCdPrettyRank = (Integer)resCur[9];
                        Integer pmSdPrettyRank = (Integer)resCur[10];
                        String pmSerializedProp = (String)resCur[11];
                        pm = new DPeptideMatch(pmId.longValue(), pmRank, pmCharge.intValue(), pmDeltaMoz, pmExperimentalMoz.doubleValue(), pmMissedCleavage.intValue(), pmScore, pmResultSetId.longValue(), pmCdPrettyRank, pmSdPrettyRank, pmSerializedProp);
                        if (!xic) {
                            pm.setRetentionTime(pi.getElutionTime());
                        }
                        peptideMatchMap.put(pmId, pm);
                    }
                    Peptide p = (Peptide)resCur[12];
                    p.getTransientData().setPeptideReadablePtmStringLoaded();
                    peptideMap.put(p.getId(), p);
                    dpi.setBestPeptideMatch(pm);
                    dpi.setPeptide(p);
                    pm.setPeptide(p);
                    extendedPeptideInstanceList.add(dpi);
                }
            }
            DPeptideInstance peptideInstance = null;
            if (masterQuantPeptide.getPeptideInstanceId() <= 0L || listPeptideInstanceIds.indexOf(masterQuantPeptide.getPeptideInstanceId()) == -1) continue;
            nbPI = extendedPeptideInstanceList.size();
            for (int k = 0; k < nbPI; ++k) {
                if (((DPeptideInstance)extendedPeptideInstanceList.get(k)).getId() != masterQuantPeptide.getPeptideInstanceId()) continue;
                peptideInstance = (DPeptideInstance)extendedPeptideInstanceList.get(k);
                break;
            }
            DMasterQuantPeptide o = new DMasterQuantPeptide(-1L, -1, -1L, null, masterQuantPeptide.getQuantResultSummaryId());
            o.setPeptideInstance(peptideInstance);
            o.setPeptideInstanceId(masterQuantPeptide.getPeptideInstanceId());
            String queryCountPSM = "SELECT pi.peptideMatchCount, pi.resultSummary.id FROM PeptideInstance pi WHERE pi.resultSummary.id in (:listRsm) AND pi.peptide.id =:pepId ";
            Query queryPSM = entityManagerMSI.createQuery(queryCountPSM);
            queryPSM.setParameter("listRsm", rsmIdList);
            queryPSM.setParameter("pepId", (Object)peptideInstance.getPeptideId());
            HashMap<Long, DQuantPeptide> quantProteinSetByQchIds = new HashMap<Long, DQuantPeptide>();
            List resultListPSM = queryPSM.getResultList();
            for (Object[] nb : resultListPSM) {
                int psm = (Integer)nb[0];
                Long rsmId = (Long)nb[1];
                Long qcId = (Long)rsmIdVsQcId.get(rsmId);
                DQuantPeptide quantPeptide = new DQuantPeptide(Float.valueOf(Float.NaN), Float.valueOf(Float.NaN), Integer.valueOf(-1), null, qcId);
                quantPeptide.setIdentPeptideMatchCount(Integer.valueOf(psm));
                quantProteinSetByQchIds.put(qcId, quantPeptide);
                o.setQuantPeptideByQchIds(quantProteinSetByQchIds);
            }
            this.m_masterQuantPeptideList.set(i, o);
        }
        DatabasePTMSitesTask.fetchReadablePTMData(entityManagerMSI, this.m_dataset.getResultSetId(), peptideMap, null);
        DatabasePTMSitesTask.fetchPTMDataForPeptides(entityManagerMSI, peptideMap, null);
        queryDMasterQuantPeptide = "SELECT  new fr.proline.core.orm.msi.dto.DMasterQuantPeptide(q.id, q.selectionLevel, q.objectTreeId,  q.serializedProperties,  q.resultSummary.id) FROM MasterQuantComponent q  WHERE q.id=:masterQuantPeptideId";
        TypedQuery masterQuantPeptideQuery = entityManagerMSI.createQuery(queryDMasterQuantPeptide, DMasterQuantPeptide.class);
        for (Long pepInstanceId : listPeptideInstanceIds) {
            if (pepInstanceId >= 0L) continue;
            masterQuantPeptideQuery.setParameter("masterQuantPeptideId", (Object)(-pepInstanceId.longValue()));
            try {
                DMasterQuantPeptide masterQuantPeptide = (DMasterQuantPeptide)masterQuantPeptideQuery.getSingleResult();
                if (masterQuantPeptide != null) {
                    DPeptideInstance fakePeptideInstance = new DPeptideInstance(null);
                    ResultSummary rs = new ResultSummary();
                    rs.setId(masterQuantPeptide.getQuantResultSummaryId().longValue());
                    fakePeptideInstance.setResultSummary(rs);
                    masterQuantPeptide.setPeptideInstance(fakePeptideInstance);
                    masterQuantPeptide.setPeptideInstanceId(-1L);
                    String quantPeptideData = "";
                    ObjectTree ot = (ObjectTree)entityManagerMSI.find(ObjectTree.class, (Object)masterQuantPeptide.getObjectTreeId());
                    if (ot != null) {
                        quantPeptideData = ot.getClobData();
                    }
                    Map quantProteinSetByQchIds = null;
                    if (quantPeptideData != null && !quantPeptideData.isEmpty()) {
                        quantProteinSetByQchIds = masterQuantPeptide.parseQuantPeptideFromProperties(quantPeptideData);
                    }
                    masterQuantPeptide.setQuantPeptideByQchIds(quantProteinSetByQchIds);
                    masterQuantPeptide.setCluster(this.getPeptideCluster(masterQuantPeptide.getId()));
                }
                int index = -1;
                for (int k = 0; k < nbMP; ++k) {
                    if (this.m_masterQuantPeptideList.get(k).getId() != masterQuantPeptide.getId()) continue;
                    index = k;
                    break;
                }
                this.m_masterQuantPeptideList.set(index, masterQuantPeptide);
            }
            catch (NoResultException | NonUniqueResultException throwable) {}
        }
        ArrayList peptideMatchIds = new ArrayList(peptideMatchMap.size());
        peptideMatchIds.addAll(peptideMatchMap.keySet());
        DatabaseLoadXicMasterQuantTask.fetchProteinSetName(entityManagerMSI, peptideMatchIds, peptideMatchMap);
        return true;
    }

    private boolean mayBestIonPropertySet() {
        boolean isBestIonSummarizingMethod = false;
        Map postProcessingParam = new HashMap();
        try {
            postProcessingParam = this.m_dataset.getPostQuantProcessingConfigAsMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (postProcessingParam == null) {
            isBestIonSummarizingMethod = true;
        } else if (!postProcessingParam.isEmpty() && postProcessingParam.containsKey("pep_ion_abundance_summarizing_method")) {
            String method = postProcessingParam.get("pep_ion_abundance_summarizing_method").toString();
            isBestIonSummarizingMethod = "BEST_ION".equals(method);
        }
        return isBestIonSummarizingMethod;
    }

    private DCluster getPeptideCluster(Long masterQuantPeptideId) {
        if (this.m_dMasterQuantProteinSet != null) {
            try {
                HashMap mqProtSetProfilesByGroupSetupNumber;
                MasterQuantProteinSetProperties prop = this.m_dMasterQuantProteinSet.getMasterQuantProtSetProperties();
                if (prop != null && (mqProtSetProfilesByGroupSetupNumber = prop.getMqProtSetProfilesByGroupSetupNumber()) != null) {
                    for (Map.Entry entry : mqProtSetProfilesByGroupSetupNumber.entrySet()) {
                        String groupSetupNumber = (String)entry.getKey();
                        List listMasterQuantProteinSetProfile = (List)entry.getValue();
                        if (listMasterQuantProteinSetProfile == null) continue;
                        int nbP = listMasterQuantProteinSetProfile.size();
                        for (int i = 0; i < nbP; ++i) {
                            MasterQuantProteinSetProperties.MasterQuantProteinSetProfile profile = (MasterQuantProteinSetProperties.MasterQuantProteinSetProfile)listMasterQuantProteinSetProfile.get(i);
                            if (profile.getMqPeptideIds() == null || !profile.getMqPeptideIds().contains(masterQuantPeptideId)) continue;
                            DCluster cluster = new DCluster(i + 1, profile.getAbundances(), profile.getRatios());
                            return cluster;
                        }
                    }
                }
            }
            catch (Exception e) {
                m_logger.error(this.getClass().getSimpleName() + " failed while retrieving MasterQuantProtSetProperties ", e);
            }
        }
        return null;
    }

    private boolean fetchProteinSetData(SubTask subTask, EntityManager entityManagerMSI) {
        List sliceOfProteinSetIds = subTask.getSubList(this.m_proteinSetIds);
        return DatabaseLoadXicMasterQuantTask.fetchProteinSetData(entityManagerMSI, this.m_dataset, this.m_masterQuantProteinSetList, sliceOfProteinSetIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchProteinSetDataSubTask() {
        SubTask slice = this.m_subTaskManager.getNextSubTask();
        if (slice == null) {
            return true;
        }
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            switch (slice.getSubTaskId()) {
                case 1: {
                    this.fetchProteinSetData(slice, entityManagerMSI);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    public static boolean fetchProteinSetData(EntityManager entityManagerMSI, DDataset dataset, List<DMasterQuantProteinSet> masterQuantProteinSetList, List<Long> proteinSetIds) {
        int nbMQP = masterQuantProteinSetList.size();
        m_logger.debug("fetchProteinSetData for " + proteinSetIds.size() + " of " + nbMQP + " masterQuantProteinSetList ");
        String queryDMasterQuantProteinSet = "SELECT new fr.proline.core.orm.msi.dto.DMasterQuantProteinSet(q.id,  q.selectionLevel, q.objectTreeId,  q.serializedProperties,  p.resultSummary.id,  p.id)  FROM MasterQuantComponent q,  ProteinSet p  WHERE p.id IN (:listId) AND   q.id = p.masterQuantComponentId  ORDER BY q.id ASC ";
        TypedQuery masterQuantProteinSetsQuery = entityManagerMSI.createQuery(queryDMasterQuantProteinSet, DMasterQuantProteinSet.class);
        masterQuantProteinSetsQuery.setParameter("listId", proteinSetIds);
        List listResult = masterQuantProteinSetsQuery.getResultList();
        TypedQuery proteinSetQuery = entityManagerMSI.createQuery("SELECT new fr.proline.core.orm.msi.dto.DProteinSet(ps.id, ps.representativeProteinMatchId, ps.resultSummary.id, ps.serializedProperties) FROM ProteinSet ps WHERE ps.id=:psId ", DProteinSet.class);
        String queryProteinMatch = "SELECT new fr.proline.core.orm.msi.dto.DProteinMatch(pm.id, pm.accession,  pm.score, pm.peptideCount, pm.resultSet.id, pm.description, pm.geneName, pm.serializedProperties) FROM ProteinMatch pm WHERE pm.id=:pmId";
        TypedQuery proteinMatchQuery = entityManagerMSI.createQuery(queryProteinMatch, DProteinMatch.class);
        String queryStrCountNbPepAndQuantPep = "SELECT count(pi.id) , pepSet.peptideCount FROM fr.proline.core.orm.msi.PeptideSet pepSet JOIN pepSet.peptideSetPeptideInstanceItems pspi JOIN pspi.peptideInstance pi, fr.proline.core.orm.msi.MasterQuantComponent mqc WHERE pepSet.resultSummaryId=:rsmId AND pepSet.proteinSet.id=:proteinSetId AND pi.masterQuantComponentId IS NOT NULL AND mqc.id = pi.masterQuantComponentId AND mqc.selectionLevel > 1GROUP BY pepSet.peptideCount ";
        Query queryCountPepAndQuantPep = entityManagerMSI.createQuery(queryStrCountNbPepAndQuantPep);
        String queryStrCountNbPep = "SELECT  pepSet.peptideCount FROM fr.proline.core.orm.msi.PeptideSet pepSet WHERE pepSet.resultSummaryId=:rsmId AND pepSet.proteinSet.id=:proteinSetId  ";
        Query queryCountPep = entityManagerMSI.createQuery(queryStrCountNbPep);
        String queryStrPepCountByProtMatch = "SELECT ps.peptideCount, pspmm.proteinMatch.id FROM PeptideSetProteinMatchMap pspmm, PeptideSet ps WHERE  pspmm.resultSummary.id=:rsmId  AND ps.id = pspmm.peptideSet.id ";
        Query queryPepCountByProtMatch = entityManagerMSI.createQuery(queryStrPepCountByProtMatch);
        String queryStrProtSetStatus = "SELECT ps.id, pspmi.proteinMatch.id, pspmi.isInSubset, ps.representativeProteinMatchId, ps.isValidated FROM ProteinSetProteinMatchItem pspmi, ProteinSet ps  WHERE ps.id = pspmi.proteinSet.id  AND pspmi.resultSummary.id=:rsmId ";
        Query queryProtSetStatus = entityManagerMSI.createQuery(queryStrProtSetStatus);
        List listQC = new ArrayList();
        HashMap protMatchStatusByIdByQcId = new HashMap();
        HashMap protMatchPepNumberByIdByQcId = new HashMap();
        if (dataset != null && dataset.getMasterQuantitationChannels() != null && !dataset.getMasterQuantitationChannels().isEmpty()) {
            listQC = ((DMasterQuantitationChannel)dataset.getMasterQuantitationChannels().get(0)).getQuantitationChannels();
            for (DQuantitationChannel qch : listQC) {
                Long proteinMatchId;
                Object[] res;
                Long identQCRsmId = qch.getIdentResultSummaryId();
                HashMap<Long, String> statusByProtMatchId = new HashMap<Long, String>();
                HashMap<Long, Integer> pepNumberByProtMatchId = new HashMap<Long, Integer>();
                queryProtSetStatus.setParameter("rsmId", (Object)identQCRsmId);
                queryPepCountByProtMatch.setParameter("rsmId", (Object)identQCRsmId);
                List rStatus = queryProtSetStatus.getResultList();
                List rPepNumber = queryPepCountByProtMatch.getResultList();
                for (Object resSt : rStatus) {
                    res = (Object[])resSt;
                    proteinMatchId = (Long)res[1];
                    Boolean isInSubset = (Boolean)res[2];
                    Long typProteinMatchId = (Long)res[3];
                    Boolean isProtSetValidated = (Boolean)res[4];
                    String protMatchStatus = isInSubset != false ? "Subset" : (typProteinMatchId.equals(proteinMatchId) ? "Typical" : "Sameset");
                    if (!isProtSetValidated.booleanValue()) {
                        protMatchStatus = "Invalid " + protMatchStatus;
                    }
                    statusByProtMatchId.put(proteinMatchId, protMatchStatus);
                }
                for (Object resPn : rPepNumber) {
                    res = (Object[])resPn;
                    proteinMatchId = (Long)res[1];
                    Integer pepNumber = (Integer)res[0];
                    pepNumberByProtMatchId.put(proteinMatchId, pepNumber);
                }
                protMatchStatusByIdByQcId.put(qch.getId(), statusByProtMatchId);
                protMatchPepNumberByIdByQcId.put(qch.getId(), pepNumberByProtMatchId);
            }
        }
        m_logger.debug(" fetchProteinSetData -- Get DMasterQuantProteinSet info and associated DQuantProteinSet for each Quant Channel");
        int nbrMqPsSet = 0;
        int nbrMqPsupdated = 0;
        for (DMasterQuantProteinSet masterQuantProteinSet : listResult) {
            MasterQuantProteinSetProperties mqPSprop;
            proteinSetQuery.setParameter("psId", (Object)masterQuantProteinSet.getProteinSetId());
            DProteinSet dProteinSet = (DProteinSet)proteinSetQuery.getSingleResult();
            if (dProteinSet == null) {
                m_logger.debug("--- NOT FOUND  DProteinSet for MQPrS " + masterQuantProteinSet.getId());
            }
            proteinMatchQuery.setParameter("pmId", (Object)dProteinSet.getProteinMatchId());
            try {
                DProteinMatch typicalProteinMatch = (DProteinMatch)proteinMatchQuery.getSingleResult();
                if (typicalProteinMatch == null) {
                    m_logger.debug("--- NOT FOUND  DProteinMatch for MQPrS " + masterQuantProteinSet.getId());
                }
                dProteinSet.setTypicalProteinMatch(typicalProteinMatch);
            }
            catch (NoResultException | NonUniqueResultException e) {
                m_logger.error("DatabaseLoadXicMasterQuantTask failed", e);
            }
            String quantProtSetdata = "";
            ObjectTree ot = (ObjectTree)entityManagerMSI.find(ObjectTree.class, (Object)masterQuantProteinSet.getObjectTreeId());
            if (ot != null) {
                quantProtSetdata = ot.getClobData();
            }
            Map quantProteinSetByQchIds = null;
            if (quantProtSetdata != null && !quantProtSetdata.isEmpty()) {
                quantProteinSetByQchIds = masterQuantProteinSet.parseQuantProteinSetFromProperties(quantProtSetdata);
            }
            masterQuantProteinSet.setQuantProteinSetByQchIds(quantProteinSetByQchIds);
            masterQuantProteinSet.setProteinSet(dProteinSet);
            ++nbrMqPsSet;
            queryCountPepAndQuantPep.setParameter("rsmId", (Object)masterQuantProteinSet.getQuantResultSummaryId());
            queryCountPepAndQuantPep.setParameter("proteinSetId", (Object)masterQuantProteinSet.getProteinSetId());
            int nbPep = 0;
            int nbPepQuant = 0;
            List resultList = queryCountPepAndQuantPep.getResultList();
            if (!resultList.isEmpty()) {
                Object[] nb = (Object[])resultList.get(0);
                nbPep = (Integer)nb[1];
                nbPepQuant = ((Long)nb[0]).intValue();
            }
            if ((mqPSprop = masterQuantProteinSet.getMasterQuantProtSetProperties()) != null) {
                int nbPepQuantSpecific2ProtSet;
                nbPepQuant = nbPepQuantSpecific2ProtSet = mqPSprop.getSelectedMasterQuantPeptideIds().size();
            }
            if (nbPep == 0) {
                queryCountPep.setParameter("rsmId", (Object)masterQuantProteinSet.getQuantResultSummaryId());
                queryCountPep.setParameter("proteinSetId", (Object)masterQuantProteinSet.getProteinSetId());
                List rl = queryCountPep.getResultList();
                if (!rl.isEmpty()) {
                    nbPep = (Integer)rl.get(0);
                }
            }
            masterQuantProteinSet.setNbPeptides(nbPep);
            masterQuantProteinSet.setNbQuantifiedPeptides(nbPepQuant);
            HashMap<Long, String> quantStatusByQchIds = new HashMap<Long, String>();
            HashMap<Long, Integer> quantPeptideNumberByQchIds = new HashMap<Long, Integer>();
            for (DQuantitationChannel qch : listQC) {
                String status = "Undefined";
                Integer pepNumber = -1;
                quantStatusByQchIds.put(qch.getId(), status);
                quantPeptideNumberByQchIds.put(qch.getId(), pepNumber);
                if (masterQuantProteinSet.getQuantProteinSetByQchIds().containsKey(qch.getId())) {
                    Map protMatchPepNumberByIdPepMatch;
                    Map protMatchStatusByIdPepMatch;
                    DQuantProteinSet protSetQch = (DQuantProteinSet)masterQuantProteinSet.getQuantProteinSetByQchIds().get(qch.getId());
                    Long pmId = protSetQch.getProteinMatchId();
                    if (protMatchStatusByIdByQcId.containsKey(qch.getId()) && (protMatchStatusByIdPepMatch = (Map)protMatchStatusByIdByQcId.get(qch.getId())).containsKey(pmId)) {
                        status = (String)protMatchStatusByIdPepMatch.get(pmId);
                    }
                    if (protMatchPepNumberByIdByQcId.containsKey(qch.getId()) && (protMatchPepNumberByIdPepMatch = (Map)protMatchPepNumberByIdByQcId.get(qch.getId())).containsKey(pmId)) {
                        pepNumber = (Integer)protMatchPepNumberByIdPepMatch.get(pmId);
                    }
                }
                quantStatusByQchIds.put(qch.getId(), status);
                quantPeptideNumberByQchIds.put(qch.getId(), pepNumber);
            }
            masterQuantProteinSet.setQuantStatusByQchIds(quantStatusByQchIds);
            masterQuantProteinSet.setQuantPeptideNumberByQchIds(quantPeptideNumberByQchIds);
            int index = -1;
            for (int k = 0; k < nbMQP; ++k) {
                if (masterQuantProteinSetList.get(k).getProteinSetId() != dProteinSet.getId()) continue;
                index = k;
                break;
            }
            ++nbrMqPsupdated;
            masterQuantProteinSetList.set(index, masterQuantProteinSet);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchPeptideInstanceDataSubTask(boolean xic) {
        SubTask slice = this.m_subTaskManager.getNextSubTask();
        if (slice == null) {
            return true;
        }
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            switch (slice.getSubTaskId()) {
                case 4: {
                    this.fetchPeptideInstanceData(slice, entityManagerMSI, xic);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    private boolean fetchPeptideInstanceData(SubTask subTask, EntityManager entityManagerMSI, boolean xic) throws Exception {
        List sliceOfPeptideIds = subTask.getSubList(this.m_peptideInstanceIds);
        return this.fetchPeptideInstanceData(entityManagerMSI, sliceOfPeptideIds, xic);
    }

    private boolean fetchPeptideIonData(SubTask subTask, EntityManager entityManagerMSI) {
        List sliceOfPeptideIonIds = subTask.getSubList(this.m_masterQuantPeptideIonIds);
        return this.fetchPeptideIonData(entityManagerMSI, sliceOfPeptideIonIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchPeptideIonDataSubTask() {
        SubTask slice = this.m_subTaskManager.getNextSubTask();
        if (slice == null) {
            return true;
        }
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            switch (slice.getSubTaskId()) {
                case 6: {
                    this.fetchPeptideIonData(slice, entityManagerMSI);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataPeptideIonForPeptideMainTask() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            List listMasterQuantitationChannels = this.m_dataset.getMasterQuantitationChannels();
            if (listMasterQuantitationChannels != null && !listMasterQuantitationChannels.isEmpty()) {
                for (DMasterQuantitationChannel masterQuantitationChannel : listMasterQuantitationChannels) {
                    List listIds;
                    Long resultSummaryId = masterQuantitationChannel.getQuantResultSummaryId();
                    if (resultSummaryId == null) continue;
                    String queryPepIon = "SELECT mqpi.id FROM MasterQuantPeptideIon mqpi WHERE mqpi.masterQuantPeptideId=:masterQuantPeptideId AND mqpi.resultSummary.id=:rsmId ORDER BY mqpi.charge ASC";
                    Query peptidesIonQuery = entityManagerMSI.createQuery(queryPepIon);
                    peptidesIonQuery.setParameter("rsmId", (Object)resultSummaryId);
                    peptidesIonQuery.setParameter("masterQuantPeptideId", (Object)(this.m_masterQuantPeptide == null ? -1L : this.m_masterQuantPeptide.getId()));
                    this.m_masterQuantPeptideIonIds = listIds = peptidesIonQuery.getResultList();
                    MasterQuantPeptideProperties property = this.m_masterQuantPeptide.getMasterQuantPeptideProperties();
                    Map seqLevelByIonId = new HashMap();
                    if (property != null && property.getMqPepIonAbundanceSummarizingConfig() != null && property.getMqPepIonAbundanceSummarizingConfig().getMqPeptideIonSelLevelById() != null) {
                        seqLevelByIonId = property.getMqPepIonAbundanceSummarizingConfig().getMqPeptideIonSelLevelById();
                    }
                    for (Long m_masterQuantPeptideIonId : this.m_masterQuantPeptideIonIds) {
                        DMasterQuantPeptideIon mqpi = new DMasterQuantPeptideIon();
                        mqpi.setId(m_masterQuantPeptideIonId.longValue());
                        Integer level = (Integer)seqLevelByIonId.get(mqpi.getId());
                        if (level != null) {
                            mqpi.setUsedInPeptide(level >= 2);
                        }
                        this.m_masterQuantPeptideIonList.add(mqpi);
                    }
                    if (this.m_masterQuantPeptideIonIds.isEmpty()) continue;
                    this.fetchPeptideIonData(entityManagerMSI, this.m_masterQuantPeptideIonIds);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataPeptideIonForAggregatePeptideIonMainTask() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            this.m_masterQuantPeptideIonList.clear();
            String queryPepIon = "SELECT mqpi.serializedProperties FROM MasterQuantPeptideIon mqpi WHERE mqpi.id=:id ";
            TypedQuery peptidesIonQuery = entityManagerMSI.createQuery(queryPepIon, String.class);
            peptidesIonQuery.setParameter("id", (Object)this.m_aggregatedMasterQuantPeptideIon.getId());
            String serializedProperties = (String)peptidesIonQuery.getSingleResult();
            Map serializedPropertiesMap = (Map)JsonSerializer.getMapper().readValue(serializedProperties, Map.class);
            Map aggMasterQuantPeptideIonMap = (Map)serializedPropertiesMap.get("aggregated_master_quant_peptide_ion_id_map");
            HashSet<Long> masterQuantPeptideIonIds = new HashSet<Long>();
            for (String quantChannelIdString : aggMasterQuantPeptideIonMap.keySet()) {
                ArrayList parentMasterQuantIdList = (ArrayList)aggMasterQuantPeptideIonMap.get(quantChannelIdString);
                Iterator iterator = parentMasterQuantIdList.iterator();
                while (iterator.hasNext()) {
                    Integer id = (Integer)iterator.next();
                    masterQuantPeptideIonIds.add(id.longValue());
                }
            }
            this.m_masterQuantPeptideIonIds = new ArrayList<Long>(masterQuantPeptideIonIds);
            MasterQuantPeptideProperties property = this.m_masterQuantPeptide.getMasterQuantPeptideProperties();
            Map seqLevelByIonId = new HashMap();
            if (property != null && property.getMqPepIonAbundanceSummarizingConfig() != null && property.getMqPepIonAbundanceSummarizingConfig().getMqPeptideIonSelLevelById() != null) {
                seqLevelByIonId = property.getMqPepIonAbundanceSummarizingConfig().getMqPeptideIonSelLevelById();
            }
            for (Long l : this.m_masterQuantPeptideIonIds) {
                DMasterQuantPeptideIon mqpi = new DMasterQuantPeptideIon();
                mqpi.setId(l.longValue());
                Integer level = (Integer)seqLevelByIonId.get(mqpi.getId());
                if (level != null) {
                    mqpi.setUsedInPeptide(level >= 2);
                }
                this.m_masterQuantPeptideIonList.add(mqpi);
            }
            if (!this.m_masterQuantPeptideIonIds.isEmpty()) {
                this.fetchPeptideIonData(entityManagerMSI, this.m_masterQuantPeptideIonIds);
            }
            HashSet<Long> channelIdsToLoad = new HashSet<Long>();
            for (DMasterQuantPeptideIon masterQuandPeptideIon : this.m_masterQuantPeptideIonList) {
                Set channelIds = masterQuandPeptideIon.getQuantPeptideIonByQchIds().keySet();
                for (Long channelId : channelIds) {
                    if (this.m_quantitationChannelsMap.containsKey(channelId)) continue;
                    channelIdsToLoad.add(channelId);
                }
            }
            if (!channelIdsToLoad.isEmpty()) {
                this.m_taskError = DatabaseLoadXicMasterQuantTask.fetchDataQuantChannels(channelIdsToLoad, this.m_quantitationChannelsMap);
            }
            if (!this.m_childrenDatasetIds.isEmpty()) {
                ArrayList<DDataset> arrayList = new ArrayList<DDataset>();
                this.m_taskError = DatabaseLoadXicMasterQuantTask.fetchDataset(this.m_projectId, this.m_childrenDatasetIds, arrayList);
                for (DMasterQuantPeptideIon masterQuandPeptideIon : this.m_masterQuantPeptideIonList) {
                    Long rsmId = masterQuandPeptideIon.getResultSummary().getId();
                    for (DDataset d : arrayList) {
                        if (d.getResultSummaryId().longValue() != rsmId.longValue()) continue;
                        masterQuandPeptideIon.getResultSummary().getTransientData(null).setDDataset(d);
                    }
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    private boolean fetchPeptideIonData(EntityManager entityManagerMSI, List<Long> listMasterPeptideIonsIds) {
        int nbM = this.m_masterQuantPeptideIonList.size();
        int nbMsub = listMasterPeptideIonsIds == null ? 0 : listMasterPeptideIonsIds.size();
        long start = System.currentTimeMillis();
        String queryMasterPeptideIons = "SELECT new fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon(pi, mqpi, p, pm) FROM fr.proline.core.orm.msi.PeptideInstance pi, fr.proline.core.orm.msi.MasterQuantPeptideIon mqpi, fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.PeptideMatch pm WHERE mqpi.id IN (:listId) AND pi.id = mqpi.peptideInstance.id AND  mqpi.peptideId=p.id AND mqpi.bestPeptideMatchId = pm.id";
        TypedQuery queryMasterIons = entityManagerMSI.createQuery(queryMasterPeptideIons, DMasterQuantPeptideIon.class);
        queryMasterIons.setParameter("listId", listMasterPeptideIonsIds);
        List resultListIons = new ArrayList();
        if (listMasterPeptideIonsIds != null && !listMasterPeptideIonsIds.isEmpty()) {
            resultListIons = queryMasterIons.getResultList();
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Long> listObjectTreeId = new ArrayList<Long>();
        ArrayList<Long> peptideInstanceIds = new ArrayList<Long>(resultListIons.size());
        HashMap<Long, DPeptideInstance> peptideInstanceMap = new HashMap<Long, DPeptideInstance>();
        for (DMasterQuantPeptideIon mQuantPeptideIon : resultListIons) {
            boolean i = false;
            DPeptideInstance pi = mQuantPeptideIon.getPeptideInstance();
            peptideInstanceIds.add(pi.getId());
            Long keyPi = pi.getId();
            if (peptideInstanceMap.containsKey(keyPi)) {
                pi = (DPeptideInstance)peptideInstanceMap.get(keyPi);
                mQuantPeptideIon.setPeptideInstance(pi);
            } else {
                peptideInstanceMap.put(keyPi, pi);
            }
            listObjectTreeId.add(mQuantPeptideIon.getMasterQuantComponent().getObjectTreeId());
            int index = -1;
            for (int k = 0; k < nbM; ++k) {
                if (this.m_masterQuantPeptideIonList.get(k).getId() != mQuantPeptideIon.getId()) continue;
                index = k;
                break;
            }
            if (this.m_masterQuantPeptideIonList.get(index).isUsedInPeptide() != null) {
                mQuantPeptideIon.setUsedInPeptide(this.m_masterQuantPeptideIonList.get(index).isUsedInPeptide().booleanValue());
            }
            this.m_masterQuantPeptideIonList.set(index, mQuantPeptideIon);
            indexes.add(index);
        }
        m_logger.info("DMQPep ions for " + nbMsub + " ions duration = " + (System.currentTimeMillis() - start) + " ms");
        start = System.currentTimeMillis();
        HashMap<Long, Peptide> peptideMap = new HashMap<Long, Peptide>();
        String querySelect = "SELECT  pi.id, pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.serializedProperties FROM fr.proline.core.orm.msi.PeptideInstance pi,  fr.proline.core.orm.msi.PeptideMatch pm WHERE pi.id IN (:listId) AND  pi.bestPeptideMatchId=pm.id ORDER BY pm.score DESC";
        HashMap<Long, DPeptideMatch> peptideMatchMap = new HashMap<Long, DPeptideMatch>();
        Query query = entityManagerMSI.createQuery(querySelect);
        query.setParameter("listId", peptideInstanceIds);
        List resultList = query.getResultList();
        for (Object[] resCur : resultList) {
            Long piId = (Long)resCur[0];
            DPeptideInstance dpi = (DPeptideInstance)peptideInstanceMap.get(piId);
            Long pmId = (Long)resCur[1];
            DPeptideMatch pm = (DPeptideMatch)peptideMatchMap.get(pmId);
            if (pm == null) {
                Integer pmRank = (Integer)resCur[2];
                Integer pmCharge = (Integer)resCur[3];
                Float pmDeltaMoz = (Float)resCur[4];
                Double pmExperimentalMoz = (Double)resCur[5];
                Integer pmMissedCleavage = (Integer)resCur[6];
                Float pmScore = (Float)resCur[7];
                Long pmResultSetId = (Long)resCur[8];
                Integer pmCdPrettyRank = (Integer)resCur[9];
                Integer pmSdPrettyRank = (Integer)resCur[10];
                String pmSerializedProp = (String)resCur[11];
                pm = new DPeptideMatch(pmId.longValue(), pmRank, pmCharge.intValue(), pmDeltaMoz, pmExperimentalMoz.doubleValue(), pmMissedCleavage.intValue(), pmScore, pmResultSetId.longValue(), pmCdPrettyRank, pmSdPrettyRank, pmSerializedProp);
                peptideMatchMap.put(pmId, pm);
            }
            Peptide p = dpi.getPeptide();
            p.getTransientData().setPeptideReadablePtmStringLoaded();
            peptideMap.put(p.getId(), p);
            dpi.setBestPeptideMatch(pm);
            pm.setPeptide(p);
        }
        DatabasePTMSitesTask.fetchReadablePTMData(entityManagerMSI, this.m_dataset.getResultSetId(), peptideMap, null);
        DatabasePTMSitesTask.fetchPTMDataForPeptides(entityManagerMSI, peptideMap, null);
        ArrayList peptideMatchIds = new ArrayList(peptideMatchMap.size());
        peptideMatchIds.addAll(peptideMatchMap.keySet());
        DatabaseLoadXicMasterQuantTask.fetchProteinSetName(entityManagerMSI, peptideMatchIds, peptideMatchMap);
        this.fetchPeptideIonAbundances(listObjectTreeId, entityManagerMSI, indexes);
        indexes = new ArrayList();
        listObjectTreeId = new ArrayList();
        String queryPeptideIonWithoutPeptide = "SELECT new fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon(mqpi) FROM  fr.proline.core.orm.msi.MasterQuantPeptideIon mqpi WHERE mqpi.id IN (:listId) AND mqpi.peptideInstance is NULL  ORDER BY mqpi.id ASC";
        TypedQuery queryMasterIons2 = entityManagerMSI.createQuery(queryPeptideIonWithoutPeptide, DMasterQuantPeptideIon.class);
        queryMasterIons2.setParameter("listId", listMasterPeptideIonsIds);
        List resultListIons2 = new ArrayList();
        if (listMasterPeptideIonsIds != null && !listMasterPeptideIonsIds.isEmpty()) {
            resultListIons2 = queryMasterIons2.getResultList();
        }
        for (DMasterQuantPeptideIon mQuantPeptideIon : resultListIons2) {
            listObjectTreeId.add(mQuantPeptideIon.getMasterQuantComponent().getObjectTreeId());
            int index = -1;
            for (int k = 0; k < nbM; ++k) {
                if (this.m_masterQuantPeptideIonList.get(k).getId() != mQuantPeptideIon.getId()) continue;
                index = k;
                break;
            }
            this.m_masterQuantPeptideIonList.set(index, mQuantPeptideIon);
            indexes.add(index);
        }
        this.fetchPeptideIonAbundances(listObjectTreeId, entityManagerMSI, indexes);
        m_logger.info("Fetch ions pepInstance, pepMatch & Ab. for " + nbMsub + " ions duration = " + (System.currentTimeMillis() - start) + " ms");
        start = System.currentTimeMillis();
        return true;
    }

    private void fetchPeptideIonAbundances(List<Long> listObjectTreeId, EntityManager entityManagerMSI, List<Integer> indexes) {
        List listOt = new ArrayList();
        if (listObjectTreeId.size() > 0) {
            String otQuery = "SELECT ot FROM fr.proline.core.orm.msi.ObjectTree ot WHERE id IN (:listId) ";
            TypedQuery queryObjectTree = entityManagerMSI.createQuery(otQuery, ObjectTree.class);
            queryObjectTree.setParameter("listId", listObjectTreeId);
            listOt = queryObjectTree.getResultList();
        }
        for (Integer index : indexes) {
            DMasterQuantPeptideIon mQuantPeptideIon = this.m_masterQuantPeptideIonList.get(index);
            String quantPeptideIonData = "";
            ObjectTree oti = null;
            for (ObjectTree objectTree : listOt) {
                if (objectTree.getId() != mQuantPeptideIon.getMasterQuantComponent().getObjectTreeId()) continue;
                oti = objectTree;
                break;
            }
            if (oti != null) {
                quantPeptideIonData = oti.getClobData();
            }
            Map quantPeptideIonByQchIds = null;
            if (quantPeptideIonData != null && !quantPeptideIonData.isEmpty()) {
                quantPeptideIonByQchIds = mQuantPeptideIon.parseQuantPeptideIonFromProperties(quantPeptideIonData);
            }
            mQuantPeptideIon.setQuantPeptideIonByQchIds(quantPeptideIonByQchIds);
            this.m_masterQuantPeptideIonList.set(index, mQuantPeptideIon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchDataPSMForPeptideMainTask() {
        try (EntityManager entityManagerMSI = DStoreCustomPoolConnectorFactory.getInstance().getMsiDbConnector(this.m_projectId.longValue()).createEntityManager();){
            entityManagerMSI.getTransaction().begin();
            List listMasterQuantitationChannels = this.m_dataset.getMasterQuantitationChannels();
            this.m_peptideMatchIds = new ArrayList();
            this.m_peptideMatchMap = new HashMap();
            this.m_peptideMatchSequenceMatchArrayMap = new HashMap();
            if (listMasterQuantitationChannels != null && !listMasterQuantitationChannels.isEmpty()) {
                for (DMasterQuantitationChannel masterQuantitationChannel : listMasterQuantitationChannels) {
                    List listQuantChannels = masterQuantitationChannel.getQuantitationChannels();
                    for (DQuantitationChannel quantChannel : listQuantChannels) {
                        Long qcId = quantChannel.getId();
                        Long identRsmId = quantChannel.getIdentResultSummaryId();
                        Long peptideId = this.m_masterQuantPeptideForPSM.getPeptideInstance().getPeptideId();
                        Long peptideInstanceIdRSM = null;
                        String qPepInst = "SELECT pi.id FROM fr.proline.core.orm.msi.PeptideInstance pi WHERE pi.resultSummary.id =:rsmId AND pi.peptide.id =:peptideId ";
                        Query queryPepInst = entityManagerMSI.createQuery(qPepInst);
                        queryPepInst.setParameter("rsmId", (Object)identRsmId);
                        queryPepInst.setParameter("peptideId", (Object)peptideId);
                        List resultList = queryPepInst.getResultList();
                        for (Object o : resultList) {
                            peptideInstanceIdRSM = (Long)o;
                        }
                        String query = "SELECT  new fr.proline.core.orm.msi.dto.DPeptideMatch(pm.id, pm.rank, pm.charge, pm.deltaMoz, pm.experimentalMoz, pm.missedCleavage, pm.score, pm.resultSet.id, pm.cdPrettyRank, pm.sdPrettyRank, pm.serializedProperties) FROM  fr.proline.core.orm.msi.PeptideMatch pm, fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pipm , fr.proline.core.orm.msi.Peptide p WHERE pipm.resultSummary.id=:rsmId AND pipm.id.peptideMatchId=pm.id AND pm.peptideId=p.id AND pipm.id.peptideInstanceId=:peptideInstanceId ORDER BY pm.msQuery.initialId ASC, p.sequence ASC ";
                        TypedQuery queryPM = entityManagerMSI.createQuery(query, DPeptideMatch.class);
                        queryPM.setParameter("peptideInstanceId", (Object)peptideInstanceIdRSM);
                        queryPM.setParameter("rsmId", (Object)identRsmId);
                        List rList = queryPM.getResultList();
                        this.m_peptideMatchList.addAll(rList);
                        ArrayList<Long> listPeptideMatchIds = new ArrayList<Long>();
                        int nb = rList.size();
                        for (DPeptideMatch psm : rList) {
                            Long pmId = psm.getId();
                            listPeptideMatchIds.add(psm.getId());
                            this.m_peptideMatchIds.add(pmId);
                            this.m_peptideMatchMap.put(pmId, psm);
                            ArrayList<Object> sequenceMatchArray = this.m_peptideMatchSequenceMatchArrayMap.get(pmId);
                            if (sequenceMatchArray == null) {
                                sequenceMatchArray = new ArrayList();
                                this.m_peptideMatchSequenceMatchArrayMap.put(pmId, sequenceMatchArray);
                            }
                            sequenceMatchArray.add(psm);
                        }
                        this.m_psmIdPerQC.put(qcId, listPeptideMatchIds);
                    }
                }
                int nb = this.m_peptideMatchList.size();
                if (nb > 0) {
                    SubTask subTask = this.m_subTaskManager.sliceATaskAndGetFirst(7, this.m_peptideMatchList.size(), 1000);
                    this.fetchPeptide(entityManagerMSI, subTask);
                    subTask = this.m_subTaskManager.sliceATaskAndGetFirst(8, this.m_peptideMatchList.size(), 1000);
                    this.fetchMsQuery(entityManagerMSI, subTask);
                    subTask = this.m_subTaskManager.sliceATaskAndGetFirst(9, this.m_peptideMatchList.size(), 1000);
                    this.fetchProteinSetName(entityManagerMSI, subTask);
                }
            }
            entityManagerMSI.getTransaction().commit();
        }
        this.m_defaultPriority = AbstractDatabaseTask.Priority.LOW;
        this.m_currentPriority = AbstractDatabaseTask.Priority.LOW;
        return true;
    }

    private void fetchPeptide(EntityManager entityManagerMSI, SubTask subTask) {
        List sliceOfPeptideMatchIds = subTask.getSubList(this.m_peptideMatchIds);
        HashMap<Long, Peptide> peptideMap = new HashMap<Long, Peptide>();
        Query peptideQuery = entityManagerMSI.createQuery("SELECT pm.id, p FROM PeptideMatch pm, fr.proline.core.orm.msi.Peptide p WHERE pm.id IN (:listId) AND pm.peptideId=p.id");
        peptideQuery.setParameter("listId", (Object)sliceOfPeptideMatchIds);
        List peptides = peptideQuery.getResultList();
        for (Object[] res : peptides) {
            Long peptideMatchId = (Long)res[0];
            Peptide peptide = (Peptide)res[1];
            peptide.getTransientData().setPeptideReadablePtmStringLoaded();
            this.m_peptideMatchMap.get(peptideMatchId).setPeptide(peptide);
            peptideMap.put(peptide.getId(), peptide);
        }
        String query = "SELECT p.id, ptmString FROM fr.proline.core.orm.msi.Peptide p, fr.proline.core.orm.msi.PeptideReadablePtmString ptmString, fr.proline.core.orm.msi.PeptideMatch pm WHERE  pm.id IN (:listId) AND pm.peptideId=p.id AND ptmString.peptide=p AND ptmString.resultSet.id=pm.resultSet.id ";
        Query ptmStingQuery = entityManagerMSI.createQuery(query);
        ptmStingQuery.setParameter("listId", (Object)sliceOfPeptideMatchIds);
        List ptmStrings = ptmStingQuery.getResultList();
        for (Object[] res : ptmStrings) {
            Long peptideId = (Long)res[0];
            PeptideReadablePtmString ptmString = (PeptideReadablePtmString)res[1];
            Peptide peptide = (Peptide)peptideMap.get(peptideId);
            peptide.getTransientData().setPeptideReadablePtmString(ptmString);
        }
    }

    private void fetchMsQuery(EntityManager entityManagerMSI, SubTask subTask) {
        List sliceOfPeptideMatchIds = subTask.getSubList(this.m_peptideMatchIds);
        String query = "SELECT pm.id, msq.id, msq.initialId, s.precursorIntensity, s.firstTime FROM PeptideMatch pm,MsQuery msq, Spectrum s WHERE pm.id IN (:listId) AND pm.msQuery=msq AND msq.spectrum=s";
        Query msQueryQuery = entityManagerMSI.createQuery(query);
        msQueryQuery.setParameter("listId", (Object)sliceOfPeptideMatchIds);
        List msQueries = msQueryQuery.getResultList();
        for (Object[] o : msQueries) {
            int i = 0;
            long pmId = (Long)o[i++];
            long msqId = (Long)o[i++];
            int msqInitialId = (Integer)o[i++];
            Float precursorIntensity = (Float)o[i++];
            Float retentionTime = (Float)o[i++];
            DMsQuery q = new DMsQuery(pmId, msqId, msqInitialId, precursorIntensity);
            DPeptideMatch peptideMatch = this.m_peptideMatchMap.get(q.getPeptideMatchId());
            peptideMatch.setMsQuery(q);
            peptideMatch.setRetentionTime(retentionTime);
        }
    }

    private void fetchProteinSetName(EntityManager entityManagerMSI, SubTask subTask) {
        List sliceOfPeptideMatchIds = subTask.getSubList(this.m_peptideMatchIds);
        DatabaseLoadXicMasterQuantTask.fetchProteinSetName(entityManagerMSI, sliceOfPeptideMatchIds, this.m_peptideMatchMap);
    }

    public static void fetchProteinSetName(EntityManager entityManagerMSI, List sliceOfPeptideMatchIds, HashMap<Long, DPeptideMatch> peptideMatchMap) {
        String query = "SELECT typpm.accession, pepm.id FROM fr.proline.core.orm.msi.PeptideMatch pepm, fr.proline.core.orm.msi.PeptideInstance pepi, fr.proline.core.orm.msi.PeptideInstancePeptideMatchMap pi_pm, fr.proline.core.orm.msi.ProteinSet prots, fr.proline.core.orm.msi.PeptideSetPeptideInstanceItem ps_pi, fr.proline.core.orm.msi.PeptideSet peps, fr.proline.core.orm.msi.ProteinMatch typpm WHERE pepm.id IN (:listId) AND pi_pm.peptideMatch=pepm AND pi_pm.peptideInstance=pepi AND ps_pi.peptideInstance=pepi AND ps_pi.peptideSet=peps AND peps.proteinSet=prots AND prots.representativeProteinMatchId = typpm.id AND prots.isValidated=true ORDER BY pepm.id ASC, typpm.accession ASC";
        Query proteinSetQuery = entityManagerMSI.createQuery(query);
        proteinSetQuery.setParameter("listId", (Object)sliceOfPeptideMatchIds);
        ArrayList<String> proteinSetNameArray = new ArrayList<String>();
        long prevPeptideMatchId = -1L;
        List msQueries = proteinSetQuery.getResultList();
        for (Object[] resCur : msQueries) {
            String proteinName = (String)resCur[0];
            Long peptideMatchId = (Long)resCur[1];
            if (peptideMatchId != prevPeptideMatchId) {
                if (prevPeptideMatchId != -1L) {
                    DPeptideMatch prevPeptideMatch = peptideMatchMap.get(prevPeptideMatchId);
                    String[] proteinSetNames = proteinSetNameArray.toArray(new String[proteinSetNameArray.size()]);
                    prevPeptideMatch.setProteinSetStringArray(proteinSetNames);
                    proteinSetNameArray.clear();
                    proteinSetNameArray.add(proteinName);
                } else {
                    proteinSetNameArray.add(proteinName);
                }
            } else {
                proteinSetNameArray.add(proteinName);
            }
            prevPeptideMatchId = peptideMatchId;
        }
        if (prevPeptideMatchId != -1L) {
            DPeptideMatch prevPeptideMatch = peptideMatchMap.get(prevPeptideMatchId);
            String[] proteinSetNames = proteinSetNameArray.toArray(new String[proteinSetNameArray.size()]);
            prevPeptideMatch.setProteinSetStringArray(proteinSetNames);
        }
        for (Long peptideMatchId : sliceOfPeptideMatchIds) {
            DPeptideMatch peptideMatch = peptideMatchMap.get(peptideMatchId);
            if (peptideMatch.getProteinSetStringArray() != null) continue;
            String[] proteinSetNames = new String[]{};
            peptideMatch.setProteinSetStringArray(proteinSetNames);
        }
    }

    private String getMasterQuantProteinSetName(DMasterQuantProteinSet masterQuantProteinSet) {
        DProteinMatch proteinMatch;
        String name = null;
        if (masterQuantProteinSet.getProteinSet() != null && (proteinMatch = masterQuantProteinSet.getProteinSet().getTypicalProteinMatch()) != null) {
            name = proteinMatch.getAccession();
        }
        if (name == null) {
            name = String.valueOf(masterQuantProteinSet.getId());
        }
        return name;
    }

    private static /* synthetic */ String lambda$fetchDataQuantChannels$2(StackTraceElement es) {
        return es.toString();
    }

    private static /* synthetic */ String lambda$fetchDataset$1(StackTraceElement es) {
        return es.toString();
    }
}

