/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.python.data;

import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.python.data.Col;
import fr.proline.studio.python.data.ColDoubleData;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.util.Conversion;
import fr.proline.studio.table.LazyData;
import java.util.ArrayList;
import org.python.core.Py;

public class ColRef
extends Col {
    private final int m_modelCol;
    private final GlobalTableModelInterface m_tableModel;

    public ColRef(Table table, int col, CompoundTableModel model) {
        super(table);
        this.m_modelCol = col;
        this.m_tableModel = model.getLastNonFilterModel();
    }

    public ColRef(Table table, int col, GlobalTableModelInterface model) {
        super(table);
        this.m_modelCol = col;
        this.m_tableModel = model;
    }

    public int getModelCol() {
        return this.m_modelCol;
    }

    @Override
    public Col mutable() {
        int nb = this.__len__();
        ArrayList<Double> resultArray = new ArrayList<Double>(nb);
        for (int i = 0; i < nb; ++i) {
            Number v = Conversion.convertToJavaNumber(this.getValueAt(i));
            if (v == null) {
                resultArray.add(null);
                continue;
            }
            resultArray.add(v.doubleValue());
        }
        return new ColDoubleData(this.m_table, resultArray, this.getColumnName());
    }

    @Override
    public Object getValueAt(int row) {
        Object o = this.m_tableModel.getValueAt(row, this.m_modelCol);
        if (o instanceof LazyData) {
            o = ((LazyData)o).getData();
        }
        return o;
    }

    @Override
    public int getRowCount() {
        return this.m_tableModel.getRowCount();
    }

    @Override
    public void setValuetAt(int row, Object o) {
        throw Py.TypeError((String)"Tried to modify constant col");
    }

    @Override
    public String getColumnName() {
        if (this.m_columnName == null || this.m_columnName.isEmpty()) {
            return this.m_tableModel.getColumnName(this.m_modelCol);
        }
        return this.m_columnName;
    }

    @Override
    public String getExportColumnName() {
        if (this.m_columnName == null || this.m_columnName.isEmpty()) {
            return this.m_tableModel.getExportColumnName(this.m_modelCol);
        }
        return this.m_columnName;
    }

    @Override
    public Class getColumnClass() {
        return this.m_tableModel.getColumnClass(this.m_modelCol);
    }
}

