/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rserver;

import fr.proline.studio.python.math.StatsUtil;
import fr.proline.studio.utils.StudioExceptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.openide.util.NbPreferences;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RFileInputStream;
import org.rosuda.REngine.Rserve.RFileOutputStream;
import org.rosuda.REngine.Rserve.RserveException;
import org.slf4j.LoggerFactory;

public class RServerManager {
    private static RServerManager m_rServerManager = null;
    private RConnection m_connection = null;
    private String m_host = null;
    private int m_port = -1;
    private int m_currentVarIndex = 0;
    private Process m_RProcess = null;

    private RServerManager() {
    }

    public static synchronized RServerManager getRServerManager() {
        if (m_rServerManager == null) {
            m_rServerManager = new RServerManager();
        }
        return m_rServerManager;
    }

    public synchronized boolean startRProcessWithRetry() throws Exception {
        LoggerFactory.getLogger((String)"ProlineStudio.R").info("startRProcessWithRetry()");
        boolean RStarted = false;
        try {
            RStarted = this.startRProcess();
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"ProlineStudio.R").error("Unexpected Exception while Starting R Server ", (Throwable)e);
        }
        if (!RStarted) {
            LoggerFactory.getLogger((String)"ProlineStudio.R").info("startRProcessWithRetry() : Retry");
            RStarted = this.startRProcess();
        }
        if (RStarted) {
            try {
                LoggerFactory.getLogger((String)"ProlineStudio.R").info("startRProcessWithRetry() : Connect");
                this.connect(false);
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)"ProlineStudio.R").error("Unexpected Exception while connecting to R Server ", (Throwable)e);
            }
        }
        if (RStarted && !this.isConnected()) {
            LoggerFactory.getLogger((String)"ProlineStudio.R").info("startRProcessWithRetry() : R has started, but we can not connect correctly");
            this.stopRProcess();
            Thread.sleep(5000L);
            RStarted = this.startRProcess();
            Thread.sleep(2000L);
            this.connect(true);
        }
        return RStarted;
    }

    private boolean startRProcess() throws Exception {
        String operatingSystem;
        if (this.m_RProcess != null) {
            LoggerFactory.getLogger((String)"ProlineStudio.R").info("startRProcess() : Process already exists");
            return true;
        }
        if (this.isConnected()) {
            LoggerFactory.getLogger((String)"ProlineStudio.R").info("startRProcess() : Process created outside");
            return true;
        }
        try {
            LoggerFactory.getLogger((String)"ProlineStudio.R").info("startRProcess() : try to connect");
            this.connect(false);
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"ProlineStudio.R").error("Unexpected Exception 2 while connecting to R Server ", (Throwable)e);
        }
        if (this.isConnected()) {
            LoggerFactory.getLogger((String)"ProlineStudio.R").info("startRProcess() : Process Connected");
            return true;
        }
        File f = null;
        LoggerFactory.getLogger((String)"ProlineStudio.R").info("startRProcess() : Try to find R.exe if the path is defined in the RServerExePath key of the preference file");
        Preferences preferences = NbPreferences.root();
        String pathToExe = preferences.get("RServerExePath", null);
        if (pathToExe != null) {
            f = new File(pathToExe);
            if (!f.exists()) {
                LoggerFactory.getLogger((String)"ProlineStudio.R").error("R.exe is defined in Preferences file but has not been found: " + pathToExe);
                f = null;
            }
        } else {
            LoggerFactory.getLogger((String)"ProlineStudio.R").info("R.exe not defined in Preferences file. Key is : RServerExePath");
        }
        if (f == null) {
            LoggerFactory.getLogger((String)"ProlineStudio.R").info("startRProcess() : Try to find R.exe in the path");
            f = new File(".");
            pathToExe = f.getCanonicalPath() + File.separatorChar + "R" + File.separatorChar + "bin" + File.separatorChar + "R.exe";
            f = new File(pathToExe);
            if (!f.exists()) {
                LoggerFactory.getLogger((String)"ProlineStudio.R").error("R.exe not found: " + pathToExe);
                StudioExceptions.notify((String)"R.exe not found", (Throwable)new FileNotFoundException(pathToExe));
                return false;
            }
        }
        if ((operatingSystem = System.getProperty("os.name")) != null && operatingSystem.startsWith("Windows")) {
            LoggerFactory.getLogger((String)"ProlineStudio.R").info("startRProcess() : Windows system, start R.exe");
            String[] cmds = new String[]{pathToExe, "-e", "\"library(Rserve);Rserve(TRUE,args='--no-save')\"", "--no-save"};
            this.m_RProcess = Runtime.getRuntime().exec(cmds);
            InOutThread errorStreamThread = new InOutThread(this.m_RProcess.getErrorStream(), null);
            InOutThread outputStreamThread = new InOutThread(this.m_RProcess.getInputStream(), null);
            errorStreamThread.start();
            outputStreamThread.start();
            return true;
        }
        LoggerFactory.getLogger((String)"ProlineStudio.R").error("R Server not available for Linux or MacIntosh");
        StudioExceptions.notify((String)"R Server not available for Linux or MacIntosh", (Throwable)new FileNotFoundException());
        return false;
    }

    public void stopRProcess() {
        if (this.m_connection != null) {
            try {
                LoggerFactory.getLogger((String)"ProlineStudio.R").info("stopRProcess() : Quit R");
                this.parseAndEval("quit()");
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)"ProlineStudio.R").error("Unexpected Exception while quitting R Server Process ", (Throwable)e);
            }
        }
        LoggerFactory.getLogger((String)"ProlineStudio.R").info("stopRProcess() : Close R Connection");
        this.close();
        if (this.m_RProcess != null) {
            try {
                LoggerFactory.getLogger((String)"ProlineStudio.R").info("stopRProcess() : Destroy R Process");
                this.m_RProcess.destroy();
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)"ProlineStudio.R").error("Unexpected Exception while destroying R Server Process ", (Throwable)e);
            }
            finally {
                this.m_RProcess = null;
            }
        }
    }

    public void connect() throws RServerException {
        this.connect(true);
    }

    public void connect(boolean log) throws RServerException {
        String serverURL = "localhost";
        Preferences preferences = NbPreferences.root();
        int port = preferences.getInt("RServerPort", 6311);
        String user = null;
        String password = null;
        LoggerFactory.getLogger((String)"ProlineStudio.R").info("connect() : Connect to R Process");
        this.connect(serverURL, port, user, password, log);
        if (this.isConnected()) {
            LoggerFactory.getLogger((String)"ProlineStudio.R").info("connect() : Connection done, loading ProlineStudioInit.R");
            try {
                File f = new File(".");
                String pathToInitRFile = f.getCanonicalPath() + File.separatorChar + "R" + File.separatorChar + "ProlineStudioInit.R";
                f = new File(pathToInitRFile);
                if (f.exists()) {
                    this.m_connection.voidEval("source('" + StatsUtil.getPath(f) + "')");
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)"ProlineStudio.R").error("Loading ProlineStudioInit.R failed", (Throwable)e);
                throw new RServerException(e.getMessage());
            }
        }
    }

    public RConnection connect(String host, int port) throws RServerException {
        return this.connect(host, port, null, null, true);
    }

    public RConnection connect(String host, int port, String user, String password, boolean log) throws RServerException {
        if (this.m_connection != null) {
            LoggerFactory.getLogger((String)"ProlineStudio.R").info("connect() : Already Connected");
            return this.m_connection;
        }
        this.m_host = host;
        this.m_port = port;
        try {
            this.m_connection = new RConnection(this.m_host, this.m_port);
            if (user != null) {
                this.m_connection.login(user, password);
            }
            return this.m_connection;
        }
        catch (RserveException e) {
            if (log) {
                LoggerFactory.getLogger((String)"ProlineStudio.R").error("connect() failed", (Throwable)e);
                StudioExceptions.notify((String)e.getMessage(), (Throwable)e);
            } else {
                LoggerFactory.getLogger((String)"ProlineStudio.R").info("connect() , no existing R Server found to connect");
            }
            this.m_connection = null;
            throw new RServerException(e.getMessage());
        }
    }

    public void close() {
        if (this.m_connection == null) {
            return;
        }
        this.m_connection.close();
        this.m_connection = null;
    }

    public RConnection getConnection() {
        return this.m_connection;
    }

    public boolean isConnected() {
        return this.m_connection != null;
    }

    public String getNewVariableName(String varBase) {
        ++this.m_currentVarIndex;
        return varBase + String.valueOf(this.m_currentVarIndex);
    }

    public void uploadFile(String userPathSrc, String serverFileName) throws RServerException {
        RFileOutputStream fout = null;
        FileInputStream input = null;
        try {
            int bytesRead;
            fout = this.m_connection.createFile(serverFileName);
            input = new FileInputStream(userPathSrc);
            byte[] buffer = new byte[256];
            while ((bytesRead = input.read(buffer)) != -1) {
                fout.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"ProlineStudio.Commons").error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            throw new RServerException(e.getMessage());
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void downloadFile(String serverFileName, String userPathDestination) throws RServerException {
        RFileInputStream fin = null;
        FileOutputStream output = null;
        try {
            int bytesRead;
            fin = this.m_connection.openFile(serverFileName);
            output = new FileOutputStream(userPathDestination);
            byte[] buffer = new byte[256];
            while ((bytesRead = fin.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"ProlineStudio.Commons").error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            throw new RServerException(e.getMessage());
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void deleteFile(String fileNameDestination) throws RServerException {
        try {
            this.m_connection.removeFile(fileNameDestination);
        }
        catch (RserveException e) {
            LoggerFactory.getLogger((String)"ProlineStudio.Commons").error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            throw new RServerException(e.getMessage());
        }
    }

    public String getPwd() throws RServerException {
        try {
            return this.m_connection.eval("getwd()").asString();
        }
        catch (REXPMismatchException | REngineException e) {
            LoggerFactory.getLogger((String)"ProlineStudio.Commons").error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            throw new RServerException(e.getMessage());
        }
    }

    public REXP parseAndEval(String code) throws RServerException {
        try {
            REXP result = this.m_connection.parseAndEval("try(" + code + ",silent=TRUE)");
            if (result.inherits("try-error")) {
                RServerException e = new RServerException(result.asString());
                throw e;
            }
            return result;
        }
        catch (REXPMismatchException | REngineException e) {
            LoggerFactory.getLogger((String)"ProlineStudio.Commons").error(this.getClass().getSimpleName() + " failed", (Throwable)e);
            throw new RServerException(e.getMessage());
        }
    }

    public boolean isRStarted() {
        return this.m_RProcess != null;
    }

    public void checkRAvailability(final RAvailableInterface client) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean success = false;
                try {
                    success = RServerManager.this.startRProcessWithRetry();
                }
                catch (Exception e) {
                    LoggerFactory.getLogger((String)"ProlineStudio.R").error("Unexpected Exception while starting R Process with retry ", (Throwable)e);
                }
                final boolean _success = success;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        client.available(_success);
                    }
                });
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public static interface RAvailableInterface {
        public void available(boolean var1);
    }

    private static class InOutThread
    extends Thread {
        private InputStream m_is;
        private OutputStream m_os;

        InOutThread(InputStream is) {
            this(is, null);
        }

        InOutThread(InputStream is, OutputStream redirect) {
            this.m_is = is;
            this.m_os = redirect;
        }

        @Override
        public void run() {
            try {
                String line;
                PrintWriter pw = null;
                if (this.m_os != null) {
                    pw = new PrintWriter(this.m_os);
                }
                InputStreamReader isr = new InputStreamReader(this.m_is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    if (pw == null) continue;
                    pw.println(line);
                }
                if (pw != null) {
                    pw.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class RServerException
    extends Exception {
        public RServerException(String message) {
            super(message);
        }
    }
}

