/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import fr.proline.core.orm.uds.ExternalDb;
import fr.proline.repository.ConnectionMode;
import fr.proline.repository.DriverType;
import fr.proline.repository.ProlineDatabaseType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBProlineConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DBProlineConfig.class);
    private static final Object CONFIGURATION_LOCK = new Object();
    private static DBProlineConfig instance;
    private Config m_dbProlineConfig = ConfigFactory.load((String)"application");
    private ExternalDb m_udsExternalDB = null;
    private Integer m_maxPoolConnection = null;
    private String auth_user = null;
    private String auth_password = null;

    private DBProlineConfig() {
    }

    public static DBProlineConfig getInstance() {
        if (instance == null) {
            instance = new DBProlineConfig();
            instance.initUDSProperties();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forcePropertiesFileReload() {
        Object object = CONFIGURATION_LOCK;
        synchronized (object) {
            if (instance != null) {
                DBProlineConfig.instance.m_udsExternalDB = null;
                DBProlineConfig.instance.m_maxPoolConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getMaxPoolConnection() {
        Object object = CONFIGURATION_LOCK;
        synchronized (object) {
            if (this.m_maxPoolConnection == null && this.m_dbProlineConfig.hasPath("proline-config")) {
                Config prolineConfig = this.m_dbProlineConfig.getConfig("proline-config");
                this.m_maxPoolConnection = prolineConfig.hasPath("max-pool-connection") ? Integer.valueOf(prolineConfig.getInt("max-pool-connection")) : Integer.valueOf(Math.max(1, 10));
            }
        }
        return this.m_maxPoolConnection;
    }

    public String getDbPath() {
        Config dbConfig = this.m_dbProlineConfig.getConfig("uds-db").getConfig("connection-properties");
        String path = "";
        if (dbConfig.hasPath("dbPath")) {
            path = dbConfig.hasPath("dbPath") ? dbConfig.getString("dbPath") : "";
        }
        return path;
    }

    private void initUDSProperties() {
        this.m_udsExternalDB = new ExternalDb();
        try {
            Config prolineConfig = this.m_dbProlineConfig.getConfig("proline-config");
            String driverType = prolineConfig.getString("driver-type");
            Config driverConfig = this.m_dbProlineConfig.getConfig(driverType + "-config");
            Config driverConnectionConfig = driverConfig.getConfig("connection-properties");
            DriverType driver = DriverType.valueOf((String)driverType.toUpperCase());
            this.m_udsExternalDB.setDriverType(driver);
            Config dbConfig = this.m_dbProlineConfig.getConfig("uds-db").getConfig("connection-properties");
            this.m_udsExternalDB.setDbName(dbConfig.getString("dbName"));
            Config authConfig = this.m_dbProlineConfig.getConfig("auth-config");
            this.auth_user = authConfig.getString("user");
            this.auth_password = authConfig.getString("password");
            Config hostConfig = this.m_dbProlineConfig.getConfig("host-config");
            this.m_udsExternalDB.setHost(hostConfig.getString("host"));
            if (hostConfig.hasPath("port")) {
                this.m_udsExternalDB.setPort(Integer.valueOf(hostConfig.getInt("port")));
            }
            this.m_udsExternalDB.setType(ProlineDatabaseType.UDS);
            this.m_udsExternalDB.setConnectionMode(ConnectionMode.valueOf((String)driverConnectionConfig.getString("connectionMode").toUpperCase()));
        }
        catch (ConfigException ce) {
            LOG.warn(" No UDS configuration found ! ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, Object> getUDSProperties() {
        HashMap<Object, Object> result = null;
        Object object = CONFIGURATION_LOCK;
        synchronized (object) {
            if (this.m_udsExternalDB == null) {
                this.initUDSProperties();
            }
        }
        try {
            result = this.m_udsExternalDB.toPropertiesMap(this.auth_user, this.auth_password);
        }
        catch (Exception e) {
            LOG.warn(" Error getting UDS External DB properties.");
            result = new HashMap<Object, Object>();
        }
        return result;
    }

    public ConnectionMode getUDSConnectionMode() {
        return this.m_udsExternalDB.getConnectionMode();
    }

    public ExternalDb getExternalDBTemplate() {
        ExternalDb externalDB = new ExternalDb();
        externalDB.setConnectionMode(this.m_udsExternalDB.getConnectionMode());
        externalDB.setHost(this.m_udsExternalDB.getHost());
        externalDB.setPort(this.m_udsExternalDB.getPort());
        externalDB.setDriverType(this.m_udsExternalDB.getDriverType());
        return externalDB;
    }
}

