/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.orm;

import fr.proline.module.seq.orm.Databank;
import java.io.Serializable;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="se_db_instance")
@NamedQueries(value={@NamedQuery(name="findSEDbInstanceBySEDbName", query="SELECT sdi from fr.proline.module.seq.orm.DatabankInstance sdi where sdi.databank.name = :seDbName order by sdi.release"), @NamedQuery(name="findSEDbInstanceByNameAndSourcePath", query="SELECT sdi from fr.proline.module.seq.orm.DatabankInstance sdi where (sdi.databank.name = :seDbName) and (sdi.sourcePath = :sourcePath) order by sdi.release"), @NamedQuery(name="findSEDbInstanceByNameAndRelease", query="SELECT sdi from fr.proline.module.seq.orm.DatabankInstance sdi where (sdi.databank.name = :seDbName) and (sdi.release = :release)")})
public class DatabankInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(length=50, nullable=false)
    private String release;
    @Column(name="source_path", nullable=false)
    private String sourcePath;
    @Column(name="source_last_modified_time", nullable=false)
    private Timestamp sourceLastModifiedTime;
    @ManyToOne(optional=false)
    @JoinColumn(name="se_db_id")
    private Databank databank;
    @Transient
    private String toString = null;

    private void setId(long pId) {
        this.id = pId;
    }

    public long getId() {
        return this.id;
    }

    public void setRelease(String pRelease) {
        this.release = pRelease;
    }

    public String getRelease() {
        return this.release;
    }

    public void setSourcePath(String pSourcePath) {
        this.sourcePath = pSourcePath;
        this.toString = null;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourceLastModifiedTime(Timestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Timestamp is null");
        }
        this.sourceLastModifiedTime = (Timestamp)timestamp.clone();
    }

    public Timestamp getSourceLastModifiedTime() {
        Timestamp result = null;
        if (this.sourceLastModifiedTime != null) {
            result = (Timestamp)this.sourceLastModifiedTime.clone();
        }
        return result;
    }

    public void setDatabank(Databank pSEDb) {
        this.databank = pSEDb;
        this.toString = null;
    }

    public Databank getDatabank() {
        return this.databank;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder builder = new StringBuilder().append("[name=").append(this.databank.getName()).append(", source=").append(this.sourcePath).append(']');
            this.toString = builder.toString();
        }
        return this.toString;
    }
}

