/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.service;

import fr.profi.util.StringUtils;
import fr.profi.util.ThreadLogger;
import fr.proline.module.seq.Constants;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastaPathsScanner {
    private static final Logger LOG = LoggerFactory.getLogger(FastaPathsScanner.class);
    private static final String FASTA_SUFFIX = "FASTA";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<File>> scanPaths(final FastaPathsScanner scanner, List<String> paths) throws Exception {
        assert (scanner != null) : "Scanner cannot be null to scan paths";
        assert (paths != null && !paths.isEmpty()) : "Invalid paths array";
        ArrayList<File> filePaths = new ArrayList<File>(paths.size());
        for (String pathname : paths) {
            if (pathname == null) {
                throw new IllegalArgumentException("Path is null");
            }
            File filePath = new File(pathname);
            if (filePath.exists()) {
                filePaths.add(filePath);
                continue;
            }
            LOG.warn("Non existant path [{}]", (Object)pathname);
        }
        int nPaths = filePaths.size();
        if (nPaths == 0) {
            throw new IllegalArgumentException("No valid paths");
        }
        HashMap result = null;
        ExecutorService executor = Executors.newFixedThreadPool(Constants.calculateNThreads());
        final ConcurrentHashMap traversedDirs = new ConcurrentHashMap();
        final HashMap foundFastaFiles = new HashMap();
        ArrayList futures = new ArrayList(nPaths);
        for (final File file : filePaths) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    Thread currentThread = Thread.currentThread();
                    if (!(currentThread.getUncaughtExceptionHandler() instanceof ThreadLogger)) {
                        currentThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(LOG));
                    }
                    String absolutePathname = file.getAbsolutePath();
                    LOG.debug("Scanning [{}]", (Object)absolutePathname);
                    try {
                        scanner.scan(file, traversedDirs, foundFastaFiles);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    LOG.debug("[{}] scan terminated", (Object)absolutePathname);
                }
            };
            Future<?> future = executor.submit(task);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executor.shutdown();
        if (executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of traversed dirs: {}", (Object)traversedDirs.size());
            }
            HashMap hashMap = foundFastaFiles;
            synchronized (hashMap) {
                result = foundFastaFiles;
            }
            LOG.info("{} Fasta fileName(s) found in search paths", (Object)result.size());
        } else {
            LOG.error("FastaFilesScanner Executor timed out");
        }
        return result;
    }

    protected boolean isFastaFile(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            throw new IllegalArgumentException("Invalid fileName");
        }
        return fileName.toUpperCase().endsWith(FASTA_SUFFIX);
    }

    private void scan(File file, ConcurrentMap<File, Boolean> traversedDirs, Map<String, List<File>> foundFastaFiles) throws IOException {
        assert (file != null) : "scan() file is null";
        assert (traversedDirs != null) : "scan() traversedDirs Map is null";
        String absolutePathname = file.getAbsolutePath();
        if (file.isFile()) {
            this.handleFile(file, foundFastaFiles);
        } else if (file.isDirectory()) {
            boolean alreadyTraversed = true;
            File canonicalPathname = file.getCanonicalFile();
            boolean bl = alreadyTraversed = traversedDirs.put(canonicalPathname, Boolean.TRUE) == Boolean.TRUE;
            if (alreadyTraversed) {
                LOG.info("Already traversed dir [{}]", (Object)absolutePathname);
            } else {
                File[] files = file.listFiles();
                if (files == null) {
                    LOG.warn("Cannot list [{}]", (Object)absolutePathname);
                } else {
                    for (File f : files) {
                        this.scan(f, traversedDirs, foundFastaFiles);
                    }
                }
            }
        } else {
            LOG.warn("Unknown path type [{}]", (Object)absolutePathname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFile(File file, Map<String, List<File>> foundFastaFiles) {
        assert (file != null && file.isFile()) : "handleFile() invalid file";
        assert (foundFastaFiles != null) : "handleFile() foundFastaFiles Map is null";
        String fileName = file.getName();
        if (this.isFastaFile(fileName)) {
            Map<String, List<File>> map = foundFastaFiles;
            synchronized (map) {
                List<File> files = foundFastaFiles.get(fileName);
                if (files == null) {
                    files = new ArrayList<File>(1);
                    foundFastaFiles.put(fileName, files);
                } else if (!files.isEmpty()) {
                    LOG.warn("There are multiple files with name [{}]", (Object)fileName);
                }
                files.add(file);
            }
        }
    }
}

