/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.border.Border;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.visual.util.GeomUtil;
import org.netbeans.modules.visual.widget.WidgetAccessibleContext;
import org.openide.util.Lookup;

public class Widget
implements Accessible,
Lookup.Provider {
    static final String MESSAGE_NULL_BOUNDS = "Scene.validate was not called after last change. Widget is not validated. See first Q/A at http://graph.netbeans.org/faq.html page.";
    private static final HashMap<String, WidgetAction.Chain> EMPTY_HASH_MAP = new HashMap(0);
    private Scene scene;
    private Widget parentWidget;
    private List<Widget> children;
    private List<Widget> childrenUm;
    private HashMap<Widget, Object> constraints;
    private WidgetAction.Chain actionsChain;
    private HashMap<String, WidgetAction.Chain> toolsActions = EMPTY_HASH_MAP;
    private ArrayList<Dependency> dependencies;
    private boolean visible = true;
    private boolean opaque;
    private Paint background;
    private Color foreground;
    private Font font;
    private org.netbeans.api.visual.border.Border border;
    private Layout layout;
    private Point preferredLocation;
    private Dimension minimumSize;
    private Dimension maximumSize;
    private Dimension preferredSize;
    private Rectangle preferredBounds;
    private boolean checkClipping;
    private boolean enabled;
    private String foregroundProperty = null;
    private String backgroundProperty = null;
    private String fontProperties = null;
    private PropertyChangeListener foregroundListener = null;
    private PropertyChangeListener backgroundListener = null;
    private PropertyChangeListener fontListener = null;
    private ObjectState state = ObjectState.createNormal();
    private Cursor cursor;
    private String toolTipText;
    private AccessibleContext accessibleContext;
    private Point location;
    private Rectangle bounds;
    private Rectangle calculatedPreferredBounds;
    private boolean requiresFullValidation;
    private boolean requiresPartValidation;
    private boolean requiresFullJustification;
    private boolean requiresPartJustification;
    private ResourceTable resourceTable = null;

    public Widget(Scene scene) {
        if (scene == null) {
            scene = (Scene)this;
        }
        this.scene = scene;
        this.children = new ArrayList<Widget>();
        this.childrenUm = Collections.unmodifiableList(this.children);
        this.actionsChain = new WidgetAction.Chain();
        this.opaque = false;
        this.font = null;
        this.background = Color.WHITE;
        this.foreground = Color.BLACK;
        this.border = BorderFactory.createEmptyBorder();
        this.layout = LayoutFactory.createAbsoluteLayout();
        this.preferredLocation = null;
        this.preferredBounds = null;
        this.checkClipping = false;
        this.enabled = true;
        this.location = new Point();
        this.bounds = null;
        this.calculatedPreferredBounds = null;
        this.requiresFullValidation = true;
        this.requiresPartValidation = true;
    }

    public final Scene getScene() {
        return this.scene;
    }

    protected Graphics2D getGraphics() {
        return this.scene.getGraphics();
    }

    public final Widget getParentWidget() {
        return this.parentWidget;
    }

    public final List<Widget> getChildren() {
        return this.childrenUm;
    }

    public final void addChild(Widget child) {
        this.addChild(child, null);
    }

    public final void addChild(Widget child, Object constraint) {
        assert (child.parentWidget == null);
        Widget widget = this;
        while (widget != null) {
            assert (widget != child);
            widget = widget.parentWidget;
        }
        this.children.add(child);
        child.parentWidget = this;
        this.setChildConstraint(child, constraint);
        child.updateResources(this, true);
        child.revalidate();
        this.revalidate();
        this.scene.dispatchNotifyAdded(child);
    }

    public final void addChild(int index, Widget child) {
        this.addChild(index, child, null);
    }

    public final void addChild(int index, Widget child, Object constraint) {
        assert (child.parentWidget == null);
        this.children.add(index, child);
        child.parentWidget = this;
        this.setChildConstraint(child, constraint);
        child.updateResources(this, true);
        child.revalidate();
        this.revalidate();
        if (this.accessibleContext != null && this.accessibleContext instanceof WidgetAccessibleContext) {
            ((WidgetAccessibleContext)this.accessibleContext).notifyChildAdded(this, child);
        }
        this.scene.dispatchNotifyAdded(child);
    }

    public final void removeChild(Widget child) {
        assert (child.parentWidget == this);
        this.setChildConstraint(child, null);
        child.parentWidget = null;
        this.children.remove(child);
        child.updateResources(this, false);
        child.revalidate();
        this.revalidate();
        if (this.accessibleContext != null && this.accessibleContext instanceof WidgetAccessibleContext) {
            ((WidgetAccessibleContext)this.accessibleContext).notifyChildRemoved(this, child);
        }
        this.scene.dispatchNotifyRemoved(child);
    }

    public final void removeFromParent() {
        if (this.parentWidget != null) {
            this.parentWidget.removeChild(this);
        }
    }

    public final void removeChildren() {
        while (!this.children.isEmpty()) {
            this.removeChild(this.children.get(0));
        }
    }

    public final void addChildren(List<? extends Widget> children) {
        for (Widget widget : children) {
            this.addChild(widget);
        }
    }

    public final void removeChildren(List<Widget> widgets) {
        for (Widget widget : widgets) {
            this.removeChild(widget);
        }
    }

    void dispatchNotifyAddedCore() {
        this.notifyAdded();
        for (Widget widget : this.children) {
            widget.dispatchNotifyAddedCore();
        }
    }

    void dispatchNotifyRemovedCore() {
        this.notifyRemoved();
        for (Widget widget : this.children) {
            widget.dispatchNotifyRemovedCore();
        }
    }

    protected void notifyAdded() {
    }

    protected void notifyRemoved() {
    }

    public final void bringToFront() {
        if (this.parentWidget == null) {
            return;
        }
        List<Widget> children = this.parentWidget.children;
        int i = children.indexOf(this);
        if (i < 0) {
            return;
        }
        children.remove(i);
        children.add(children.size(), this);
        this.revalidate();
        this.parentWidget.revalidate();
    }

    public final void bringToBack() {
        if (this.parentWidget == null) {
            return;
        }
        List<Widget> children = this.parentWidget.children;
        int i = children.indexOf(this);
        if (i <= 0) {
            return;
        }
        children.remove(i);
        children.add(0, this);
        this.revalidate();
        this.parentWidget.revalidate();
    }

    public final Object getChildConstraint(Widget child) {
        return this.constraints != null ? this.constraints.get(child) : null;
    }

    public final void setChildConstraint(Widget child, Object constraint) {
        assert (this.children.contains(child));
        if (constraint == null) {
            if (this.constraints != null) {
                this.constraints.remove(child);
            }
            return;
        }
        if (this.constraints == null) {
            this.constraints = new HashMap();
        }
        this.constraints.put(child, constraint);
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
        this.revalidate();
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final WidgetAction.Chain getActions() {
        return this.actionsChain;
    }

    public final WidgetAction.Chain getActions(String tool) {
        return this.toolsActions.get(tool);
    }

    public final WidgetAction.Chain createActions(String tool) {
        WidgetAction.Chain chain;
        if (tool == null) {
            return this.actionsChain;
        }
        if (this.toolsActions == EMPTY_HASH_MAP) {
            this.toolsActions = new HashMap();
            this.toolsActions.put(null, this.actionsChain);
        }
        if ((chain = this.toolsActions.get(tool)) == null) {
            chain = new WidgetAction.Chain();
            this.toolsActions.put(tool, chain);
        }
        return chain;
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public final void addDependency(Dependency dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        this.dependencies.add(dependency);
    }

    public final void removeDependency(Dependency dependency) {
        if (this.dependencies == null) {
            return;
        }
        this.dependencies.remove(dependency);
    }

    public final Collection<Dependency> getDependencies() {
        return this.dependencies != null ? Collections.unmodifiableCollection(this.dependencies) : Collections.emptyList();
    }

    public final boolean isOpaque() {
        return this.opaque;
    }

    public final void setOpaque(boolean opaque) {
        this.opaque = opaque;
        this.repaint();
    }

    public final Paint getBackground() {
        return this.background != null ? this.background : (this.parentWidget != null ? this.parentWidget.getBackground() : null);
    }

    public final void setBackground(Paint background) {
        this.background = background;
        if (this.backgroundListener != null) {
            ResourceTable resourceTable = this.getResourceTable();
            if (resourceTable != null) {
                resourceTable.removePropertyChangeListener(this.backgroundProperty, this.backgroundListener);
            }
            this.backgroundListener = null;
        }
        this.repaint();
    }

    public final void setBackgroundFromResource(String property) {
        ResourceTable table = this.getResourceTable();
        String oldPropertyName = this.backgroundProperty;
        this.backgroundProperty = property;
        if (table != null) {
            Object value;
            if (oldPropertyName != null && oldPropertyName.length() > 0) {
                table.removePropertyChangeListener(oldPropertyName, this.backgroundListener);
            }
            if ((value = table.getProperty(property)) instanceof Paint) {
                this.background = (Paint)value;
            }
            this.backgroundListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getNewValue() instanceof Paint) {
                        Widget.this.background = (Paint)event.getNewValue();
                        Widget.this.notifyBackgroundChanged(Widget.this.background);
                    }
                }
            };
            table.addPropertyChangeListener(property, this.backgroundListener);
        }
        this.repaint();
    }

    protected void notifyBackgroundChanged(Paint paint) {
    }

    public final Color getForeground() {
        return this.foreground != null ? this.foreground : (this.parentWidget != null ? this.parentWidget.getForeground() : null);
    }

    public final void setForeground(Color foreground) {
        this.foreground = foreground;
        if (this.foregroundListener != null) {
            ResourceTable resourceTable = this.getResourceTable();
            if (resourceTable != null) {
                resourceTable.removePropertyChangeListener(this.foregroundProperty, this.foregroundListener);
            }
            this.foregroundListener = null;
        }
        this.repaint();
    }

    public final void setForegroundFromResource(String property) {
        String oldPropertyName = this.foregroundProperty;
        this.foregroundProperty = property;
        ResourceTable table = this.getResourceTable();
        if (table != null) {
            Object value;
            if (oldPropertyName != null && oldPropertyName.length() > 0) {
                table.removePropertyChangeListener(oldPropertyName, this.foregroundListener);
            }
            if ((value = table.getProperty(property)) instanceof Color) {
                this.foreground = (Color)value;
            }
            if (this.foregroundListener == null) {
                this.foregroundListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getNewValue() instanceof Color) {
                            Widget.this.foreground = (Color)event.getNewValue();
                            Widget.this.notifyForegroundChanged(Widget.this.foreground);
                        }
                    }
                };
            }
            table.addPropertyChangeListener(property, this.foregroundListener);
        }
        this.repaint();
    }

    protected void notifyForegroundChanged(Color newColor) {
    }

    public final Font getFont() {
        Font retVal = this.font;
        if (this.font == null && this.parentWidget != null) {
            retVal = this.parentWidget.getFont();
        }
        return retVal;
    }

    public final void setFont(Font font) {
        this.font = font;
        if (this.fontListener != null) {
            ResourceTable resourceTable = this.getResourceTable();
            if (resourceTable != null) {
                resourceTable.removePropertyChangeListener(this.fontProperties, this.fontListener);
            }
            this.fontListener = null;
        }
        this.notifyFontChanged(font);
        this.revalidate();
    }

    public final void setFontFromResource(String property) {
        String oldPropertyName = this.fontProperties;
        this.fontProperties = property;
        ResourceTable table = this.getResourceTable();
        if (table != null) {
            Object value;
            if (oldPropertyName != null && oldPropertyName.length() > 0) {
                table.removePropertyChangeListener(oldPropertyName, this.fontListener);
            }
            if ((value = table.getProperty(property)) instanceof Font) {
                this.font = (Font)value;
            }
            this.fontListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    Object newValue = event.getNewValue();
                    if (newValue instanceof Font && Widget.this.parentWidget != null) {
                        Widget.this.font = (Font)newValue;
                        Widget.this.notifyFontChanged(Widget.this.font);
                    }
                }
            };
            table.addPropertyChangeListener(property, this.fontListener);
        }
        this.repaint();
    }

    protected final void updateResources(Widget parent, boolean added) {
        ResourceTable table;
        if (added) {
            table = this.connectResourceTable();
            if (table != null) {
                if (this.foregroundProperty != null && this.foregroundProperty.length() > 0) {
                    this.setForegroundFromResource(this.foregroundProperty);
                }
                if (this.fontProperties != null && this.fontProperties.length() > 0) {
                    this.setFontFromResource(this.fontProperties);
                }
                if (this.backgroundProperty != null && this.backgroundProperty.length() > 0) {
                    this.setBackgroundFromResource(this.backgroundProperty);
                }
            }
        } else {
            table = this.resourceTable;
            if (table == null) {
                table = parent.getResourceTable();
            }
            if (table != null) {
                if (this.foregroundListener != null) {
                    table.removePropertyChangeListener(this.foregroundListener);
                }
                if (this.fontListener != null) {
                    table.removePropertyChangeListener(this.fontListener);
                }
                if (this.backgroundListener != null) {
                    table.removePropertyChangeListener(this.backgroundListener);
                }
            }
            this.disconnectResourceTable();
        }
        for (Widget child : this.getChildren()) {
            child.updateResources(parent, added);
        }
        this.revalidate();
    }

    protected void notifyFontChanged(Font font) {
    }

    public final org.netbeans.api.visual.border.Border getBorder() {
        return this.border;
    }

    public final void setBorder(org.netbeans.api.visual.border.Border border) {
        assert (border != null);
        boolean repaintOnly = this.border.getInsets().equals(border.getInsets());
        this.border = border;
        this.revalidate(repaintOnly);
    }

    public final void setBorder(Border swingBorder) {
        assert (swingBorder != null);
        this.setBorder(BorderFactory.createSwingBorder(this.scene, swingBorder));
    }

    public final Layout getLayout() {
        return this.layout;
    }

    public final void setLayout(Layout layout) {
        this.layout = layout;
        this.revalidate();
    }

    public final Dimension getMinimumSize() {
        return this.minimumSize != null ? new Dimension(this.minimumSize) : null;
    }

    public final void setMinimumSize(Dimension minimumSize) {
        if (GeomUtil.equals(this.minimumSize, minimumSize)) {
            return;
        }
        this.minimumSize = minimumSize;
        this.revalidate();
    }

    public final Dimension getMaximumSize() {
        return this.maximumSize != null ? new Dimension(this.maximumSize) : null;
    }

    public final void setMaximumSize(Dimension maximumSize) {
        if (GeomUtil.equals(this.maximumSize, maximumSize)) {
            return;
        }
        this.maximumSize = maximumSize;
        this.revalidate();
    }

    public final Dimension getPreferredSize() {
        return this.preferredSize != null ? new Dimension(this.preferredSize) : null;
    }

    public final void setPreferredSize(Dimension preferredSize) {
        if (GeomUtil.equals(this.preferredSize, preferredSize)) {
            return;
        }
        this.preferredSize = preferredSize;
        this.revalidate();
    }

    public final Point getPreferredLocation() {
        return this.preferredLocation != null ? new Point(this.preferredLocation) : null;
    }

    public final void setPreferredLocation(Point preferredLocation) {
        if (GeomUtil.equals(this.preferredLocation, preferredLocation)) {
            return;
        }
        this.preferredLocation = preferredLocation;
        this.revalidate();
    }

    public final boolean isPreferredBoundsSet() {
        return this.preferredBounds != null;
    }

    public final Rectangle getPreferredBounds() {
        Rectangle rect;
        if (this.isPreferredBoundsSet()) {
            rect = new Rectangle(this.preferredBounds);
        } else {
            if (this.calculatedPreferredBounds == null) {
                this.calculatedPreferredBounds = this.calculatePreferredBounds();
            }
            rect = new Rectangle(this.calculatedPreferredBounds);
            if (this.preferredSize != null) {
                rect.width = this.preferredSize.width;
                rect.height = this.preferredSize.height;
            }
        }
        if (this.minimumSize != null) {
            if (rect.width < this.minimumSize.width) {
                rect.width = this.minimumSize.width;
            }
            if (rect.height < this.minimumSize.height) {
                rect.height = this.minimumSize.height;
            }
        }
        if (this.maximumSize != null) {
            if (rect.width > this.maximumSize.width) {
                rect.width = this.maximumSize.width;
            }
            if (rect.height > this.maximumSize.height) {
                rect.height = this.maximumSize.height;
            }
        }
        return rect;
    }

    private Rectangle calculatePreferredBounds() {
        Insets insets = this.border.getInsets();
        Rectangle clientArea = this.calculateClientArea();
        for (Widget child : this.children) {
            if (!child.isVisible()) continue;
            Point location = child.getLocation();
            Rectangle bounds = child.getBounds();
            bounds.translate(location.x, location.y);
            clientArea.add(bounds);
        }
        clientArea.x -= insets.left;
        clientArea.y -= insets.top;
        clientArea.width += insets.left + insets.right;
        clientArea.height += insets.top + insets.bottom;
        return clientArea;
    }

    protected Rectangle calculateClientArea() {
        return new Rectangle();
    }

    public final void setPreferredBounds(Rectangle preferredBounds) {
        if (GeomUtil.equals(this.preferredBounds, preferredBounds)) {
            return;
        }
        this.preferredBounds = preferredBounds;
        this.revalidate();
    }

    public final boolean isCheckClipping() {
        return this.checkClipping;
    }

    public final void setCheckClipping(boolean checkClipping) {
        this.checkClipping = checkClipping;
        this.repaint();
    }

    protected Cursor getCursorAt(Point localLocation) {
        return this.getCursor();
    }

    public final Cursor getCursor() {
        return this.cursor;
    }

    public final void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public final String getToolTipText() {
        return this.toolTipText;
    }

    public final void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new WidgetAccessibleContext(this);
        }
        return this.accessibleContext;
    }

    public final void setAccessibleContext(AccessibleContext accessibleContext) {
        this.accessibleContext = accessibleContext;
    }

    public final ObjectState getState() {
        return this.state;
    }

    public final void setState(ObjectState state) {
        ObjectState previousState = this.state;
        this.state = state;
        this.notifyStateChanged(previousState, state);
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
    }

    public final Point convertLocalToScene(Point localLocation) {
        Point sceneLocation = new Point(localLocation);
        for (Widget widget = this; widget != null && widget != this.scene; widget = widget.getParentWidget()) {
            Point location = widget.getLocation();
            sceneLocation.x += location.x;
            sceneLocation.y += location.y;
        }
        return sceneLocation;
    }

    @NonNull
    public final Rectangle convertLocalToScene(@NonNull Rectangle localRectangle) {
        Rectangle sceneRectangle = new Rectangle(localRectangle);
        for (Widget widget = this; widget != null && widget != this.scene; widget = widget.getParentWidget()) {
            Point location = widget.getLocation();
            sceneRectangle.x += location.x;
            sceneRectangle.y += location.y;
        }
        return sceneRectangle;
    }

    public final Point convertSceneToLocal(Point sceneLocation) {
        Point localLocation = new Point(sceneLocation);
        for (Widget widget = this; widget != null && widget != this.scene; widget = widget.getParentWidget()) {
            Point location = widget.getLocation();
            localLocation.x -= location.x;
            localLocation.y -= location.y;
        }
        return localLocation;
    }

    public final Rectangle convertSceneToLocal(Rectangle sceneRectangle) {
        Rectangle localRectangle = new Rectangle(sceneRectangle);
        for (Widget widget = this; widget != null && widget != this.scene; widget = widget.getParentWidget()) {
            Point location = widget.getLocation();
            localRectangle.x -= location.x;
            localRectangle.y -= location.y;
        }
        return localRectangle;
    }

    public final Point getLocation() {
        return this.location != null ? new Point(this.location) : null;
    }

    @CheckForNull
    public final Rectangle getBounds() {
        return this.bounds != null ? new Rectangle(this.bounds) : null;
    }

    public final void resolveBounds(Point location, Rectangle bounds) {
        this.location = location != null ? location : new Point();
        this.bounds = bounds != null ? new Rectangle(bounds) : new Rectangle(this.getPreferredBounds());
    }

    public final Rectangle getClientArea() {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return null;
        }
        Insets insets = this.getBorder().getInsets();
        return new Rectangle(bounds.x + insets.left, bounds.y + insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
    }

    public boolean isHitAt(Point localLocation) {
        return this.visible && this.getBounds().contains(localLocation);
    }

    public final void repaint() {
        this.scene.revalidateWidget(this);
    }

    public boolean isValidated() {
        return !this.requiresPartValidation;
    }

    public final void revalidate(boolean repaintOnly) {
        if (repaintOnly) {
            this.repaint();
        } else {
            this.revalidate();
        }
    }

    public final void revalidate() {
        this.requiresFullValidation = true;
        this.revalidateUptoRoot();
    }

    protected boolean isRepaintRequiredForRevalidating() {
        return true;
    }

    private void revalidateUptoRoot() {
        if (this.requiresPartValidation) {
            return;
        }
        if (this.isRepaintRequiredForRevalidating()) {
            this.repaint();
        }
        this.calculatedPreferredBounds = null;
        this.requiresPartValidation = true;
        if (this.parentWidget != null) {
            this.parentWidget.revalidateUptoRoot();
        }
        if (this.dependencies != null) {
            for (Dependency dependency : this.dependencies) {
                dependency.revalidateDependency();
            }
        }
    }

    void layout(boolean fullValidation) {
        boolean childFullValidation = fullValidation || this.requiresFullValidation;
        for (Widget widget : this.children) {
            widget.layout(childFullValidation);
        }
        if (fullValidation && this.dependencies != null) {
            for (Dependency dependency : this.dependencies) {
                dependency.revalidateDependency();
            }
        }
        if (childFullValidation || this.requiresPartValidation) {
            this.layout.layout(this);
            if (this.layout.requiresJustification(this)) {
                this.rejustify();
            }
        }
        this.requiresFullValidation = false;
        this.requiresPartValidation = false;
    }

    private void rejustify() {
        this.requiresFullJustification = true;
        this.rejustifyUptoRoot();
    }

    private void rejustifyUptoRoot() {
        if (this.requiresPartJustification) {
            return;
        }
        this.requiresPartJustification = true;
        if (this.parentWidget != null) {
            this.parentWidget.rejustifyUptoRoot();
        }
    }

    final void justify() {
        if (this.requiresFullJustification) {
            this.layout.justify(this);
            if (this.layout.requiresJustification(this)) {
                for (Widget child : this.children) {
                    child.rejustify();
                }
            }
        }
        for (Widget widget : this.children) {
            if (!widget.requiresPartJustification) continue;
            widget.justify();
        }
        this.requiresFullJustification = false;
        this.requiresPartJustification = false;
    }

    public final void paint() {
        Rectangle clipBounds;
        if (!this.visible) {
            return;
        }
        assert (this.bounds != null) : "Scene.validate was not called after last change. Widget is not validated. See first Q/A at http://graph.netbeans.org/faq.html page.";
        Graphics2D gr = this.scene.getGraphics();
        AffineTransform previousTransform = gr.getTransform();
        gr.translate(this.location.x, this.location.y);
        Shape tempClip = null;
        if (this.checkClipping) {
            tempClip = gr.getClip();
            gr.clip(this.bounds);
        }
        if (!this.checkClipping || (clipBounds = gr.getClipBounds()) == null || this.bounds.intersects(clipBounds)) {
            if (this.opaque) {
                this.paintBackground();
            }
            this.paintBorder();
            if (this.checkClipping) {
                Insets insets = this.border.getInsets();
                gr.clipRect(this.bounds.x + insets.left, this.bounds.y + insets.top, this.bounds.width - insets.left - insets.right, this.bounds.height - insets.top - insets.bottom);
            }
            this.paintWidget();
            this.paintChildren();
        }
        if (this.checkClipping) {
            gr.setClip(tempClip);
        }
        gr.setTransform(previousTransform);
    }

    protected void paintBackground() {
        Graphics2D gr = this.scene.getGraphics();
        Insets insets = this.border.getInsets();
        gr.setPaint(this.background);
        if (this.border.isOpaque()) {
            gr.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        } else {
            gr.fillRect(this.bounds.x + insets.left, this.bounds.y + insets.top, this.bounds.width - insets.left - insets.right, this.bounds.height - insets.top - insets.bottom);
        }
    }

    protected void paintBorder() {
        this.border.paint(this.getGraphics(), new Rectangle(this.bounds));
    }

    protected void paintWidget() {
    }

    protected void paintChildren() {
        if (this.checkClipping) {
            Rectangle clipBounds = this.scene.getGraphics().getClipBounds();
            for (Widget child : this.children) {
                Point location = child.getLocation();
                Rectangle bounds = child.getBounds();
                bounds.translate(location.x, location.y);
                if (clipBounds != null && !bounds.intersects(clipBounds)) continue;
                child.paint();
            }
        } else {
            for (Widget child : this.children) {
                child.paint();
            }
        }
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public ResourceTable getResourceTable() {
        ResourceTable retVal = this.resourceTable;
        if (retVal == null && this.getParentWidget() != null) {
            retVal = this.getParentWidget().getResourceTable();
        }
        return retVal;
    }

    private ResourceTable connectResourceTable() {
        if (this.resourceTable != null && this.getParentWidget() != null) {
            ResourceTable parentTable = this.getParentWidget().getResourceTable();
            this.resourceTable.setParentTable(parentTable);
        }
        return this.getResourceTable();
    }

    private void disconnectResourceTable() {
        if (this.resourceTable != null) {
            this.resourceTable.removeParent();
        }
    }

    public void setResourceTable(ResourceTable table) {
        this.resourceTable = table;
    }

    public static interface Dependency {
        public void revalidateDependency();
    }
}

