/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.contact.AtomContact;
import org.biojava.nbio.structure.contact.AtomIdentifier;
import org.biojava.nbio.structure.contact.Pair;

public class AtomContactSet
implements Serializable,
Iterable<AtomContact> {
    private static final long serialVersionUID = 1L;
    private HashMap<Pair<AtomIdentifier>, AtomContact> contacts;
    private double cutoff;

    public AtomContactSet(double cutoff) {
        this.cutoff = cutoff;
        this.contacts = new HashMap();
    }

    public void add(AtomContact contact) {
        this.contacts.put(this.getAtomIdPairFromContact(contact), contact);
    }

    public void addAll(Collection<AtomContact> list) {
        for (AtomContact contact : list) {
            this.contacts.put(this.getAtomIdPairFromContact(contact), contact);
        }
    }

    public boolean hasContact(Atom atom1, Atom atom2) {
        return this.hasContact(new AtomIdentifier(atom1.getPDBserial(), atom1.getGroup().getChainId()), new AtomIdentifier(atom2.getPDBserial(), atom2.getGroup().getChainId()));
    }

    public boolean hasContact(AtomIdentifier atomId1, AtomIdentifier atomId2) {
        return this.contacts.containsKey(new Pair<AtomIdentifier>(atomId1, atomId2));
    }

    public AtomContact getContact(Atom atom1, Atom atom2) {
        return this.contacts.get(new Pair<AtomIdentifier>(new AtomIdentifier(atom1.getPDBserial(), atom1.getGroup().getChainId()), new AtomIdentifier(atom2.getPDBserial(), atom2.getGroup().getChainId())));
    }

    public int size() {
        return this.contacts.size();
    }

    @Override
    public Iterator<AtomContact> iterator() {
        return this.contacts.values().iterator();
    }

    private Pair<AtomIdentifier> getAtomIdPairFromContact(AtomContact contact) {
        Pair<AtomIdentifier> pair = new Pair<AtomIdentifier>(new AtomIdentifier(contact.getPair().getFirst().getPDBserial(), contact.getPair().getFirst().getGroup().getChainId()), new AtomIdentifier(contact.getPair().getSecond().getPDBserial(), contact.getPair().getSecond().getGroup().getChainId()));
        return pair;
    }

    public boolean hasContactsWithinDistance(double distance) {
        if (distance >= this.cutoff) {
            throw new IllegalArgumentException("Given distance " + String.format("%.2f", distance) + " is larger than contacts' distance cutoff " + String.format("%.2f", this.cutoff));
        }
        for (AtomContact contact : this.contacts.values()) {
            if (!(contact.getDistance() < distance)) continue;
            return true;
        }
        return false;
    }

    public List<AtomContact> getContactsWithinDistance(double distance) {
        if (distance >= this.cutoff) {
            throw new IllegalArgumentException("Given distance " + String.format("%.2f", distance) + " is larger than contacts' distance cutoff " + String.format("%.2f", this.cutoff));
        }
        ArrayList<AtomContact> list = new ArrayList<AtomContact>();
        for (AtomContact contact : this.contacts.values()) {
            if (!(contact.getDistance() < distance)) continue;
            list.add(contact);
        }
        return list;
    }
}

