/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.biojava.nbio.structure.io.mmcif.ChemCompConsumer;
import org.biojava.nbio.structure.io.mmcif.ChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.ChemicalComponentDictionary;
import org.biojava.nbio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReducedChemCompProvider
implements ChemCompProvider {
    private static final Logger logger = LoggerFactory.getLogger(ReducedChemCompProvider.class);

    public ReducedChemCompProvider() {
        logger.debug("Initialising ReducedChemCompProvider");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ChemComp getChemComp(String recordName) {
        String name = recordName.toUpperCase().trim();
        try (InputStream inStream = this.getClass().getResourceAsStream("/chemcomp/" + name + ".cif.gz");){
            ChemComp chemComp2;
            logger.debug("Reading chemcomp/" + name + ".cif.gz");
            if (inStream == null) {
                logger.debug("Getting empty chem comp for {}", (Object)name);
                ChemComp cc = ChemComp.getEmptyChemComp();
                cc.setId(name);
                ChemComp chemComp3 = cc;
                return chemComp3;
            }
            SimpleMMcifParser parser = new SimpleMMcifParser();
            ChemCompConsumer consumer = new ChemCompConsumer();
            parser.addMMcifConsumer(consumer);
            parser.parse(new BufferedReader(new InputStreamReader(new GZIPInputStream(inStream))));
            ChemicalComponentDictionary dict = consumer.getDictionary();
            ChemComp chemComp = chemComp2 = dict.getChemComp(name);
            return chemComp;
        }
        catch (IOException e) {
            logger.error("IOException caught while reading chem comp {}.", (Object)name, (Object)e);
            logger.warn("Problem when loading chem comp {}, will use an empty chem comp for it", (Object)name);
            ChemComp cc = ChemComp.getEmptyChemComp();
            cc.setId(name);
            return cc;
        }
    }
}

