/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.Map;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AlignmentTools;
import org.biojava.nbio.structure.symmetry.internal.OrderDetector;
import org.biojava.nbio.structure.symmetry.internal.RefinerFailedException;

public class SequenceFunctionOrderDetector
implements OrderDetector {
    private int maxSymmetry = 8;
    private float minimumMetricChange = 0.4f;

    public SequenceFunctionOrderDetector() {
    }

    public SequenceFunctionOrderDetector(int maxSymmetry, float minimumMetricChange) {
        this.maxSymmetry = maxSymmetry;
        this.minimumMetricChange = minimumMetricChange;
    }

    @Override
    public int calculateOrder(AFPChain afpChain, Atom[] ca) throws RefinerFailedException {
        try {
            Map<Integer, Integer> alignment = AlignmentTools.alignmentAsMap(afpChain);
            return AlignmentTools.getSymmetryOrder(alignment, new AlignmentTools.IdentityMap<Integer>(), this.maxSymmetry, this.minimumMetricChange);
        }
        catch (StructureException e) {
            throw new RefinerFailedException(e);
        }
    }

    public String toString() {
        return "SequenceFunctionOrderDetector [maxSymmetry=" + this.maxSymmetry + ", minimumMetricChange=" + this.minimumMetricChange + "]";
    }
}

