/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.misc;

import java.util.List;

public class ChainSignature
implements Comparable<ChainSignature> {
    private int chainCount = 0;
    private String representative = "";
    private String compositionId = "";
    private List<String> chainIds = null;

    public ChainSignature(String representative, int chainCount, List<String> chainIds) {
        this.representative = representative;
        this.chainCount = chainCount;
        this.chainIds = chainIds;
    }

    public String getRepresentative() {
        return this.representative;
    }

    public List<String> getChainIds() {
        return this.chainIds;
    }

    public String getCompositionId() {
        return this.compositionId;
    }

    public void setCompositionId(String compositionId) {
        this.compositionId = compositionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ChainSignature other = (ChainSignature)obj;
        if (this.representative == null) {
            return false;
        }
        return this.chainCount == other.chainCount && this.representative.equals(other.representative);
    }

    @Override
    public int compareTo(ChainSignature other) {
        if (other.chainCount < this.chainCount) {
            return -1;
        }
        if (other.chainCount > this.chainCount) {
            return 1;
        }
        return this.representative.compareTo(other.representative);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.chainCount;
        hash = 31 * hash + (this.representative == null ? 0 : this.representative.hashCode());
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.representative);
        builder.append(")");
        if (this.chainCount > 1) {
            builder.append(this.chainCount);
        }
        return builder.toString();
    }
}

