/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.biojava.nbio.structure.symmetry.misc.ChainSignature;
import org.biojava.nbio.structure.symmetry.utils.BlastClustReader;

public class ProteinComplexSignature {
    private BlastClustReader blastClust = null;
    private String pdbId = "";
    private List<String> chainIds = null;
    private List<ChainSignature> chainSignatures = new ArrayList<ChainSignature>();

    public ProteinComplexSignature(String pdbId, List<String> chainIds, BlastClustReader blastClust) {
        this.pdbId = pdbId;
        this.chainIds = chainIds;
        this.blastClust = blastClust;
        this.getChainSignatures();
    }

    public String getComplexSignature() {
        StringBuilder builder = new StringBuilder();
        for (ChainSignature s : this.chainSignatures) {
            builder.append(s.toString());
        }
        return builder.toString();
    }

    public String getCompositionId(String chainId) {
        for (ChainSignature s : this.chainSignatures) {
            if (!s.getChainIds().contains(chainId)) continue;
            return s.getCompositionId();
        }
        return "";
    }

    public String getComplexStoichiometry() {
        StringBuilder s = new StringBuilder();
        for (ChainSignature c : this.chainSignatures) {
            s.append(c.getCompositionId());
            if (c.getChainIds().size() <= 1) continue;
            s.append(c.getChainIds().size());
        }
        return s.toString();
    }

    public int getSubunitTypeCount() {
        return this.chainSignatures.size();
    }

    private List<ChainSignature> getChainSignatures() {
        String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        TreeMap<String, Integer> mapCounts = new TreeMap<String, Integer>();
        TreeMap mapChainIds = new TreeMap();
        for (String string : this.chainIds) {
            List<String> list;
            String rep = this.blastClust.getRepresentativeChain(this.pdbId, string);
            Integer value = (Integer)mapCounts.get(rep);
            if (value == null) {
                mapCounts.put(rep, 1);
                list = new ArrayList<String>();
                list.add(string);
                mapChainIds.put(rep, list);
                continue;
            }
            value = value + 1;
            mapCounts.put(rep, value);
            list = (List)mapChainIds.get(rep);
            list.add(string);
        }
        for (Map.Entry entry : mapCounts.entrySet()) {
            List chainIds = (List)mapChainIds.get(entry.getKey());
            ChainSignature chainSignature = new ChainSignature((String)entry.getKey(), (Integer)entry.getValue(), chainIds);
            this.chainSignatures.add(chainSignature);
        }
        Collections.sort(this.chainSignatures);
        for (int i = 0; i < this.chainSignatures.size(); ++i) {
            ChainSignature chainSignature = this.chainSignatures.get(i);
            if (i < alpha.length()) {
                chainSignature.setCompositionId(alpha.substring(i, i + 1));
                continue;
            }
            chainSignature.setCompositionId("?");
        }
        return this.chainSignatures;
    }
}

