/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.lcms;

import fr.proline.core.orm.lcms.FeatureMs2Event;
import fr.proline.core.orm.lcms.Map;
import fr.proline.core.orm.lcms.ProcessedMap;
import fr.proline.core.orm.lcms.ScanSequence;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="raw_map")
@NamedQuery(name="RawMap.findAll", query="SELECT r FROM RawMap r")
public class RawMap
extends Map
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="peak_picking_software_id")
    private Long peakPickingSoftwareId;
    @Column(name="peakel_fitting_model_id")
    private Long peakelFittingModelId;
    @OneToMany(mappedBy="rawMap")
    private List<FeatureMs2Event> featureMs2Events;
    @ManyToOne
    @JoinColumn(name="scan_sequence_id")
    private ScanSequence scanSequence;
    @OneToMany
    @JoinTable(name="processed_map_raw_map_mapping", joinColumns={@JoinColumn(name="raw_map_id")}, inverseJoinColumns={@JoinColumn(name="processed_map_id")})
    private List<ProcessedMap> processedMaps;

    public Long getPeakPickingSoftwareId() {
        return this.peakPickingSoftwareId;
    }

    public void setPeakPickingSoftwareId(Long peakPickingSoftwareId) {
        this.peakPickingSoftwareId = peakPickingSoftwareId;
    }

    public Long getPeakelFittingModelId() {
        return this.peakelFittingModelId;
    }

    public void setPeakelFittingModelId(Long peakelFittingModelId) {
        this.peakelFittingModelId = peakelFittingModelId;
    }

    public List<FeatureMs2Event> getFeatureMs2Events() {
        return this.featureMs2Events;
    }

    public void setFeatureMs2Events(List<FeatureMs2Event> featureMs2Events) {
        this.featureMs2Events = featureMs2Events;
    }

    public ScanSequence getScanSequence() {
        return this.scanSequence;
    }

    public void setScanSequence(ScanSequence scanSequence) {
        this.scanSequence = scanSequence;
    }

    public ProcessedMap getProcessedMap() {
        for (ProcessedMap pm : this.processedMaps) {
            if (pm.getIsMaster().booleanValue()) continue;
            return pm;
        }
        return null;
    }

    public ProcessedMap getMasterMap() {
        for (ProcessedMap pm : this.processedMaps) {
            if (!pm.getIsMaster().booleanValue()) continue;
            return pm;
        }
        return null;
    }

    @Override
    public String toString() {
        return "RawMap " + this.getId() + " of " + this.scanSequence.toString();
    }
}

