/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.profi.util.StringUtils;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQuery;

@Entity(name="fr.proline.core.orm.msi.Enzyme")
@NamedQuery(name="findMsiEnzymeForName", query="select e from fr.proline.core.orm.msi.Enzyme e where upper(e.name) = :name")
public class Enzyme
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private long id;
    @Column(name="cleavage_regexp")
    private String cleavageRegexp;
    @Column(name="is_independant")
    private boolean isIndependant;
    @Column(name="is_semi_specific")
    private boolean isSemiSpecific;
    private String name;
    @Column(name="serialized_properties")
    private String serializedProperties;

    public Enzyme() {
    }

    public Enzyme(fr.proline.core.orm.uds.Enzyme udsEnzyme) {
        if (udsEnzyme == null) {
            throw new IllegalArgumentException("UdsEnzyme is null");
        }
        this.setId(udsEnzyme.getId());
        String udsCleavageRegex = udsEnzyme.getCleavageRegexp();
        if (StringUtils.isEmpty((String)udsCleavageRegex)) {
            this.setCleavageRegexp(null);
        } else {
            this.setCleavageRegexp(udsCleavageRegex);
        }
        this.setIsIndependant(udsEnzyme.getIsIndependant());
        this.setIsSemiSpecific(udsEnzyme.getIsSemiSpecific());
        this.setName(udsEnzyme.getName());
    }

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getCleavageRegexp() {
        return this.cleavageRegexp;
    }

    public void setCleavageRegexp(String cleavageRegexp) {
        this.cleavageRegexp = cleavageRegexp;
    }

    public boolean getIsIndependant() {
        return this.isIndependant;
    }

    public void setIsIndependant(boolean pIsIndependant) {
        this.isIndependant = pIsIndependant;
    }

    public boolean getIsSemiSpecific() {
        return this.isSemiSpecific;
    }

    public void setIsSemiSpecific(boolean pIsSemiSpecific) {
        this.isSemiSpecific = pIsSemiSpecific;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }
}

