/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.MergeMode;
import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.uds.Dataset;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.util.JsonSerializer;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.core.orm.util.TransientDataInterface;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="result_summary")
public class ResultSummary
implements Serializable,
TransientDataInterface {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(name="creation_log")
    private String creationLog;
    private String description;
    @Column(name="is_quantified")
    private boolean isQuantified = false;
    @Column(name="modification_timestamp")
    private Timestamp modificationTimestamp;
    @ManyToOne
    @JoinColumn(name="result_set_id")
    private ResultSet resultSet;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @ManyToOne
    @JoinColumn(name="decoy_result_summary_id")
    private ResultSummary decoyResultSummary;
    @OneToMany
    @JoinTable(name="result_summary_relation", joinColumns={@JoinColumn(name="parent_result_summary_id")}, inverseJoinColumns={@JoinColumn(name="child_result_summary_id")})
    private Set<ResultSummary> children;
    @ElementCollection
    @MapKeyColumn(name="schema_name")
    @Column(name="object_tree_id")
    @CollectionTable(name="result_summary_object_tree_map", joinColumns={@JoinColumn(name="result_summary_id", referencedColumnName="id")})
    private Map<String, Long> objectTreeIdByName;
    @Transient
    private TransientData transientData = null;
    @Transient
    private Map<String, Object> serializedPropertiesMap;
    @Transient
    private MergeMode mergeMode;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getCreationLog() {
        return this.creationLog;
    }

    public void setCreationLog(String creationLog) {
        this.creationLog = creationLog;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getIsQuantified() {
        return this.isQuantified;
    }

    public void setIsQuantified(boolean isQuantified) {
        this.isQuantified = isQuantified;
    }

    public Timestamp getModificationTimestamp() {
        Timestamp result = null;
        if (this.modificationTimestamp != null) {
            result = (Timestamp)this.modificationTimestamp.clone();
        }
        return result;
    }

    public void setModificationTimestamp(Timestamp pModificationTimestamp) {
        if (pModificationTimestamp == null) {
            throw new IllegalArgumentException("PModificationTimestamp is null");
        }
        this.modificationTimestamp = (Timestamp)pModificationTimestamp.clone();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public ResultSummary getDecoyResultSummary() {
        return this.decoyResultSummary;
    }

    public void setDecoyResultSummary(ResultSummary decoyResultSummary) {
        this.decoyResultSummary = decoyResultSummary;
    }

    public Set<ResultSummary> getChildren() {
        return this.children;
    }

    public void setChildren(Set<ResultSummary> children) {
        this.children = children;
    }

    void setObjectTreeIdByName(Map<String, Long> objectTree) {
        this.objectTreeIdByName = objectTree;
    }

    public Map<String, Long> getObjectTreeIdByName() {
        return this.objectTreeIdByName;
    }

    public Long putObject(String schemaName, long objectId) {
        if (StringUtils.isEmpty((String)schemaName)) {
            throw new IllegalArgumentException("Invalid schemaName");
        }
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree == null) {
            localObjectTree = new HashMap<String, Long>();
            this.setObjectTreeIdByName(localObjectTree);
        }
        return localObjectTree.put(schemaName, objectId);
    }

    public Long removeObject(String schemaName) {
        Long result = null;
        Map<String, Long> localObjectTree = this.getObjectTreeIdByName();
        if (localObjectTree != null) {
            result = localObjectTree.remove(schemaName);
        }
        return result;
    }

    public Map<String, Object> getSerializedPropertiesAsMap() throws Exception {
        if (this.serializedPropertiesMap == null && this.serializedProperties != null) {
            this.serializedPropertiesMap = (Map)JsonSerializer.getMapper().readValue(this.getSerializedProperties(), Map.class);
        }
        return this.serializedPropertiesMap;
    }

    public void setSerializedPropertiesAsMap(Map<String, Object> serializedPropertiesMap) throws Exception {
        this.serializedPropertiesMap = serializedPropertiesMap;
        this.serializedProperties = JsonSerializer.getMapper().writeValueAsString(serializedPropertiesMap);
    }

    public TransientData getTransientData(TransientDataAllocationListener listener) {
        if (this.transientData == null) {
            this.transientData = new TransientData();
            if (listener != null) {
                listener.memoryAllocated(this);
            }
        }
        return this.transientData;
    }

    public MergeMode getMergeMode() throws Exception {
        if (this.mergeMode == null) {
            String mode = (String)this.getSerializedPropertiesAsMap().getOrDefault("merge_mode", MergeMode.NO_MERGE.name());
            this.mergeMode = MergeMode.valueOf(mode.toUpperCase());
        }
        return this.mergeMode;
    }

    public void setMergeMode(MergeMode mode) {
        this.mergeMode = mode;
    }

    @Override
    public void clearMemory() {
        this.transientData = null;
    }

    @Override
    public String getMemoryName(String additionalName) {
        String rSetName = this.resultSet.getName();
        if (rSetName == null || rSetName.length() == 0) {
            return "Identification Summary " + additionalName;
        }
        return "Identification Summary " + rSetName;
    }

    public static class TransientData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private PeptideInstance[] peptideInstanceArray = null;
        private long[] peptideMatchesId;
        private DPeptideMatch[] peptideMatches;
        private DProteinSet[] proteinSetArray = null;
        private Dataset dataSet = null;
        private DDataset dDataset = null;
        private Integer numberOfProteinSets = null;
        private Integer numberOfPeptides = null;
        private Integer numberOfPeptideMatches = null;
        private Integer numberOfProteins = null;

        protected TransientData() {
        }

        public PeptideInstance[] getPeptideInstanceArray() {
            return this.peptideInstanceArray;
        }

        public void setPeptideInstanceArray(PeptideInstance[] peptideInstanceArray) {
            this.peptideInstanceArray = peptideInstanceArray;
        }

        public Integer getNumberOfProteinSet() {
            return this.numberOfProteinSets;
        }

        public void setNumberOfProteinSet(Integer numberOfProteinSets) {
            this.numberOfProteinSets = numberOfProteinSets;
        }

        public Dataset getDataSet() {
            return this.dataSet;
        }

        public void setDataSet(Dataset dataSet) {
            this.dataSet = dataSet;
        }

        public DDataset getDDataset() {
            return this.dDataset;
        }

        public void setDDataset(DDataset dataset) {
            this.dDataset = dataset;
        }

        public DProteinSet[] getProteinSetArray() {
            return this.proteinSetArray;
        }

        public void setProteinSetArray(DProteinSet[] proteinSetArray) {
            this.proteinSetArray = proteinSetArray;
            if (proteinSetArray != null) {
                this.numberOfProteinSets = proteinSetArray.length;
            }
        }

        public DPeptideMatch[] getPeptideMatches() {
            return this.peptideMatches;
        }

        public void setPeptideMatches(DPeptideMatch[] peptideMatches) {
            this.peptideMatches = peptideMatches;
        }

        public long[] getPeptideMatchesId() {
            return this.peptideMatchesId;
        }

        public void setPeptideMatchesId(long[] peptideMatchesId) {
            this.peptideMatchesId = peptideMatchesId;
        }

        public Integer getNumberOfProteinSets() {
            return this.numberOfProteinSets;
        }

        public void setNumberOfProteinSets(Integer numberOfProteinSets) {
            this.numberOfProteinSets = numberOfProteinSets;
        }

        public Integer getNumberOfPeptides() {
            return this.numberOfPeptides;
        }

        public void setNumberOfPeptides(Integer numberOfPeptides) {
            this.numberOfPeptides = numberOfPeptides;
        }

        public Integer getNumberOfPeptideMatches() {
            return this.numberOfPeptideMatches;
        }

        public void setNumberOfPeptideMatches(Integer numberOfPeptideMatches) {
            this.numberOfPeptideMatches = numberOfPeptideMatches;
        }

        public Integer getNumberOfProteins() {
            return this.numberOfProteins;
        }

        public void setNumberOfProteins(Integer numberOfProteins) {
            this.numberOfProteins = numberOfProteins;
        }
    }
}

