/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.msi.dto;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class DSpectrum {
    public static final int MASSES_INDEX = 0;
    public static final int INTENSITIES_INDEX = 1;
    private long m_id;
    private Integer m_firstScan;
    private Integer m_lastScan;
    private Float m_firstTime;
    private Float m_lastTime;
    private byte[] m_intensityList = null;
    private byte[] m_mozList = null;
    private double[][] m_massIntensitiesValues = null;
    private Integer m_precursorCharge;
    private Float m_precursorIntensity;
    private Double m_precursorMoz;
    private String m_title = null;

    public DSpectrum() {
    }

    public DSpectrum(long id, Integer firstScan, Float firstTime, Float lastTime, byte[] intensityList, byte[] mozeList, Integer precursorCharge, Float precursorIntensity, Double precursorMoz, String title) {
        this.m_id = id;
        this.m_firstScan = firstScan;
        this.m_firstTime = firstTime;
        this.m_lastTime = lastTime;
        this.m_intensityList = intensityList;
        this.m_mozList = mozeList;
        this.m_precursorCharge = precursorCharge;
        this.m_precursorIntensity = precursorIntensity;
        this.m_precursorMoz = precursorMoz;
        this.m_title = title;
    }

    public double[] getMasses() {
        return this.getMassIntensityValues()[0];
    }

    public double[] getIntensities() {
        return this.getMassIntensityValues()[1];
    }

    public double[][] getMassIntensityValues() {
        if (this.m_massIntensitiesValues == null) {
            if (this.m_intensityList == null || this.m_mozList == null) {
                return null;
            }
            ByteBuffer intensityByteBuffer = ByteBuffer.wrap(this.m_intensityList).order(ByteOrder.LITTLE_ENDIAN);
            FloatBuffer intensityFloatBuffer = intensityByteBuffer.asFloatBuffer();
            double[] intensityDoubleArray = new double[intensityFloatBuffer.remaining()];
            for (int i = 0; i < intensityDoubleArray.length; ++i) {
                intensityDoubleArray[i] = intensityFloatBuffer.get();
            }
            ByteBuffer massByteBuffer = ByteBuffer.wrap(this.m_mozList).order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer massDoubleBuffer = massByteBuffer.asDoubleBuffer();
            double[] massDoubleArray = new double[massDoubleBuffer.remaining()];
            for (int i = 0; i < massDoubleArray.length; ++i) {
                massDoubleArray[i] = massDoubleBuffer.get();
            }
            int size = intensityDoubleArray.length;
            this.m_massIntensitiesValues = new double[2][size];
            for (int i = 0; i < size; ++i) {
                this.m_massIntensitiesValues[0][i] = massDoubleArray[i];
                this.m_massIntensitiesValues[1][i] = intensityDoubleArray[i];
            }
        }
        return this.m_massIntensitiesValues;
    }

    public long getId() {
        return this.m_id;
    }

    public void setId(long id) {
        this.m_id = id;
    }

    public Integer getFirstScan() {
        return this.m_firstScan;
    }

    public void setFirstScan(Integer firstScan) {
        this.m_firstScan = firstScan;
    }

    public Integer getLastScan() {
        return this.m_lastScan;
    }

    public void setLastScan(Integer lastScan) {
        this.m_lastScan = lastScan;
    }

    public Float getFirstTime() {
        return this.m_firstTime;
    }

    public void setFirstTime(Float firstTime) {
        this.m_firstTime = firstTime;
    }

    public byte[] getIntensityList() {
        return this.m_intensityList;
    }

    public void setIntensityList(byte[] intensityList) {
        this.m_intensityList = intensityList;
    }

    public Float getLastTime() {
        return this.m_lastTime;
    }

    public void setLastTime(Float lastTime) {
        this.m_lastTime = lastTime;
    }

    public byte[] getMozList() {
        return this.m_mozList;
    }

    public void setMozList(byte[] mozList) {
        this.m_mozList = mozList;
    }

    public Integer getPrecursorCharge() {
        return this.m_precursorCharge;
    }

    public void setPrecursorCharge(Integer precursorCharge) {
        this.m_precursorCharge = precursorCharge;
    }

    public Float getPrecursorIntensity() {
        return this.m_precursorIntensity;
    }

    public void setPrecursorIntensity(Float precursorIntensity) {
        this.m_precursorIntensity = precursorIntensity;
    }

    public Double getPrecursorMoz() {
        return this.m_precursorMoz;
    }

    public void setPrecursorMoz(Double precursorMoz) {
        this.m_precursorMoz = precursorMoz;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }
}

