/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.uds.SpectrumTitleParsingRule;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity(name="fr.proline.core.orm.uds.PeaklistSoftware")
@NamedQueries(value={@NamedQuery(name="findUdsPeaklistSoftForName", query="select pls from fr.proline.core.orm.uds.PeaklistSoftware pls where (upper(pls.name) = :name) and (pls.version is null)"), @NamedQuery(name="findUdsPeaklistSoftForNameAndVersion", query="select pls from fr.proline.core.orm.uds.PeaklistSoftware pls where (upper(pls.name) = :name) and (upper(pls.version) = :version)")})
@Table(name="peaklist_software")
public class PeaklistSoftware
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    private String name;
    @Column(name="serialized_properties")
    private String serializedProperties;
    private String version;
    @ManyToOne
    @JoinColumn(name="spec_title_parsing_rule_id")
    private SpectrumTitleParsingRule specTitleParsingRule;

    public long getId() {
        return this.id;
    }

    public void setId(long pId) {
        this.id = pId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public SpectrumTitleParsingRule getSpecTitleParsingRule() {
        return this.specTitleParsingRule;
    }

    public void setSpecTitleParsingRule(SpectrumTitleParsingRule specTitleParsingRule) {
        this.specTitleParsingRule = specTitleParsingRule;
    }

    public static final class SoftwareRelease
    extends Enum<SoftwareRelease> {
        public static final /* enum */ SoftwareRelease EXTRACT_MSN = new SoftwareRelease("extract_msn.exe");
        public static final /* enum */ SoftwareRelease DATA_ANALYSIS_4_0 = new SoftwareRelease("Data Analysis", "4.0");
        public static final /* enum */ SoftwareRelease DATA_ANALYSIS_4_1 = new SoftwareRelease("Data Analysis", "4.1");
        public static final /* enum */ SoftwareRelease MASCOT_DLL = new SoftwareRelease("mascot.dll");
        public static final /* enum */ SoftwareRelease MASCOT_DISTILLER = new SoftwareRelease("Mascot Distiller", "2.5");
        public static final /* enum */ SoftwareRelease MAX_QUANT = new SoftwareRelease("MaxQuant");
        public static final /* enum */ SoftwareRelease PROLINE = new SoftwareRelease("Proline", "1.0");
        public static final /* enum */ SoftwareRelease PROTEIN_PILOT = new SoftwareRelease("Protein Pilot");
        public static final /* enum */ SoftwareRelease PROTEOME_DISCOVER = new SoftwareRelease("Proteome Discoverer");
        public static final /* enum */ SoftwareRelease PROTEO_WIZARD_2_0 = new SoftwareRelease("ProteoWizard", "2.0");
        public static final /* enum */ SoftwareRelease PROTEO_WIZARD_2_1 = new SoftwareRelease("ProteoWizard", "2.1");
        public static final /* enum */ SoftwareRelease PROTEO_WIZARD_3_0 = new SoftwareRelease("ProteoWizard", "3.0");
        public static final /* enum */ SoftwareRelease SPECTRUM_MILL = new SoftwareRelease("Spectrum Mill");
        private final String m_name;
        private final String m_version;
        private static final /* synthetic */ SoftwareRelease[] $VALUES;

        public static SoftwareRelease[] values() {
            return (SoftwareRelease[])$VALUES.clone();
        }

        public static SoftwareRelease valueOf(String name) {
            return Enum.valueOf(SoftwareRelease.class, name);
        }

        private SoftwareRelease(String name, String version) {
            assert (!StringUtils.isEmpty((String)name)) : "PeaklistSoftware.SoftwareRelease() invalid name";
            assert (!StringUtils.isEmpty((String)version)) : "PeaklistSoftware.Definition() invalid version";
            this.m_name = name;
            this.m_version = version;
        }

        private SoftwareRelease(String name) {
            assert (!StringUtils.isEmpty((String)name)) : "PeaklistSoftware.SoftwareRelease() invalid name";
            this.m_name = name;
            this.m_version = "";
        }

        public String getName() {
            return this.m_name;
        }

        public String getVersion() {
            return this.m_version;
        }

        public String toString() {
            if (StringUtils.isEmpty((String)this.m_version)) {
                return this.m_name;
            }
            return this.m_name + " " + this.m_version;
        }

        static {
            $VALUES = new SoftwareRelease[]{EXTRACT_MSN, DATA_ANALYSIS_4_0, DATA_ANALYSIS_4_1, MASCOT_DLL, MASCOT_DISTILLER, MAX_QUANT, PROLINE, PROTEIN_PILOT, PROTEOME_DISCOVER, PROTEO_WIZARD_2_0, PROTEO_WIZARD_2_1, PROTEO_WIZARD_3_0, SPECTRUM_MILL};
        }
    }
}

