/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.Run;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

@Entity
@Table(name="raw_file")
public class RawFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="identifier")
    private String identifier;
    @Column(name="raw_file_name")
    private String rawFileName;
    @Column(name="raw_file_directory")
    private String rawFileDirectory;
    @Column(name="mzdb_file_name")
    private String mzdbFileName;
    @Column(name="mzdb_file_directory")
    private String mzdbFileDirectory;
    @Column(name="sample_name")
    private String sampleName;
    @Column(name="creation_timestamp")
    private Timestamp creationTimestamp;
    @Column(name="serialized_properties")
    private String serializedProperties;
    @Column(name="owner_id")
    private long ownerId;
    @OneToMany(mappedBy="rawFile")
    @OrderBy(value="number")
    private List<Run> runs;
    @ManyToMany(mappedBy="rawFiles")
    private Set<Project> projects;

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String id) {
        this.identifier = id;
    }

    public Timestamp getCreationTimestamp() {
        Timestamp result = null;
        if (this.creationTimestamp != null) {
            result = (Timestamp)this.creationTimestamp.clone();
        }
        return result;
    }

    public void setCreationTimestamp(Timestamp pCreationTimestamp) {
        this.creationTimestamp = pCreationTimestamp == null ? null : (Timestamp)pCreationTimestamp.clone();
    }

    public String getRawFileName() {
        return this.rawFileName;
    }

    public void setRawFileName(String rawFileName) {
        this.rawFileName = rawFileName;
    }

    public String getRawFileDirectory() {
        return this.rawFileDirectory;
    }

    public void setRawFileDirectory(String rawDirectory) {
        this.rawFileDirectory = rawDirectory;
    }

    public String getMzDbFileName() {
        return this.mzdbFileName;
    }

    public void setMzDbFileName(String mzdbFileName) {
        this.mzdbFileName = mzdbFileName;
    }

    public String getMzDbFileDirectory() {
        return this.mzdbFileDirectory;
    }

    public void setMzDbFileDirectory(String mzDirectory) {
        this.mzdbFileDirectory = mzDirectory;
    }

    public String getSampleName() {
        return this.sampleName;
    }

    public void setSampleName(String sampleName) {
        this.sampleName = sampleName;
    }

    public String getSerializedProperties() {
        return this.serializedProperties;
    }

    public void setSerializedProperties(String serializedProperties) {
        this.serializedProperties = serializedProperties;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(long pOwnerId) {
        this.ownerId = pOwnerId;
    }

    public List<Run> getRuns() {
        return this.runs;
    }

    public void setRuns(List<Run> runs) {
        this.runs = runs;
    }

    public void setProjects(Set<Project> pProjects) {
        this.projects = pProjects;
    }

    public Set<Project> getProjects() {
        return this.projects;
    }

    public void addProject(Project project) {
        if (project != null) {
            Set<Project> localProjects = this.getProjects();
            if (localProjects == null) {
                localProjects = new HashSet<Project>();
                this.setProjects(localProjects);
            }
            localProjects.add(project);
        }
    }

    public void removeProject(Project project) {
        Set<Project> localProjects = this.getProjects();
        if (localProjects != null) {
            localProjects.remove(project);
        }
    }
}

