/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds.repository;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.ProjectUserAccountMap;
import fr.proline.repository.util.JPAUtils;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public final class ProjectRepository {
    private ProjectRepository() {
    }

    public static List<Project> findProjects(EntityManager udsEm, long userAccountId) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        TypedQuery query = udsEm.createNamedQuery("findProjectUserMapsByMembership", ProjectUserAccountMap.class);
        query.setParameter("id", (Object)userAccountId);
        List result = query.getResultList();
        ArrayList<Project> projects = new ArrayList<Project>(result.size());
        for (ProjectUserAccountMap nextMap : result) {
            projects.add(nextMap.getProject());
        }
        return projects;
    }

    public static List<Project> findOwnedProjects(EntityManager udsEm, long userAccountId) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        TypedQuery query = udsEm.createNamedQuery("findProjectsByOwner", Project.class);
        query.setParameter("id", (Object)userAccountId);
        return query.getResultList();
    }

    public static List<Long> findAllProjectIds(EntityManager udsEm) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        TypedQuery query = udsEm.createNamedQuery("findAllProjectIds", Long.class);
        return query.getResultList();
    }

    public static List<Long> findAllActiveProjectIds(EntityManager udsEm) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        TypedQuery query = udsEm.createNamedQuery("findAllActiveProjectIds", Long.class);
        return query.getResultList();
    }
}

