/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.uds.repository;

import fr.profi.util.StringUtils;
import fr.proline.core.orm.uds.QuantitationMethod;
import fr.proline.repository.util.JPAUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;

public class QuantitationMethodRepository {
    private QuantitationMethodRepository() {
    }

    public static QuantitationMethod findQuantMethodForTypeAndAbundanceUnit(EntityManager udsEm, String typeName, String abundanceUnit) {
        JPAUtils.checkEntityManager((EntityManager)udsEm);
        if (StringUtils.isEmpty((String)typeName)) {
            throw new IllegalArgumentException("Invalid type name");
        }
        if (StringUtils.isEmpty((String)abundanceUnit)) {
            throw new IllegalArgumentException("Invalid abundanceUnit");
        }
        QuantitationMethod result = null;
        TypedQuery query = udsEm.createNamedQuery("findQuantMethodForTypeAndUnit", QuantitationMethod.class);
        query.setParameter("searchType", (Object)typeName.toUpperCase());
        query.setParameter("searchAbundanceUnit", (Object)abundanceUnit.toUpperCase());
        List quantMethods = query.getResultList();
        if (quantMethods != null && !quantMethods.isEmpty()) {
            if (quantMethods.size() == 1) {
                result = (QuantitationMethod)quantMethods.get(0);
            } else {
                throw new NonUniqueResultException("There are more than one QuantitationMethod for given type and abundanceUnit");
            }
        }
        return result;
    }
}

