/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.core.orm.util;

import fr.profi.util.StringUtils;
import fr.profi.util.ThreadLogger;
import fr.proline.core.orm.uds.ExternalDb;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.repository.ExternalDbRepository;
import fr.proline.core.orm.util.AbstractDSConnectorFactory;
import fr.proline.repository.DatabaseConnectorFactory;
import fr.proline.repository.IDatabaseConnector;
import fr.proline.repository.ProlineDatabaseType;
import java.util.Map;
import javax.persistence.EntityManager;

public class DStoreCustomPoolConnectorFactory
extends AbstractDSConnectorFactory {
    private static final DStoreCustomPoolConnectorFactory UNIQUE_INSTANCE = new DStoreCustomPoolConnectorFactory();
    protected String m_applicationName;
    protected Integer m_projectMaxPoolConnection;

    protected DStoreCustomPoolConnectorFactory() {
    }

    public static DStoreCustomPoolConnectorFactory getInstance() {
        return UNIQUE_INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(Map<Object, Object> udsDbProperties, String applicationName) {
        Object object = this.m_managerLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new IllegalStateException("This IDataStoreConnectorFactory ALREADY initialized");
            }
            if (udsDbProperties == null) {
                throw new IllegalArgumentException("UdsDbProperties Map is null");
            }
            this.initialize(DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)ProlineDatabaseType.UDS, udsDbProperties), applicationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(String udsDbPropertiesFileName, String applicationName) {
        Object object = this.m_managerLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new IllegalStateException("IDataStoreConnectorFactory ALREADY initialized");
            }
            if (StringUtils.isEmpty((String)udsDbPropertiesFileName)) {
                throw new IllegalArgumentException("Invalid udsDbPropertiesFileName");
            }
            this.initialize(DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)ProlineDatabaseType.UDS, (String)udsDbPropertiesFileName), applicationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(IDatabaseConnector udsDbConnector, String applicationName) {
        Object object = this.m_managerLock;
        synchronized (object) {
            if (this.isInitialized()) {
                throw new IllegalStateException("DataStoreConnectorFactory ALREADY initialized");
            }
            if (udsDbConnector == null) {
                throw new UnsupportedOperationException("UdsDbConnector is null");
            }
            Thread currentThread = Thread.currentThread();
            if (!(currentThread.getUncaughtExceptionHandler() instanceof ThreadLogger)) {
                currentThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(LOG));
            }
            this.m_udsDbConnector = udsDbConnector;
            this.m_applicationName = applicationName;
            try {
                this.m_projectMaxPoolConnection = Integer.parseInt(this.m_udsDbConnector.getProperty((Object)"proline.project.max.pool.connection").toString());
            }
            catch (NumberFormatException nfe) {
                this.m_projectMaxPoolConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IDatabaseConnector createProjectDatabaseConnector(long projectId, ProlineDatabaseType prolineDbType, Map<Long, Map<Object, Object>> propertiesMaps) {
        IDatabaseConnector dbConnector = null;
        Object object = this.m_managerLock;
        synchronized (object) {
            this.checkInitialization();
            Long key = projectId;
            Map<Object, Object> propertiesMap = propertiesMaps.get(key);
            if (propertiesMap == null) {
                propertiesMap = this.retrieveExternalDbProperties(prolineDbType, projectId);
                propertiesMaps.put(key, propertiesMap);
            }
            if (this.m_projectMaxPoolConnection != null) {
                propertiesMap.put("proline.project.max.pool.connection", this.m_projectMaxPoolConnection);
            }
            dbConnector = DatabaseConnectorFactory.createDatabaseConnectorInstance((ProlineDatabaseType)prolineDbType, propertiesMap);
        }
        return dbConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, Object> retrieveExternalDbProperties(ProlineDatabaseType prolineDbType, long projectId) {
        Map<Object, Object> propertiesMap = null;
        IDatabaseConnector udsDbConnector = this.getUdsDbConnector();
        EntityManager udsEm = udsDbConnector.createEntityManager();
        try {
            Project project = (Project)udsEm.find(Project.class, (Object)projectId);
            if (project == null) {
                throw new IllegalArgumentException("Project #" + projectId + " NOT found in UDS Db");
            }
            ExternalDb externalDb = ExternalDbRepository.findExternalByTypeAndProject(udsEm, prolineDbType, project);
            if (externalDb == null) {
                LOG.warn("No ExternalDb for {} Db of project #{}", (Object)prolineDbType, (Object)projectId);
            } else {
                propertiesMap = externalDb.toPropertiesMap(udsDbConnector.getDriverType(), (String)udsDbConnector.getProperty((Object)"javax.persistence.jdbc.user"), (String)udsDbConnector.getProperty((Object)"javax.persistence.jdbc.password"));
                propertiesMap.put("ApplicationName", this.m_applicationName);
            }
        }
        finally {
            try {
                udsEm.close();
            }
            catch (Exception exClose) {
                LOG.error("Error closing UDS Db EntityManager", (Throwable)exClose);
            }
        }
        return propertiesMap;
    }
}

