/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class CancelTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/misc/CancelService";
    private String m_messageId;

    public CancelTask(String msgID) {
        super(null, new TaskInfo("Send Cancel request to message " + msgID, false, "Services JMS", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_messageId = msgID;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("cancel", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = AccessJMSManagerThread.getAccessJMSManagerThread().getSession().createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setJMSCorrelationID(this.m_messageId);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSourceToMessage((Message)message);
        this.addDescriptionToMessage((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("CancelTask Message [{}] sent ", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message_id", this.m_messageId);
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null) {
                m_loggerProline.debug("NULL result");
                throw new Exception("NULL result ");
            }
            m_loggerProline.debug("Result :\n" + result);
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

