/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import fr.proline.studio.dam.taskinfo.TaskError;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class DownloadFileTask
extends AbstractJMSTask {
    private final String m_remoteFileURL;
    private final File m_localFile;
    private boolean m_showError;

    public DownloadFileTask(AbstractJMSCallback callback, String remoteFileURL, File localFile) {
        super(callback, new TaskInfo("Download file " + remoteFileURL, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_MEDIUM));
        this.m_remoteFileURL = remoteFileURL;
        this.m_localFile = localFile;
        this.m_showError = true;
    }

    public DownloadFileTask(AbstractJMSCallback callback, String remoteFileURL, File localFile, boolean showError) {
        this(callback, remoteFileURL, localFile);
        this.m_showError = showError;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("get_resource_as_stream", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = AccessJMSManagerThread.getAccessJMSManagerThread().getSession().createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/misc/ProlineResourceService");
        this.addSourceToMessage((Message)message);
        this.addDescriptionToMessage((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> namedParams = new HashMap<String, Object>();
        namedParams.put("file_path", this.m_remoteFileURL);
        return namedParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        if (jmsMessage instanceof BytesMessage) {
            boolean success = false;
            FilterOutputStream bos = null;
            String errorMsg = "";
            try {
                bos = new BufferedOutputStream(new FileOutputStream(this.m_localFile.getAbsolutePath()));
                m_loggerProline.debug("Saving stream to File [" + this.m_localFile.getAbsolutePath() + ']');
                jmsMessage.setObjectProperty("JMS_HQ_SaveStream", (Object)bos);
                success = true;
            }
            catch (FileNotFoundException | JMSException ex) {
                m_loggerProline.error("Error handling JMS_HQ_SaveStream OutputStream [" + this.m_localFile.getAbsolutePath() + ']', ex);
                errorMsg = "Error handling JMS_HQ_SaveStream OutputStream [" + this.m_localFile.getAbsolutePath() + "] (" + ex.getMessage() + ")";
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                        if (success) {
                            m_loggerProline.info("File [" + this.m_localFile.getAbsolutePath() + "] Saved");
                        }
                    }
                    catch (IOException ioEx) {
                        m_loggerProline.error("Error closing OutputStream [" + this.m_localFile.getAbsolutePath() + ']', (Throwable)ioEx);
                        errorMsg = "Error closing OutputStream [" + this.m_localFile.getAbsolutePath() + "] (" + ioEx.getMessage() + ")";
                    }
                }
            }
            if (!errorMsg.isEmpty()) {
                throw new Exception(errorMsg);
            }
        } else {
            if (jmsMessage instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)jmsMessage;
                String jsonString = textMessage.getText();
                throw new Exception(" Invalide message type to download file ! " + jsonString);
            }
            throw new Exception(" Invalide message type to download file ! ");
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }

    @Override
    protected void showError(TaskError taskErr) {
        if (this.m_showError) {
            super.showError(taskErr);
        }
    }
}

