/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.openide.util.Exceptions;

public class FileUploadTask
extends AbstractJMSTask {
    private static final int UPLOAD_GENERIC_FILE = 0;
    private static final int UPLOAD_MAXQUANT_FILE = 1;
    private static final int UPLOAD_MZDB_FILE = 2;
    private int m_action = 1;
    private String m_mountLabel;
    private String m_filePath;
    private String[] m_remoteFilePath = null;
    private String m_destinationPath = null;

    public FileUploadTask(AbstractJMSCallback callback, String filePath, String[] remoteFilePath) {
        super(callback, new TaskInfo("Upload file " + filePath, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_filePath = filePath;
        this.m_remoteFilePath = remoteFilePath;
    }

    public void initUploadMaxquantFile() {
        this.m_action = 1;
    }

    public void initUploadGenericFile(String mountLabel, String destinationPath) {
        this.m_action = 0;
        this.m_mountLabel = mountLabel;
        this.m_destinationPath = destinationPath;
    }

    public void initUploadMZDB(String mountLabel, String destinationPath) {
        this.m_action = 2;
        this.m_mountLabel = mountLabel;
        this.m_destinationPath = destinationPath;
    }

    @Override
    public void taskRun() throws JMSException {
        InputStream in = null;
        try {
            BytesMessage message = AccessJMSManagerThread.getAccessJMSManagerThread().getSession().createBytesMessage();
            File uploadFile = null;
            if (this.m_action == 0) {
                m_loggerProline.debug("Prepare to upload file " + this.m_filePath);
                uploadFile = new File(this.m_filePath);
            } else if (this.m_action == 1) {
                m_loggerProline.debug("Prepare MaxQuant Import First Step : Upload Files from " + this.m_filePath);
                List<String> files2Zip = FileUploadTask.getZipFilesList(this.m_filePath);
                uploadFile = FileUploadTask.zipIt(this.m_filePath, files2Zip);
            } else if (this.m_action == 2) {
                m_loggerProline.debug("Prepare to upload mzDB file " + this.m_filePath);
                uploadFile = new File(this.m_filePath);
            }
            message.setJMSReplyTo((Destination)this.m_replyQueue);
            message.setStringProperty("Proline_ServiceName", "proline/misc/FileUpload");
            message.setStringProperty("dest_file_name", uploadFile.getName());
            if (this.m_action == 2 || this.m_action == 0) {
                message.setStringProperty("dest_folder_path", this.m_mountLabel + this.m_destinationPath);
            }
            this.addSourceToMessage((Message)message);
            this.addDescriptionToMessage((Message)message);
            in = new FileInputStream(uploadFile);
            BufferedInputStream inBuf = new BufferedInputStream(in);
            message.setObjectProperty("JMS_HQ_InputStream", (Object)inBuf);
            this.setTaskInfoRequest("Call Service proline/misc/FileUpload with dest_file_name " + uploadFile.getName());
            this.m_producer.send((Message)message);
            m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
            this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
        }
        catch (FileNotFoundException ex) {
            throw new JMSException(ex.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            String returnedValues;
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !String.class.isInstance(result)) {
                m_loggerProline.error(((Object)((Object)this)).getClass().getSimpleName() + " failed : No returned values");
                throw new Exception("Invalid result " + result);
            }
            this.m_remoteFilePath[0] = returnedValues = (String)result;
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }

    private static List<String> getZipFilesList(String rootFolder) {
        String[] dataFilesNames;
        String[] filesNames;
        File rootFolderFile = new File(rootFolder);
        String subFolderString = "combined/txt";
        File subTxtFolder = new File(rootFolderFile, subFolderString);
        if (!subTxtFolder.exists() && !subTxtFolder.isDirectory()) {
            throw new RuntimeException(" Uncomplete source folder ");
        }
        ArrayList<String> acceptedFiles = new ArrayList<String>();
        for (String f : filesNames = rootFolderFile.list()) {
            if (!f.equals("mqpar.xml")) continue;
            acceptedFiles.add(f);
        }
        for (String name : dataFilesNames = subTxtFolder.list()) {
            if (!name.equals("msms.txt") && !name.equals("msmsScans.txt") && !name.equals("parameters.txt") && !name.equals("proteinGroups.txt") && !name.equals("summary.txt") && !name.equals("allPeptides.txt") && !name.equals("evidence.txt")) continue;
            acceptedFiles.add(subFolderString + "/" + name);
        }
        return acceptedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File zipIt(String sourceDir, List<String> files2Zip) {
        byte[] buffer = new byte[1024];
        ZipOutputStream zos = null;
        try {
            File sourceDirFile = new File(sourceDir);
            String zipSource = sourceDirFile.getName();
            File zipFile = new File(sourceDir, zipSource + ".zip");
            FileOutputStream fos = new FileOutputStream(zipFile);
            zos = new ZipOutputStream(fos);
            FileInputStream in = null;
            for (String file : files2Zip) {
                m_loggerProline.debug("-- Add file: " + file);
                ZipEntry ze = new ZipEntry(zipSource + "/" + file);
                zos.putNextEntry(ze);
                try {
                    int len;
                    in = new FileInputStream(sourceDir + "/" + file);
                    while ((len = in.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            zos.closeEntry();
            m_loggerProline.debug("data successfully compressed");
            File file = zipFile;
            return file;
        }
        catch (IOException ex) {
            String msg = "Error while creating Zip " + sourceDir;
            m_loggerProline.error(msg);
            throw new RuntimeException(msg, ex);
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException e) {
                m_loggerProline.error("Error while closing Zip OutputStream");
            }
        }
    }
}

