/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.util.TransientDataAllocationListener;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class FilterProteinSetsTask
extends AbstractJMSTask {
    private static final String m_serviceName = "proline/dps/msi/FilterRSMProteinSets";
    private final DDataset m_dataset;
    private final HashMap<String, String> m_argumentsMap;

    public FilterProteinSetsTask(AbstractJMSCallback callback, DDataset dataset, HashMap<String, String> argumentsMap) {
        super(callback, new TaskInfo("PSMFilter Protein Sets of Identification Summary " + dataset.getName(), true, "Services JMS", TaskInfo.INFO_IMPORTANCE_HIGH));
        this.m_argumentsMap = argumentsMap;
        this.m_dataset = dataset;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("process", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = AccessJMSManagerThread.getAccessJMSManagerThread().getSession().createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", m_serviceName);
        this.addSourceToMessage((Message)message);
        this.addDescriptionToMessage((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private Map<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project_id", this.m_dataset.getProject().getId());
        params.put("result_summary_id", this.m_dataset.getResultSummaryId());
        ArrayList proteinFilters = new ArrayList();
        for (Filter filter : Filter.values()) {
            if (!this.m_argumentsMap.containsKey(filter.key)) continue;
            HashMap<String, Object> filterCfg = new HashMap<String, Object>();
            filterCfg.put("parameter", filter.key);
            if (filter == Filter.SCORE) {
                filterCfg.put("threshold", Double.valueOf(this.m_argumentsMap.get(filter.key)));
            } else {
                filterCfg.put("threshold", Integer.valueOf(this.m_argumentsMap.get(filter.key)));
            }
            proteinFilters.add(filterCfg);
        }
        params.put("prot_set_filters", proteinFilters);
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !Boolean.class.isInstance(result)) {
                m_loggerProline.debug("Invalid result");
                throw new Exception("Invalid result " + result);
            }
            m_loggerProline.debug("Result :\n" + result);
            if (this.m_dataset.getResultSummary() != null) {
                this.m_dataset.getResultSummary().getTransientData((TransientDataAllocationListener)TransientMemoryCacheManager.getSingleton()).setProteinSetArray(null);
            }
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }

    public static enum Filter {
        SPECIFIC_PEP("SPECIFIC_PEP", "Specific Peptides"),
        PEP_COUNT("PEP_COUNT", "Peptides count"),
        PEP_SEQ_COUNT("PEP_SEQ_COUNT", "Peptide sequence count"),
        SCORE("SCORE", "Protein Set Score");

        public final String key;
        public final String name;

        private Filter(String key, String name) {
            this.key = key;
            this.name = name;
        }
    }
}

